/*
 * Copyright (c) 2001 by Sun Microsystems, Inc.
 * All rights reserved.
 */

#ifndef	_ERRORQ_IMPL_H
#define	_ERRORQ_IMPL_H

#pragma ident	"@(#)errorq_impl.h	1.1	01/08/28 SMI"

#include <sys/errorq.h>
#include <sys/dditypes.h>
#include <sys/kstat.h>

#ifdef	__cplusplus
extern "C" {
#endif

typedef struct errorq_elem {
	struct errorq_elem *eqe_next;		/* next on processing list */
	struct errorq_elem *eqe_prev;		/* prev on free or pend list */
	void *eqe_data;				/* data for this element */
} errorq_elem_t;

typedef struct errorq_kstat {
	kstat_named_t eqk_dispatched;		/* total errors dispatched */
	kstat_named_t eqk_dropped;		/* total errors dropped */
	kstat_named_t eqk_logged;		/* total errors logged */
} errorq_kstat_t;

/*
 * errorq implementation flags: bit range 16-31
 */
#define	ERRORQ_ACTIVE	0x00010000		/* queue is enabled */

#define	ERRORQ_NAMELEN	31			/* length of queue name */

struct errorq {
	char eq_name[ERRORQ_NAMELEN + 1];	/* string name for debugging */
	errorq_kstat_t eq_kstat;		/* kstat data (see above) */
	kstat_t *eq_ksp;			/* pointer to installed kstat */
	errorq_func_t eq_func;			/* drain callback */
	void *eq_private;			/* drain callback data */
	void *eq_data;				/* buffer of queue data */
	ulong_t eq_qlen;			/* maximum queue length */
	size_t eq_size;				/* size of element data */
	uint_t eq_ipl;				/* soft interrupt priority */
	uint_t eq_flags;			/* flags (see above) */
	ddi_softintr_t eq_id;			/* soft interrupt identifier */
	kmutex_t eq_lock;			/* consumer lock */
	errorq_elem_t *eq_elems;		/* array of all elements */
	errorq_elem_t *eq_phead;		/* head of processing list */
	errorq_elem_t *eq_ptail;		/* tail of processing list */
	errorq_elem_t *eq_pend;			/* list of pending errors */
	errorq_elem_t *eq_free;			/* list of free elements */
	struct errorq *eq_next;			/* next errorq on global list */
};

#ifdef	__cplusplus
}
#endif

#endif	/* _ERRORQ_IMPL_H */
