/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.management;

import opencard.core.service.CardServiceException;
import opencard.core.util.HexString;
import opencard.core.util.Tracer;
import opencard.opt.management.ApplicationID;
import opencard.opt.management.EMVTags;
import opencard.opt.util.TLV;

public class ApplicationTemplate
implements EMVTags {
    private Tracer itracer = new Tracer((Object)this, class$opencard$opt$management$ApplicationTemplate != null ? class$opencard$opt$management$ApplicationTemplate : (class$opencard$opt$management$ApplicationTemplate = ApplicationTemplate.class$("opencard.opt.management.ApplicationTemplate")));
    protected byte[] name = null;
    protected byte[] label = null;
    protected byte[] prefName = null;
    protected byte[] command = null;
    protected byte[] data = null;
    protected byte[] prioInd = null;
    static /* synthetic */ Class class$opencard$opt$management$ApplicationTemplate;

    private ApplicationTemplate() {
    }

    public ApplicationTemplate(String string) {
        this.label = string.getBytes();
    }

    public ApplicationTemplate(ApplicationID applicationID, String string) {
        this.label = string.getBytes();
        this.name = applicationID.getAID();
    }

    public ApplicationTemplate(TLV tLV) {
        try {
            TLV tLV2 = tLV.findTag(EMVTags.TAG_EMV_ADF_NAME, null);
            if (tLV2 == null) {
                throw new CardServiceException("<init>: invalid ApplicationTemplate");
            }
            this.name = tLV2.valueAsByteArray();
            tLV2 = tLV.findTag(EMVTags.TAG_EMV_APP_LABEL, null);
            if (tLV2 == null) {
                throw new CardServiceException("<init>: invalid ApplicationTemplate");
            }
            this.label = tLV2.valueAsByteArray();
            tLV2 = tLV.findTag(EMVTags.TAG_EMV_APP_PREF_NAME, null);
            if (tLV2 == null) {
                this.itracer.debug("<init>", ": no app preferred name");
            }
            this.prefName = tLV2 == null ? null : tLV2.valueAsByteArray();
            tLV2 = tLV.findTag(EMVTags.TAG_EMV_APP_PRIO_IND, null);
            if (tLV2 == null) {
                this.itracer.debug("<init>", ": no app priority indicator");
            }
            this.prioInd = tLV2 == null ? null : tLV2.valueAsByteArray();
            tLV2 = tLV.findTag(EMVTags.TAG_EMV_CMD_TO_PERFORM, null);
            if (tLV2 == null) {
                this.itracer.debug("<init>", ": no command to perform");
            }
            this.command = tLV2 == null ? null : tLV2.valueAsByteArray();
            tLV2 = tLV.findTag(EMVTags.TAG_EMV_APP_DISCR_DATA, null);
            if (tLV2 == null) {
                this.itracer.debug("<init>", ": no app discretionary data");
            } else {
                this.itracer.debug("<init>", ": discretionary data is: " + HexString.hexify(tLV2.toBinaryContent()));
            }
            this.data = tLV2 == null ? null : tLV2.toBinaryContent();
        }
        catch (Exception exception) {}
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ApplicationID getApplicationID() throws CardServiceException {
        this.itracer.debug("getAID", "tag is " + EMVTags.TAG_EMV_ADF_NAME + " application ID is " + HexString.hexify(this.name));
        return new ApplicationID(this.name);
    }

    public byte[] getCommandToPerform() {
        this.itracer.debug("getCommandToPerform", "tag is " + EMVTags.TAG_EMV_CMD_TO_PERFORM + " command to perform is " + HexString.hexify(this.command));
        return this.command;
    }

    public byte[] getDiscretionaryData() {
        this.itracer.debug("getDiscretionaryData", "tag is " + EMVTags.TAG_EMV_APP_DISCR_DATA + " discretionary data is " + HexString.hexify(this.data));
        return this.data;
    }

    public byte[] getLabel() {
        this.itracer.debug("getLabel", "tag is " + EMVTags.TAG_EMV_APP_LABEL + " application label is " + new String(this.label));
        return this.label;
    }

    public byte[] getPreferredName() {
        this.itracer.debug("getPreferredName", "tag is " + EMVTags.TAG_EMV_APP_PREF_NAME + " application preferred name is " + new String(this.prefName));
        return this.prefName;
    }

    public byte[] getPriority() {
        this.itracer.debug("getPriority", "tag is " + EMVTags.TAG_EMV_APP_PRIO_IND + " application priority indicator is " + HexString.hexify(this.prioInd));
        return this.prioInd;
    }

    public void setLabel(byte[] byArray) {
        this.label = byArray;
    }

    public TLV toEMVTLV() {
        TLV tLV;
        if (this.name == null) {
            return null;
        }
        TLV tLV2 = new TLV(EMVTags.TAG_EMV_ADF_NAME, this.name);
        TLV tLV3 = new TLV(EMVTags.TAG_EMV_APP_TEMPLATE, tLV2);
        if (this.label != null) {
            tLV = new TLV(EMVTags.TAG_EMV_APP_LABEL, this.label);
            tLV3.add(tLV);
        }
        if (this.prefName != null) {
            tLV = new TLV(EMVTags.TAG_EMV_APP_PREF_NAME, this.prefName);
            tLV3.add(tLV);
        }
        if (this.command != null) {
            tLV = new TLV(EMVTags.TAG_EMV_CMD_TO_PERFORM, this.command);
            tLV3.add(tLV);
        }
        if (this.data != null) {
            tLV = new TLV(EMVTags.TAG_EMV_APP_DISCR_DATA, this.data);
            tLV3.add(tLV);
        }
        if (this.prioInd != null) {
            tLV = new TLV(EMVTags.TAG_EMV_APP_PRIO_IND, this.prioInd);
            tLV3.add(tLV);
        }
        System.out.println("I have built an app TLV: " + tLV3.toString());
        return tLV3;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("ApplicationTemplate:\n\t");
        stringBuffer.append("AID: ").append(HexString.hexify(this.name)).append("\n\t");
        stringBuffer.append("Label: ").append(new String(this.label)).append("\n\t");
        if (this.prefName != null) {
            stringBuffer.append("Preferred Name: ").append(new String(this.prefName)).append("\n\t");
        }
        if (this.prioInd != null) {
            stringBuffer.append("Priority indicator: ").append(HexString.hexify(this.prioInd)).append("\n\t");
        }
        if (this.command != null) {
            stringBuffer.append("Command to perform: ").append(HexString.hexify(this.command)).append("\n\t");
        }
        if (this.data != null) {
            stringBuffer.append("Discretionary data: ").append(HexString.hexify(this.data)).append("\n");
        }
        return stringBuffer.toString();
    }
}

