/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.service;

import opencard.core.service.CHVDialog;
import opencard.core.service.CardChannel;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardNotPresentException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.util.Tracer;

public abstract class CardService {
    private Tracer itracer = new Tracer((Object)this, class$opencard$core$service$CardService != null ? class$opencard$core$service$CardService : (class$opencard$core$service$CardService = CardService.class$("opencard.core.service.CardService")));
    private static Tracer ctracer = new Tracer(class$opencard$core$service$CardService != null ? class$opencard$core$service$CardService : (class$opencard$core$service$CardService = CardService.class$("opencard.core.service.CardService")));
    private SmartCard smart_card = null;
    private CardServiceScheduler cs_scheduler = null;
    private CardChannel card_channel = null;
    private boolean is_provided = false;
    private boolean is_blocking = false;
    private CHVDialog chv_dialog = null;
    static /* synthetic */ Class class$opencard$core$service$CardService;

    protected CardService() {
        ctracer.debug("<init>", "default constructor of " + this);
    }

    protected void allocateCardChannel() throws CardTerminalException {
        if (!this.is_provided) {
            this.assertSchedulerStillAlive();
            this.itracer.debug("allocateCardChannel", "allocating");
            this.card_channel = this.cs_scheduler.allocateCardChannel(this, this.is_blocking);
        }
    }

    private void assertSchedulerStillAlive() throws CardTerminalException {
        boolean bl = false;
        if (this.cs_scheduler != null) {
            bl = this.cs_scheduler.isAlive();
        }
        if (!bl) {
            this.card_channel = null;
            this.cs_scheduler = null;
            throw new CardNotPresentException(null, null, null);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public final CHVDialog getCHVDialog() {
        return this.chv_dialog;
    }

    public final SmartCard getCard() {
        return this.smart_card;
    }

    public final CardChannel getCardChannel() {
        return this.card_channel;
    }

    protected void initialize(CardServiceScheduler cardServiceScheduler, SmartCard smartCard, boolean bl) throws CardServiceException {
        this.itracer.debug("initialize", "(" + cardServiceScheduler + "," + smartCard + ")");
        this.smart_card = smartCard;
        this.cs_scheduler = cardServiceScheduler;
        this.is_blocking = bl;
    }

    protected void releaseCardChannel() {
        if (!this.is_provided) {
            this.itracer.debug("releaseCardChannel", "releasing");
            this.cs_scheduler.releaseCardChannel(this.card_channel);
            this.card_channel = null;
        }
    }

    public void setCHVDialog(CHVDialog cHVDialog) {
        this.chv_dialog = cHVDialog;
    }

    public void setCardChannel(CardChannel cardChannel) {
        this.card_channel = cardChannel;
        this.is_provided = cardChannel != null;
    }
}

