/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.service.ocf;

import com.sun.opencard.common.OCFConstants;
import com.sun.opencard.common.OCFDebug;
import com.sun.opencard.common.OCFReturnValues;
import com.sun.opencard.common.ThreadInterrupter;
import com.sun.opencard.server.OCFCardHandle;
import com.sun.opencard.server.OCFClientHandle;
import com.sun.opencard.server.OCFServer;
import com.sun.opencard.service.ocf.OCF_CTListener;
import com.sun.opencard.utils.OCFUtils;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalRegistry;

public class CTListeningService {
    private final short CARD_INSERTED = 1;
    private final short CARD_REMOVED = (short)2;
    private boolean _eventRcvd = false;
    private OCFCardHandle _cardHandle = null;
    private short _event = 0;
    private String _waitForCard = null;
    private String _waitForRdr = null;
    private String _waitForAid = null;
    private OCFCardHandle _waitForCardHandle = null;
    private OCFClientHandle _clientHandle = null;
    static OCF_CTListener listener = new OCF_CTListener();

    static {
        CTListeningService.debug("static init", "installing listener");
        CardTerminalRegistry cardTerminalRegistry = CardTerminalRegistry.getRegistry();
        cardTerminalRegistry.addCTListener(listener);
        try {
            cardTerminalRegistry.createEventsForPresentCards(listener);
        }
        catch (CardTerminalException cardTerminalException) {
            cardTerminalException.printStackTrace();
        }
    }

    protected CTListeningService(OCFClientHandle oCFClientHandle) {
        this._clientHandle = oCFClientHandle;
    }

    void cardInserted(OCFCardHandle oCFCardHandle, String string) {
        if ((this._event & 1) != 0 && (this._waitForRdr == null && this.isTerminalVisible(string) || this._waitForRdr != null && this._waitForRdr.equals(string)) && (this._waitForCard == null || this._waitForCard.equals(oCFCardHandle.getCardName())) && oCFCardHandle.knows(this._waitForAid)) {
            CTListeningService.debug("cardInserted", "");
            CTListeningService cTListeningService = this;
            synchronized (cTListeningService) {
                this._cardHandle = oCFCardHandle;
                this._eventRcvd = true;
                this.notify();
            }
        }
    }

    void cardRemoved(OCFCardHandle oCFCardHandle, String string) {
        if ((this._event & 2) != 0 && (this._waitForCardHandle == null && this.isTerminalVisible(string) || this._waitForCardHandle != null && this._waitForCardHandle.equals(oCFCardHandle))) {
            CTListeningService.debug("cardRemoved", "");
            CTListeningService cTListeningService = this;
            synchronized (cTListeningService) {
                this._cardHandle = oCFCardHandle;
                this._eventRcvd = true;
                this.notify();
            }
        }
    }

    private static void debug(String string, String string2) {
        try {
            OCFDebug.debugln("CTListeningService : <" + string + "> " + string2);
        }
        catch (Exception exception) {}
    }

    private String getDefaultProperty(String string, String string2) {
        try {
            return OCFUtils.getProperty(String.valueOf(OCFConstants.OCF_CLIENT_PROPERTY_PREFIX) + string + "." + string2, null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String isCardPresent(String string, String string2) throws Exception {
        OCFCardHandle oCFCardHandle;
        CTListeningService.debug("isCardPresent", "");
        String string3 = this.setExpectedEvent(string, string2, null);
        if (string3.equals(OCFConstants.OCF_SUCCESS) && (oCFCardHandle = OCFServer.getCardHandle(this._waitForCard, this._waitForRdr)) == null) {
            string3 = OCFConstants.OCF_NOCARD;
        }
        return new OCFReturnValues(string3, null).getReturnValues();
    }

    private boolean isTerminalVisible(String string) {
        return OCFServer.isTerminalVisible(this._clientHandle, string);
    }

    private String setExpectedEvent(String string, String string2, String string3) {
        String string4 = this._clientHandle.getName();
        CTListeningService.debug("setExpectedEvent", "");
        Thread.currentThread().setPriority(10);
        if (OCFServer.noReadersConfig()) {
            return OCFConstants.OCF_NO_READERS_CONFIGURED;
        }
        if (OCFServer.noCardsConfig()) {
            return OCFConstants.OCF_NO_CARDS_CONFIGURED;
        }
        if (string2.equals(OCFConstants.OCF_WaitForCardSpec_DefaultReader)) {
            this._waitForRdr = OCFServer.getTerminalRawName(this._clientHandle, this.getDefaultProperty(string4, "defaultreader"));
            if (this._waitForRdr == null) {
                CTListeningService.debug("setExpectedEvent", "rejected default reader");
                return OCFConstants.OCF_RDR_NOT_SUPPORTED;
            }
        } else if (string2.equals(OCFConstants.OCF_WaitForCardSpec_AnyReader)) {
            this._waitForRdr = null;
        } else if (OCFServer.isSupportedReader(string2)) {
            String string5 = OCFServer.getTerminalInfo(this._clientHandle, string2, "address");
            if (string5 == null) {
                string5 = "???";
            }
            CTListeningService.debug("setExpectedEvent", "reader: " + string2 + " on " + string5);
            this._waitForRdr = string2;
        } else {
            return OCFConstants.OCF_RDR_NOT_SUPPORTED;
        }
        if (string.equals(OCFConstants.OCF_WaitForCardSpec_DefaultCard)) {
            this._waitForCard = this.getDefaultProperty(string4, "defaultcard");
        } else if (string.equals(OCFConstants.OCF_WaitForCardSpec_AnyCard)) {
            this._waitForCard = null;
        } else if (OCFServer.isSupportedCard(string)) {
            this._waitForCard = string;
        } else {
            return OCFConstants.OCF_CARD_NOT_SUPPORTED;
        }
        if (string3 != null) {
            if (string3.equals(OCFConstants.OCF_WaitForCardSpec_DefaultAID)) {
                this._waitForAid = this.getDefaultProperty(string4, "defaultaid");
            } else if (!string3.equals(OCFConstants.OCF_WaitForCardSpec_AnyAID)) {
                this._waitForAid = string3;
            }
        }
        CTListeningService.debug("setExpectedEvent", "card = " + this._waitForCard + " rdr = " + this._waitForRdr + " aid = " + this._waitForAid);
        return OCFConstants.OCF_SUCCESS;
    }

    private String waitForAnyCardEvent(short s) throws Exception {
        this._event = s;
        String string = this.waitForCardEvent(0L);
        OCFReturnValues oCFReturnValues = new OCFReturnValues(string, null);
        if (this._cardHandle != null) {
            oCFReturnValues.addReturnParam("cardhandle", String.valueOf(this._cardHandle.getHandle()));
        }
        return oCFReturnValues.getReturnValues();
    }

    public String waitForAnyCardInserted() throws Exception {
        CTListeningService.debug("waitForAnyCardInserted", "");
        return this.waitForAnyCardEvent((short)1);
    }

    public String waitForAnyCardRemoved() throws Exception {
        CTListeningService.debug("waitForAnyCardRemoved", "");
        return this.waitForAnyCardEvent((short)2);
    }

    private String waitForCardEvent(long l) {
        CTListeningService.debug("waitForCardEvent", "");
        if (l == 0L) {
            l = OCFConstants.MAX_BLOCKING_TIME;
        }
        ThreadInterrupter threadInterrupter = new ThreadInterrupter();
        this._clientHandle.addCloseListener(threadInterrupter);
        long l2 = listener.addWaitingService(this);
        CTListeningService cTListeningService = this;
        synchronized (cTListeningService) {
            if (!this._eventRcvd && this._clientHandle.isActive()) {
                try {
                    this.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    String string = OCFConstants.OCF_INVALID_CLIENT;
                    Object var8_6 = null;
                    return string;
                }
            }
        }
        listener.removeWaitingService(l2);
        this._clientHandle.removeCloseListener(threadInterrupter);
        return this._eventRcvd ? OCFConstants.OCF_SUCCESS : OCFConstants.OCF_TIMEOUT;
    }

    public String waitForCardInserted(String string, String string2, String string3, int n, long l) throws Exception {
        CTListeningService.debug("waitForCardInserted", "timeout=" + l);
        String string4 = this.setExpectedEvent(string, string2, string3);
        if (string4.equals(OCFConstants.OCF_SUCCESS)) {
            this._cardHandle = OCFServer.getCardHandle(this._waitForCard, this._waitForRdr);
            if (this._cardHandle == null) {
                if ((n & OCFConstants.OCF_NOBLOCK) == 0) {
                    this._event = 1;
                    string4 = this.waitForCardEvent(l);
                } else {
                    string4 = OCFConstants.OCF_NOCARD;
                }
            }
        }
        OCFReturnValues oCFReturnValues = new OCFReturnValues(string4, null);
        if (this._cardHandle != null) {
            CTListeningService.debug("waitForCardInserted", "returning with :  cardhandle = " + this._cardHandle.getHandle());
            oCFReturnValues.addReturnParam("cardhandle", String.valueOf(this._cardHandle.getHandle()));
        }
        return oCFReturnValues.getReturnValues();
    }

    public String waitForCardRemoved(OCFCardHandle oCFCardHandle) throws Exception {
        CTListeningService.debug("waitForCardRemoved", oCFCardHandle.toString());
        this._event = (short)2;
        this._waitForCardHandle = oCFCardHandle;
        String string = this.waitForCardEvent(0L);
        return new OCFReturnValues(string, null).getReturnValues();
    }
}

