/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.common;

import com.sun.opencard.common.EventListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class EventDispatcher {
    private LinkedList eventQueue = new LinkedList();
    private boolean isActive = false;

    public void activate() {
        this.isActive = true;
        new Thread(new Runnable(){

            public void run() {
                EventDispatcher.this.handleEvents();
            }
        }).start();
    }

    public void close() {
        LinkedList linkedList = this.eventQueue;
        synchronized (linkedList) {
            this.isActive = false;
            this.eventQueue.notify();
        }
    }

    void enqueueEvent(Object object, Collection collection) {
        Collection collection2 = collection;
        synchronized (collection2) {
            LinkedList linkedList = this.eventQueue;
            synchronized (linkedList) {
                this.eventQueue.addLast(new Event(collection, object));
                this.eventQueue.notifyAll();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleEvents() {
        while (this.isActive) {
            Event event;
            LinkedList linkedList = this.eventQueue;
            synchronized (linkedList) {
                while (true) {
                    if (!this.eventQueue.isEmpty()) {
                        event = (Event)this.eventQueue.removeFirst();
                        break;
                    }
                    try {
                        this.eventQueue.wait();
                        if (this.isActive) continue;
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
            event.doNotify();
        }
    }

    private static class Event {
        private Collection listeners;
        private Object subject;

        Event(Collection collection, Object object) {
            this.listeners = collection;
            this.subject = object;
        }

        void doNotify() {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                ((EventListener)iterator.next()).dispatchEvent(this.subject);
            }
        }
    }
}

