/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.diskmgr.client;

import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.diskmgr.client.FdiskGenStep;
import com.sun.admin.diskmgr.client.FdiskReviewStep;
import com.sun.admin.diskmgr.client.VDiskMgr;
import com.sun.admin.diskmgr.common.DiskData;
import com.sun.admin.diskmgr.common.DiskMgrException;
import com.sun.management.viper.console.gui.wizard.VWizard;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class FdiskWizard
extends VWizard {
    DiskData diskData;
    ResourceBundle bundle;
    VDiskMgr theApp;
    FdiskGenStep genStep;
    private int numPartitions = 0;
    private boolean bSizeAsPercent = true;

    public FdiskWizard(VDiskMgr vDiskMgr, DiskData diskData) {
        this.theApp = vDiskMgr;
        this.diskData = diskData;
        this.bundle = vDiskMgr.getResourceBundle();
        String string = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"FdiskWizTitle");
        Object[] objectArray = new Object[]{new String(this.diskData.getDiskName())};
        this.setTitle(MessageFormat.format(string, objectArray));
        this.genStep = new FdiskGenStep(vDiskMgr, this);
        ((JComponent)((Object)this.genStep)).setPreferredSize(FdiskReviewStep.getMaxStepSize(this.bundle, this.diskData.getDiskCapacity()));
        this.addCard("FdiskGenStep", this.genStep);
    }

    public void cancelWizard() {
        super.cancelWizard();
    }

    public void doFinish() {
        Thread thread = new Thread(){
            JFrame parent;
            {
                this.parent = FdiskWizard.this.getParentFrame();
            }

            public void run() {
                FdiskWizard.this.theApp.waitOn();
                ((Component)this.parent).setVisible(false);
                try {
                    FdiskWizard.this.theApp.getDiskMgr().fdiskDisk(FdiskWizard.this.diskData);
                    FdiskWizard.this.theApp.getTree().getCurrentContent().refresh();
                    FdiskWizard.this.cancelWizard();
                }
                catch (DiskMgrException diskMgrException) {
                    ((Component)this.parent).setVisible(true);
                    FdiskWizard.this.theApp.reportErrorException((Exception)((Object)diskMgrException), this.parent);
                }
                FdiskWizard.this.theApp.waitOff();
            }
        };
        thread.start();
    }

    protected DiskData getDiskData() {
        return this.diskData;
    }

    public int getNumPartitions() {
        return this.numPartitions;
    }

    private JFrame getParentFrame() {
        return (JFrame)this.getContainer();
    }

    public boolean isSizePercent() {
        return this.bSizeAsPercent;
    }

    public void setNumPartitions(int n) {
        this.numPartitions = n;
    }

    public void setSizeAsPercent(boolean bl) {
        this.bSizeAsPercent = bl;
    }
}

