/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.diskmgr.client;

import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.WarningDialog;
import com.sun.admin.diskmgr.client.ContentEvent;
import com.sun.admin.diskmgr.client.ContentListener;
import com.sun.admin.diskmgr.client.DiskActionsListener;
import com.sun.admin.diskmgr.client.NoSolarisPanel;
import com.sun.admin.diskmgr.client.TreeNodeData;
import com.sun.admin.diskmgr.client.VDiskMgr;
import com.sun.admin.diskmgr.common.DiskData;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.console.gui.VAboutBox;
import com.sun.management.viper.console.gui.VContainer;
import com.sun.management.viper.console.gui.VDisplayModel;
import com.sun.management.viper.console.gui.VFrame;
import com.sun.management.viper.util.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class Content {
    private static final String RETURN = new String("\n\n");
    protected Vector vDataCache = new Vector();
    protected VConsoleProperties properties = null;
    protected VDisplayModel displayModel = null;
    protected VDiskMgr theApp;
    private Vector listeners = new Vector();
    protected boolean bRefresh = false;
    protected VScopeNode treeNode = null;
    protected String sortPreferenceKey = null;
    protected VScopeNode rootNode = null;

    public Content(VDiskMgr vDiskMgr) {
        this.theApp = vDiskMgr;
    }

    public void aboutBox() {
        ResourceBundle resourceBundle = this.theApp.getResourceBundle();
        VFrame vFrame = new VFrame();
        VAboutBox vAboutBox = new VAboutBox();
        vAboutBox.setTitle(ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"AboutBoxBanner"));
        String string = String.valueOf(ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"CopyrightMsg")) + RETURN + ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"AboutLegal") + RETURN + ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"AboutLegal1") + RETURN + ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"AboutLegal2") + RETURN;
        vAboutBox.setDescription(string);
        Dimension dimension = vAboutBox.getMinimumSize();
        dimension.height = 360;
        vAboutBox.setMinimumSize(dimension);
        vAboutBox.requestDefaultFocus();
        vAboutBox.setContainer((VContainer)vFrame);
        vFrame.setTitle(ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"AboutBoxTitle"));
        vFrame.getContentPane().setLayout(new BorderLayout());
        vFrame.getContentPane().add((Component)vAboutBox, "Center");
        vFrame.pack();
        vFrame.showCenter((Component)this.theApp.getProperties().getPropertyObject("vconsole.frame"));
    }

    public synchronized void addContentListener(ContentListener contentListener) {
        this.listeners.addElement(contentListener);
    }

    public abstract void clear();

    public void clearSelection() {
        if (this.displayModel == null) {
            this.setDisplayModel();
        }
        this.displayModel.clearSelection();
        this.fireItemPressed(0);
    }

    protected String[][] constructColumnHeaders(Object[][] objectArray) {
        ResourceBundle resourceBundle = this.theApp.getResourceBundle();
        int n = objectArray.length;
        String[][] stringArray = new String[n][3];
        JLabel jLabel = new JLabel();
        jLabel.setFont(ResourceManager.labelFont);
        FontMetrics fontMetrics = ((Component)jLabel).getFontMetrics(ResourceManager.labelFont);
        jLabel.setFont(ResourceManager.bodyFont);
        FontMetrics fontMetrics2 = ((Component)jLabel).getFontMetrics(ResourceManager.labelFont);
        int n2 = 0;
        while (n2 < n) {
            String string = (String)objectArray[n2][0];
            stringArray[n2][0] = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)string);
            int n3 = fontMetrics.stringWidth(stringArray[n2][0]);
            n3 += fontMetrics.stringWidth("AAAA");
            int n4 = (Integer)objectArray[n2][1];
            int n5 = 0;
            if (n4 > 20000) {
                n5 = 20000;
            } else if (n4 > 10000) {
                n5 = 10000;
            }
            int n6 = fontMetrics2.stringWidth("A");
            n6 *= (n4 -= n5);
            stringArray[n2][1] = new String(String.valueOf(Math.max(n3, n6 += n5)));
            ++n2;
        }
        return stringArray;
    }

    public void die() {
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.die();
    }

    protected void fireItemPressed(int n) {
        ContentEvent contentEvent = new ContentEvent(this, n, this.getSortAttribute(), null);
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ContentListener contentListener = (ContentListener)enumeration.nextElement();
            contentListener.itemPressed(contentEvent);
        }
    }

    public abstract void formatSelected();

    protected static String formatSuffix(String string, String string2) {
        Object[] objectArray = new Object[]{new String(string)};
        String string3 = MessageFormat.format(string2, objectArray);
        return string3;
    }

    protected abstract String[][] getColumnHeaders();

    public Vector getDataCache() {
        return this.vDataCache;
    }

    public VScopeNode getInternalRoot() {
        return this.rootNode;
    }

    public int getNumSelections() {
        if (this.displayModel == null) {
            this.setDisplayModel();
        }
        return this.displayModel.getSelectedNodes().size();
    }

    public Vector getSelected() {
        if (this.displayModel == null) {
            this.setDisplayModel();
        }
        return this.displayModel.getSelectedNodes();
    }

    public VScopeNode getSelectedNode() {
        Vector vector = this.getSelected();
        if (vector.size() > 0) {
            return (VScopeNode)vector.firstElement();
        }
        return null;
    }

    protected abstract String getSortAttribute();

    public VScopeNode getTreeNode() {
        return this.treeNode;
    }

    public boolean isFilteringSupported() {
        return false;
    }

    public boolean isRefreshed() {
        return this.bRefresh;
    }

    public boolean isShowByTypeSupported() {
        return false;
    }

    public void onDoubleClick() {
        this.fireItemPressed(2);
        ActionEvent actionEvent = new ActionEvent(this, 1001, "Properties");
        DiskActionsListener diskActionsListener = new DiskActionsListener(this.theApp);
        diskActionsListener.actionPerformed(actionEvent);
    }

    public void onSelection(Vector vector) {
        this.fireItemPressed(vector.size());
        if (vector != null && vector.size() > 0) {
            VScopeNode vScopeNode = (VScopeNode)vector.firstElement();
            TreeNodeData treeNodeData = (TreeNodeData)vScopeNode.getPayload();
            if (!(treeNodeData instanceof TreeNodeData)) {
                return;
            }
            DiskData diskData = treeNodeData.getDiskData();
            if (!diskData.hasSolarisPartitions()) {
                NoSolarisPanel noSolarisPanel = new NoSolarisPanel(this.theApp, diskData);
                ActionListener actionListener = noSolarisPanel.getListener();
                VFrame vFrame = new VFrame();
                ResourceBundle resourceBundle = this.theApp.getResourceBundle();
                WarningDialog warningDialog = new WarningDialog((JFrame)vFrame, ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"no_solaris_title"), (JPanel)noSolarisPanel, actionListener, ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"continueBtn"));
            }
        }
    }

    public void openSelected() {
    }

    public abstract void refresh();

    public synchronized void removeContentListener(ContentListener contentListener) {
        this.listeners.removeElement(contentListener);
    }

    public void renameSelected() {
    }

    public void saveSortPreference() {
        this.properties.setProperty(this.sortPreferenceKey, this.properties.getProperty("vconsole.sortedcolumn"));
    }

    public abstract void setDefaultColumnHeader();

    protected void setDisplayModel() {
        this.properties = this.theApp.getProperties();
        this.displayModel = (VDisplayModel)this.properties.getPropertyObject("vconsole.displaymodel");
        this.setDefaultColumnHeader();
    }

    public void setSelected(Vector vector) {
        if (this.displayModel == null) {
            this.setDisplayModel();
        }
        this.displayModel.setSelectedNodes(vector);
        this.onSelection(vector);
    }

    public void setTreeNode(VScopeNode vScopeNode) {
        this.treeNode = vScopeNode;
    }

    public void showByType() {
    }

    protected abstract void updateInfoBar();

    public void updateSortPreference() {
        String string = this.properties.getProperty(this.sortPreferenceKey);
        if (string == null || string.equals("null")) {
            return;
        }
        String string2 = "vconsole.sortup";
        if (string.indexOf(45) >= 0) {
            string2 = "vconsole.sortdown";
        }
        Integer[] integerArray = new Integer[1];
        try {
            int n = Integer.parseInt(string.substring(1));
            integerArray[0] = new Integer(n);
        }
        catch (Exception exception) {
            integerArray[0] = new Integer(0);
        }
        VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.theApp, string2, (Object)integerArray);
        this.theApp.fireConsoleAction(vConsoleEvent);
        this.properties.setProperty("vconsole.sortedcolumn", string);
    }

    public abstract void viewProperties();

    public abstract String whatAmI();
}

