/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg.util;

import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Localizer {
    private static Hashtable resourcebundles = new Hashtable();
    private static String[] resourcePackages;

    public static synchronized void addResourcePackage(String string) {
        if (resourcePackages == null) {
            resourcePackages = new String[]{string};
        } else {
            String[] stringArray = new String[resourcePackages.length + 1];
            System.arraycopy(resourcePackages, 0, stringArray, 0, resourcePackages.length);
            stringArray[stringArray.length - 1] = string;
            resourcePackages = stringArray;
        }
    }

    private static synchronized ResourceBundle getResourceBundle(String string) throws RuntimeException {
        String string2 = null;
        if (string.indexOf(".") > 0) {
            string2 = string;
            if (resourcebundles.containsKey(string2)) {
                return (ResourceBundle)resourcebundles.get(string2);
            }
            try {
                ResourceBundle resourceBundle = ResourceBundle.getBundle(string2);
                resourcebundles.put(string2, resourceBundle);
                return resourceBundle;
            }
            catch (MissingResourceException missingResourceException) {}
        } else {
            if (resourcePackages == null) {
                throw new RuntimeException("No registered packages, cannot resolve " + string);
            }
            int n = 0;
            while (n < resourcePackages.length) {
                string2 = String.valueOf(resourcePackages[n]) + "." + string;
                if (resourcebundles.containsKey(string2)) {
                    return (ResourceBundle)resourcebundles.get(string2);
                }
                ++n;
            }
            int n2 = 0;
            if (n2 < resourcePackages.length) {
                string2 = String.valueOf(resourcePackages[n2]) + "." + string;
                try {
                    ResourceBundle resourceBundle = ResourceBundle.getBundle(string2);
                    resourcebundles.put(string2, resourceBundle);
                    return resourceBundle;
                }
                catch (MissingResourceException missingResourceException) {
                    throw new RuntimeException("Could not obtain localization bundled \"" + string2 + "\"");
                }
            }
        }
        return null;
    }

    public static String localeName(Locale locale) {
        String string = new String();
        if (locale != null) {
            String string2;
            String string3;
            string = string3 = locale.getLanguage();
            String string4 = locale.getCountry();
            if (string4.length() > 0) {
                string = String.valueOf(string3) + "_" + string4;
            }
            if ((string2 = locale.getVariant()).length() > 0) {
                string = String.valueOf(string) + "." + string2;
            }
        }
        return string;
    }

    private static String localize(String string) throws RuntimeException {
        if (string == null) {
            throw new RuntimeException("localize: Invalid reference: " + string);
        }
        String string2 = null;
        String string3 = null;
        int n = string.lastIndexOf(46);
        if (n <= 0) {
            return string;
        }
        string2 = string.substring(0, n);
        string3 = string.substring(n + 1, string.length());
        ResourceBundle resourceBundle = Localizer.getResourceBundle(string2);
        String string4 = null;
        if (resourceBundle != null) {
            try {
                string4 = resourceBundle.getString(string3);
            }
            catch (MissingResourceException missingResourceException) {
                throw new RuntimeException("localized string " + string2 + "." + string3 + " not found:" + missingResourceException.toString());
            }
        } else {
            throw new RuntimeException("resource bundle " + string2 + " not found");
        }
        return string4;
    }

    public static String resolve(String string) throws RuntimeException {
        if (string == null) {
            return null;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '<') {
                int n3 = string.indexOf(62, n2 + 1);
                if (n3 == -1) {
                    stringBuffer.append(string.substring(n2));
                    break;
                }
                stringBuffer.append(Localizer.resolveTag(string.substring(n2 + 1, n3)));
                n2 = n3;
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String resolve(String string, Object[] objectArray) throws RuntimeException {
        String string2 = Localizer.resolve(string);
        MessageFormat messageFormat = new MessageFormat(string2);
        String string3 = null;
        try {
            string3 = messageFormat.format(objectArray);
        }
        catch (NullPointerException nullPointerException) {
            string3 = string2;
        }
        if (string3 == null) {
            string3 = "***" + string + " --> UNABLE TO RESOLVE ***";
        }
        return string3;
    }

    private static String resolveTag(String string) throws RuntimeException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n && Character.isWhitespace(string.charAt(n2))) {
            ++n2;
        }
        int n3 = n2;
        while (n2 < n && !Character.isWhitespace(string.charAt(n2))) {
            ++n2;
        }
        String string2 = string.substring(n3, n2);
        while (n2 < n && Character.isWhitespace(string.charAt(n2))) {
            ++n2;
        }
        int n4 = n2;
        while (n2 < n && !Character.isWhitespace(string.charAt(n2))) {
            ++n2;
        }
        String string3 = string.substring(n4, n2);
        if (string3.length() > 0) {
            return Localizer.resolveTag(string2, string3);
        }
        return Localizer.resolveTag("L", string2);
    }

    private static String resolveTag(String string, String string2) throws RuntimeException {
        if (string.equalsIgnoreCase("L")) {
            return Localizer.localize(string2);
        }
        throw new RuntimeException("{UNKNOWN TAG TYPE: " + string + "' used in <" + string + " " + string2 + ">}");
    }
}

