/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg.core;

import com.sun.prodreg.core.ComponentReference;
import com.sun.prodreg.core.ComponentType;
import com.sun.prodreg.core.Registry;
import com.sun.prodreg.core.RegistryQuery;
import com.sun.prodreg.util.Localizer;
import com.sun.prodreg.util.Utils;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class ComponentDescription
extends ComponentReference
implements Serializable,
Cloneable {
    private String uniqueName = null;
    private Hashtable displayNames = null;
    private ComponentReference parent = null;
    private ComponentReference[] children = null;
    private ComponentType componentType = null;
    private String location = null;
    private String uninstaller = null;
    private String vendor = null;
    private Vector requiredComponents = null;
    private Vector dependentComponents = null;
    private Vector backwardCompatible = null;
    private Hashtable data = null;

    public ComponentDescription() {
        this.setComponentType(new ComponentType("component"));
    }

    public ComponentDescription(String string) {
        this();
        this.setID(string);
    }

    public void addChild(ComponentReference componentReference) {
        Vector<ComponentReference> vector = new Vector<ComponentReference>();
        boolean bl = false;
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                ComponentReference componentReference2 = this.children[n];
                if (this.equalsReference(componentReference2, componentReference)) {
                    bl = true;
                }
                vector.addElement(this.children[n]);
                ++n;
            }
        }
        if (!bl) {
            vector.addElement(componentReference);
        }
        ComponentReference[] componentReferenceArray = null;
        if (vector.size() > 0) {
            componentReferenceArray = new ComponentReference[vector.size()];
            int n = 0;
            while (n < componentReferenceArray.length) {
                componentReferenceArray[n] = (ComponentReference)vector.elementAt(n);
                ++n;
            }
        }
        this.children = componentReferenceArray;
    }

    public boolean addCompatibleVersion(String string) {
        if (string != null) {
            if (this.backwardCompatible == null) {
                this.backwardCompatible = new Vector();
            }
            if (!this.backwardCompatible.contains(string)) {
                this.backwardCompatible.addElement(string);
            }
            return true;
        }
        return false;
    }

    public boolean addDependentComponent(ComponentReference componentReference) {
        Vector<ComponentReference> vector = this.getDependentComponents();
        boolean bl = false;
        if (vector == null) {
            vector = new Vector<ComponentReference>();
        }
        int n = 0;
        while (n < vector.size()) {
            ComponentReference componentReference2 = (ComponentReference)vector.elementAt(n);
            if (this.equalsReference(componentReference2, componentReference)) {
                bl = true;
            }
            ++n;
        }
        if (!bl) {
            vector.addElement(componentReference);
            this.setDependentComponents(vector);
        }
        return true;
    }

    public boolean addRequiredComponent(ComponentReference componentReference) {
        Vector<ComponentReference> vector = this.getRequiredComponents();
        boolean bl = false;
        if (vector == null) {
            vector = new Vector<ComponentReference>();
        }
        int n = 0;
        while (n < vector.size()) {
            ComponentReference componentReference2 = (ComponentReference)vector.elementAt(n);
            if (this.equalsReference(componentReference2, componentReference)) {
                bl = true;
            }
            ++n;
        }
        if (!bl) {
            vector.addElement(componentReference);
            this.setRequiredComponents(vector);
        }
        return true;
    }

    public synchronized Object clone() {
        String string;
        Object object;
        Enumeration<Object> enumeration;
        ComponentDescription componentDescription = new ComponentDescription();
        componentDescription.setID(this.getID());
        componentDescription.setInstance(this.getInstance());
        componentDescription.setVersion(this.getVersion());
        componentDescription.setUniqueName(this.getUniqueName());
        if (this.displayNames != null) {
            enumeration = this.displayNames.keys();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                string = (String)this.displayNames.get(object);
                componentDescription.setDisplayName((String)object, string);
            }
        }
        if (this.parent != null) {
            componentDescription.setParent((ComponentReference)this.parent.clone());
        }
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                componentDescription.addChild((ComponentReference)this.children[n].clone());
                ++n;
            }
        }
        if (this.componentType != null) {
            componentDescription.setComponentType(this.componentType);
        }
        componentDescription.setLocation(this.location);
        componentDescription.setUninstaller(this.uninstaller);
        componentDescription.setVendor(this.vendor);
        if (this.requiredComponents != null) {
            enumeration = this.requiredComponents.elements();
            while (enumeration.hasMoreElements()) {
                object = (ComponentReference)enumeration.nextElement();
                componentDescription.addRequiredComponent((ComponentReference)((ComponentReference)object).clone());
            }
        }
        if (this.dependentComponents != null) {
            enumeration = this.dependentComponents.elements();
            while (enumeration.hasMoreElements()) {
                object = (ComponentReference)enumeration.nextElement();
                componentDescription.addDependentComponent((ComponentReference)((ComponentReference)object).clone());
            }
        }
        if (this.backwardCompatible != null) {
            enumeration = this.backwardCompatible.elements();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                componentDescription.addCompatibleVersion((String)object);
            }
        }
        if (this.data != null) {
            enumeration = this.data.keys();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                string = (String)this.data.get(object);
                componentDescription.setData((String)object, string);
            }
        }
        return componentDescription;
    }

    public ComponentDescription copy() {
        return (ComponentDescription)this.clone();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ComponentDescription)) {
            return false;
        }
        ComponentDescription componentDescription = (ComponentDescription)object;
        if (!Utils.objectsEqual(this.getID(), componentDescription.getID())) {
            return false;
        }
        if (this.getInstance() != componentDescription.getInstance()) {
            return false;
        }
        if (this.isDamaged() != componentDescription.isDamaged()) {
            return false;
        }
        if (!Utils.objectsEqual(this.getVersion(), componentDescription.getVersion())) {
            return false;
        }
        if (!Utils.objectsEqual(this.getUniqueName(), componentDescription.getUniqueName())) {
            return false;
        }
        if (!Utils.hashtablesEqual(this.displayNames, componentDescription.getDisplayNames())) {
            return false;
        }
        if (!Utils.objectsEqual(this.getParent(), componentDescription.getParent())) {
            return false;
        }
        if (!Utils.objectsEqual(this.getChildren(), componentDescription.getChildren())) {
            return false;
        }
        if (!Utils.objectsEqual(this.getComponentType(), componentDescription.getComponentType())) {
            return false;
        }
        if (!Utils.objectsEqual(this.getLocation(), componentDescription.getLocation())) {
            return false;
        }
        if (!Utils.objectsEqual(this.getUninstaller(), componentDescription.getUninstaller())) {
            return false;
        }
        if (!Utils.objectsEqual(this.getVendor(), componentDescription.getVendor())) {
            return false;
        }
        if (!Utils.vectorsEqual(this.getRequiredComponents(), componentDescription.getRequiredComponents())) {
            return false;
        }
        if (!Utils.vectorsEqual(this.getDependentComponents(), componentDescription.getDependentComponents())) {
            return false;
        }
        if (!Utils.objectsEqual(this.getCompatibleVersions(), componentDescription.getCompatibleVersions())) {
            return false;
        }
        return Utils.hashtablesEqual(this.data, componentDescription.getData());
    }

    private boolean equalsReference(ComponentReference componentReference, ComponentReference componentReference2) {
        if (componentReference == componentReference2) {
            return true;
        }
        return componentReference != null && componentReference2 != null && componentReference.getID().equals(componentReference2.getID()) && componentReference.getInstance() == componentReference2.getInstance();
    }

    public boolean equivalent(ComponentDescription componentDescription) {
        if (this.getID() != null && !this.getID().equals(componentDescription.getID()) || this.getID() == null && componentDescription.getVersion() != null) {
            return false;
        }
        if (this.getInstance() != componentDescription.getInstance()) {
            return false;
        }
        if (this.getVersion() != null && !this.getVersion().equals(componentDescription.getVersion()) || this.getVersion() == null && componentDescription.getVersion() != null) {
            return false;
        }
        if (this.uniqueName != null && !this.uniqueName.equals(componentDescription.getUniqueName()) || this.uniqueName == null && componentDescription.getUniqueName() != null) {
            return false;
        }
        if (this.parent != null && !this.parent.equals(componentDescription.getParent()) || this.parent == null && componentDescription.getParent() != null) {
            return false;
        }
        if (this.componentType != null && !this.componentType.equals(componentDescription.getComponentType()) || this.componentType == null & componentDescription.getComponentType() != null) {
            return false;
        }
        if (this.location != null && !this.location.equals(componentDescription.getLocation()) || this.location == null && componentDescription.getLocation() != null) {
            return false;
        }
        if (this.uninstaller != null && !this.uninstaller.equals(componentDescription.getUninstaller()) || this.uninstaller == null && componentDescription.getUninstaller() != null) {
            return false;
        }
        if (this.requiredComponents == null && componentDescription.getRequiredComponents() != null) {
            return false;
        }
        return this.dependentComponents != null || componentDescription.getDependentComponents() == null;
    }

    public ComponentReference[] getChildren() {
        return this.children;
    }

    public synchronized ComponentDescription[] getChildren(Registry registry) {
        if (this.children != null) {
            Object object;
            Vector<ComponentReference> vector = new Vector<ComponentReference>();
            int n = 0;
            while (n < this.children.length) {
                object = new RegistryQuery();
                ((RegistryQuery)object).setID(this.children[n].getID());
                ((RegistryQuery)object).setInstance(this.children[n].getInstance());
                try {
                    ComponentDescription componentDescription = registry.getComponent((RegistryQuery)object);
                    vector.addElement(componentDescription);
                }
                catch (Exception exception) {
                    vector.addElement(this.children[n]);
                }
                ++n;
            }
            object = new ComponentDescription[vector.size()];
            int n2 = 0;
            while (n2 < ((ComponentDescription[])object).length) {
                object[n2] = (ComponentDescription)vector.elementAt(n2);
                ++n2;
            }
            return object;
        }
        return null;
    }

    public String[] getCompatibleVersions() {
        if (this.backwardCompatible == null) {
            return null;
        }
        String[] stringArray = new String[this.backwardCompatible.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)this.backwardCompatible.elementAt(n);
            ++n;
        }
        return stringArray;
    }

    public ComponentType getComponentType() {
        return this.componentType;
    }

    public Hashtable getData() {
        if (this.data != null) {
            return (Hashtable)this.data.clone();
        }
        return null;
    }

    public String getData(String string) {
        if (this.data != null) {
            return (String)this.data.get(string);
        }
        return null;
    }

    public Vector getDependentComponents() {
        return this.dependentComponents;
    }

    public String[] getDisplayLanguages() {
        if (this.displayNames != null) {
            String[] stringArray = new String[this.displayNames.size()];
            Enumeration enumeration = this.displayNames.keys();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                stringArray[n++] = (String)enumeration.nextElement();
            }
            return stringArray;
        }
        return new String[0];
    }

    public String getDisplayName() {
        Locale locale = Locale.getDefault();
        String string = this.getDisplayName(Localizer.localeName(locale));
        if (string == null) {
            string = this.getDisplayName("en");
        }
        return string;
    }

    public String getDisplayName(String string) {
        if (this.displayNames != null) {
            String string2 = (String)this.displayNames.get(string);
            return string2;
        }
        return null;
    }

    public Hashtable getDisplayNames() {
        return this.displayNames;
    }

    public String getLocation() {
        return this.location;
    }

    public ComponentReference getParent() {
        return this.parent;
    }

    public Vector getRequiredComponents() {
        return this.requiredComponents;
    }

    public String getUninstaller() {
        return this.uninstaller;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public String getVendor() {
        return this.vendor;
    }

    public boolean isDamaged() {
        String string = this.getData("isDamaged");
        return string != null && string.equalsIgnoreCase("true");
    }

    public void removeChild(ComponentReference componentReference) {
        Vector<ComponentReference> vector = new Vector<ComponentReference>();
        int n = -1;
        if (this.children != null) {
            int n2 = 0;
            while (n2 < this.children.length) {
                ComponentReference componentReference2 = this.children[n2];
                if (this.equalsReference(componentReference2, componentReference)) {
                    n = n2;
                }
                vector.addElement(this.children[n2]);
                ++n2;
            }
        }
        if (n >= 0) {
            vector.removeElementAt(n);
        }
        ComponentReference[] componentReferenceArray = null;
        if (vector.size() > 0) {
            componentReferenceArray = new ComponentReference[vector.size()];
            int n3 = 0;
            while (n3 < componentReferenceArray.length) {
                componentReferenceArray[n3] = (ComponentReference)vector.elementAt(n3);
                ++n3;
            }
        }
        this.children = componentReferenceArray;
    }

    public boolean removeCompatibleVersion(String string) {
        if (string != null && this.backwardCompatible != null && this.backwardCompatible.contains(string)) {
            this.backwardCompatible.removeElement(string);
        }
        return true;
    }

    public boolean removeDependentComponent(ComponentReference componentReference) {
        Vector vector = this.getDependentComponents();
        int n = -1;
        if (vector != null) {
            int n2 = 0;
            while (n2 < vector.size()) {
                ComponentReference componentReference2 = (ComponentReference)vector.elementAt(n2);
                if (this.equalsReference(componentReference2, componentReference)) {
                    n = n2;
                }
                ++n2;
            }
            if (n >= 0) {
                vector.removeElementAt(n);
            }
        }
        return true;
    }

    public boolean removeRequiredComponent(ComponentReference componentReference) {
        Vector vector = this.getRequiredComponents();
        int n = -1;
        if (vector != null) {
            int n2 = 0;
            while (n2 < vector.size()) {
                ComponentReference componentReference2 = (ComponentReference)vector.elementAt(n2);
                if (this.equalsReference(componentReference2, componentReference)) {
                    n = n2;
                }
                ++n2;
            }
            if (n >= 0) {
                vector.removeElementAt(n);
            }
        }
        return true;
    }

    public void setComponentType(ComponentType componentType) {
        this.componentType = componentType;
    }

    public boolean setData(String string, String string2) {
        if (this.data == null) {
            this.data = new Hashtable();
        }
        this.data.put(string, string2);
        return true;
    }

    public void setDependentComponents(Vector vector) {
        this.dependentComponents = vector;
    }

    public void setDisplayName(String string) {
        this.setDisplayName("en", string);
    }

    public void setDisplayName(String string, String string2) {
        if (this.displayNames == null) {
            this.displayNames = new Hashtable();
        }
        this.displayNames.put(string, string2);
    }

    public void setLocation(String string) {
        this.location = string;
    }

    public void setParent(ComponentReference componentReference) {
        this.parent = componentReference;
    }

    public void setRequiredComponents(Vector vector) {
        this.requiredComponents = vector;
    }

    public void setUninstaller(String string) {
        this.uninstaller = string;
    }

    public void setUniqueName(String string) {
        this.uniqueName = string;
    }

    public void setVendor(String string) {
        this.vendor = string;
    }

    public String toString() {
        String string = "[";
        string = String.valueOf(string) + "id=" + this.getID();
        string = String.valueOf(string) + " instance=" + this.getInstance() + ", ";
        string = String.valueOf(string) + " damaged=" + this.isDamaged() + ", ";
        string = String.valueOf(string) + " uniqueName=" + this.uniqueName + ", ";
        string = String.valueOf(string) + " version=" + this.getVersion() + ", ";
        string = String.valueOf(string) + " location=" + this.location + ", ";
        string = String.valueOf(string) + " uninstaller=" + this.uninstaller + ", ";
        string = String.valueOf(string) + " requiredComponents=" + this.requiredComponents + ", ";
        string = String.valueOf(string) + " dependentComponents=" + this.dependentComponents + ", ";
        string = String.valueOf(string) + " backwardCompatible=" + this.backwardCompatible;
        string = String.valueOf(string) + "]";
        return string;
    }
}

