/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client.rbac;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.CheckSyntax;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ContextHelpListener;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.SelectableLabel;
import com.sun.admin.usermgr.client.UMgrContextHelpListener;
import com.sun.admin.usermgr.client.UMgrPropsPanel;
import com.sun.admin.usermgr.client.VUserMgr;
import com.sun.admin.usermgr.common.SolServicesAttr;
import com.sun.admin.usermgr.common.UserObj;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.FocusListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class RoleGenProps
extends UMgrPropsPanel {
    private JTextField roleNameTextField;
    private JTextField roleFullNameTextField;
    private SelectableLabel roleIdLabel;
    private JTextArea roleDescriptionTextArea;
    private JComboBox shellComboBox;
    private GenInfoPanel infoPanel;
    private VUserMgr theApp;
    private ResourceBundle bundle;
    private ActionString actionString;
    private static final int PFBOURNE_INDEX = 0;
    private static final int PFCSHELL_INDEX = 1;
    private static final int PFKORN_INDEX = 2;

    public RoleGenProps(VUserMgr vUserMgr, UserObj userObj, GenInfoPanel genInfoPanel) {
        this.theApp = vUserMgr;
        this.bundle = vUserMgr.getResourceBundle();
        this.infoPanel = genInfoPanel;
        this.createGui(userObj);
        Vector vector = new Vector(10 + this.shellComboBox.getItemCount());
        this.roleNameTextField.addFocusListener((FocusListener)((Object)new UMgrContextHelpListener(vUserMgr, vector, this.infoPanel, "rprop_gen_rname")));
        this.roleFullNameTextField.addFocusListener((FocusListener)((Object)new UMgrContextHelpListener(vUserMgr, vector, this.infoPanel, "rprop_gen_name")));
        this.roleDescriptionTextArea.addFocusListener((FocusListener)((Object)new UMgrContextHelpListener(vUserMgr, vector, this.infoPanel, "rprop_gen_descript")));
        this.roleIdLabel.addFocusListener((FocusListener)((Object)new UMgrContextHelpListener(vUserMgr, vector, this.infoPanel, "rprop_gen_rid")));
        vUserMgr.addHelpListener(this.shellComboBox, new UMgrContextHelpListener(vUserMgr, vector, this.infoPanel, "rprop_gen_shell"));
        this.focusListener = new UMgrContextHelpListener(vUserMgr, vector, this.infoPanel, "rprop_gen");
        Thread thread = new Thread(){

            public void run() {
                try {
                    ContextHelpListener.loadHelp((ContextHelpListener)((UMgrContextHelpListener)((Object)RoleGenProps.this.getFocusListener())));
                }
                catch (Exception exception) {}
            }
        };
        thread.start();
    }

    private void createGui(UserObj userObj) {
        int n = 0;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel();
        this.setUpLabel(jLabel, "role_name");
        Constraints.constrain((Container)this, (Component)jLabel, (int)0, (int)n, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)12, (int)12, (int)0, (int)0);
        String string = userObj.getUserName();
        this.roleNameTextField = new JTextField(string, 15);
        this.roleNameTextField.setMinimumSize(this.roleNameTextField.getPreferredSize());
        jLabel.setLabelFor(this.roleNameTextField);
        Constraints.constrain((Container)this, (Component)this.roleNameTextField, (int)1, (int)n, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)12, (int)12, (int)0, (int)0);
        JLabel jLabel2 = new JLabel();
        this.setUpLabel(jLabel2, "role_props_full_name");
        Constraints.constrain((Container)this, (Component)jLabel2, (int)0, (int)(++n), (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)12, (int)12, (int)0, (int)0);
        String string2 = userObj.getUserFullName();
        this.roleFullNameTextField = new JTextField(string2, 15);
        this.roleFullNameTextField.setMinimumSize(this.roleFullNameTextField.getPreferredSize());
        jLabel2.setLabelFor(this.roleFullNameTextField);
        Constraints.constrain((Container)this, (Component)this.roleFullNameTextField, (int)1, (int)n, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)12, (int)12, (int)0, (int)0);
        JLabel jLabel3 = new JLabel();
        this.setUpLabel(jLabel3, "role_props_id");
        Constraints.constrain((Container)this, (Component)jLabel3, (int)0, (int)(++n), (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)12, (int)12, (int)0, (int)0);
        String string3 = userObj.getUserID();
        this.roleIdLabel = new SelectableLabel(string3);
        this.roleIdLabel.setHorizontalAlignment(4);
        this.roleIdLabel.setMinimumSize(this.roleIdLabel.getPreferredSize());
        jLabel3.setLabelFor((Component)this.roleIdLabel);
        Constraints.constrain((Container)this, (Component)this.roleIdLabel, (int)1, (int)n, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)12, (int)12, (int)0, (int)0);
        JLabel jLabel4 = new JLabel();
        this.setUpLabel(jLabel4, "role_description");
        Constraints.constrain((Container)this, (Component)jLabel4, (int)0, (int)(++n), (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)12, (int)12, (int)0, (int)0);
        String string4 = userObj.getUserDescription();
        this.roleDescriptionTextArea = new JTextArea(3, 15);
        this.roleDescriptionTextArea.setText(string4);
        this.roleDescriptionTextArea.setLineWrap(true);
        this.roleDescriptionTextArea.setWrapStyleWord(true);
        this.roleDescriptionTextArea.setMinimumSize(this.roleDescriptionTextArea.getPreferredSize());
        JScrollPane jScrollPane = new JScrollPane(this.roleDescriptionTextArea);
        jLabel4.setLabelFor(this.roleDescriptionTextArea);
        Constraints.constrain((Container)this, (Component)jScrollPane, (int)1, (int)n, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)12, (int)12, (int)0, (int)0);
        JLabel jLabel5 = new JLabel(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"role_props_shell"));
        this.setUpLabel(jLabel5, "role_props_shell");
        Constraints.constrain((Container)this, (Component)jLabel5, (int)0, (int)(++n), (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)12, (int)12, (int)0, (int)0);
        String[] stringArray = new String[]{ResourceStrings.getString((ResourceBundle)this.bundle, (String)"role_bourne"), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"role_c"), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"role_korn")};
        this.shellComboBox = new JComboBox<String>(stringArray);
        jLabel5.setLabelFor(this.shellComboBox);
        this.getSelectedShell(userObj);
        Constraints.constrain((Container)this, (Component)this.shellComboBox, (int)1, (int)n, (int)1, (int)1, (int)0, (int)18, (double)1.0, (double)1.0, (int)12, (int)12, (int)0, (int)0);
    }

    private void getSelectedShell(UserObj userObj) {
        String string;
        SolServicesAttr solServicesAttr = userObj.getSolServicesAttr();
        if (solServicesAttr == null) {
            solServicesAttr = new SolServicesAttr();
        }
        if ((string = solServicesAttr.getInitialShell()) == null) {
            string = SolServicesAttr.ROLE_BOURNE;
        }
        if (string.equals(SolServicesAttr.ROLE_KORN)) {
            this.shellComboBox.setSelectedIndex(2);
        } else if (string.equals(SolServicesAttr.ROLE_CSHELL)) {
            this.shellComboBox.setSelectedIndex(1);
        } else {
            this.shellComboBox.setSelectedIndex(0);
        }
    }

    public boolean isDescriptionSyntaxOK() {
        if (this.theApp.getApplicationContext().isScopeLDAP() && this.roleFullNameTextField.getText().equals("")) {
            String string = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_full_name_blank");
            ErrorDialog errorDialog = new ErrorDialog(this.theApp.getFrame(), string);
            return false;
        }
        if (CheckSyntax.isDescLenOK((String)this.roleDescriptionTextArea.getText())) {
            return true;
        }
        String string = CheckSyntax.getErrorString();
        ErrorDialog errorDialog = new ErrorDialog(this.theApp.getFrame(), string);
        return false;
    }

    public boolean isUserNameSyntaxOK() {
        if (CheckSyntax.isNameOK((String)this.roleNameTextField.getText())) {
            return true;
        }
        String string = CheckSyntax.getErrorString();
        ErrorDialog errorDialog = new ErrorDialog(this.theApp.getFrame(), string);
        return false;
    }

    private UserObj setSelectedShell(UserObj userObj) {
        SolServicesAttr solServicesAttr = userObj.getSolServicesAttr();
        if (solServicesAttr == null) {
            solServicesAttr = new SolServicesAttr();
        }
        String string = new String(SolServicesAttr.ROLE_BOURNE);
        if (this.shellComboBox.getSelectedIndex() == 2) {
            string = new String(SolServicesAttr.ROLE_KORN);
        } else if (this.shellComboBox.getSelectedIndex() == 1) {
            string = new String(SolServicesAttr.ROLE_CSHELL);
        }
        solServicesAttr.setInitialShell(string);
        userObj.setSolServicesAttr(solServicesAttr);
        return userObj;
    }

    private void setUpLabel(JLabel jLabel, String string) {
        this.actionString = new ActionString(this.bundle, string);
        jLabel.setText(this.actionString.getString());
        jLabel.setDisplayedMnemonic(this.actionString.getMnemonic());
    }

    public UserObj updateGenProps(UserObj userObj) {
        String string = null;
        String string2 = null;
        String string3 = null;
        string = this.roleDescriptionTextArea.getText();
        string2 = this.roleNameTextField.getText();
        string3 = this.roleFullNameTextField.getText();
        userObj.setUserDescription(string);
        userObj.setUserName(string2);
        userObj.setUserFullName(string3);
        userObj = this.setSelectedShell(userObj);
        return userObj;
    }
}

