/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.cli.common;

import com.sun.dhcpmgr.cli.common.ResourceStrings;
import java.text.MessageFormat;

public class GetOpt {
    protected int optind = 0;
    protected String optarg = null;
    protected String[] argv = null;
    protected int argc = 0;
    protected String optionString = null;
    int MINUS_POSITION = 0;
    int OPTION_POSITION = 1;
    int AFTER_OPTION_POSITION = 2;

    public GetOpt(String[] stringArray, String string) {
        this.argv = stringArray;
        this.optionString = string;
        this.argc = stringArray.length;
    }

    public int getNextOption() throws IllegalArgumentException {
        this.optarg = null;
        if (this.optind >= this.argc || this.argv[this.optind].length() < 2 || this.argv[this.optind].charAt(this.MINUS_POSITION) != '-') {
            return -1;
        }
        char c = this.argv[this.optind].charAt(this.OPTION_POSITION);
        if (!this.isValidOption(c)) {
            ++this.optind;
            String string = ResourceStrings.getString("getopt_illegal_option");
            Object[] objectArray = new Object[]{new Character(c)};
            String string2 = MessageFormat.format(string, objectArray);
            throw new IllegalArgumentException(string2);
        }
        if (this.isOptionArgAllowedByOption(c) && this.OPTION_POSITION == 1) {
            if (this.argv[this.optind].length() != 2) {
                this.optarg = this.argv[this.optind].substring(this.AFTER_OPTION_POSITION);
                ++this.optind;
            } else if (this.optind + 1 >= this.argc) {
                ++this.optind;
                if (this.isOptionArgMandatoryByOption(c)) {
                    String string = ResourceStrings.getString("getopt_requires_argument");
                    Object[] objectArray = new Object[]{new Character(c)};
                    String string3 = MessageFormat.format(string, objectArray);
                    throw new IllegalArgumentException(string3);
                }
            } else if (this.argv[this.optind + 1].charAt(this.MINUS_POSITION) == '-' && this.isValidOption(this.argv[this.optind + 1].charAt(this.OPTION_POSITION))) {
                ++this.optind;
                if (this.isOptionArgMandatoryByOption(c)) {
                    String string = ResourceStrings.getString("getopt_requires_argument");
                    Object[] objectArray = new Object[]{new Character(c)};
                    String string4 = MessageFormat.format(string, objectArray);
                    throw new IllegalArgumentException(string4);
                }
            } else {
                this.optarg = this.argv[++this.optind];
                ++this.optind;
            }
            this.OPTION_POSITION = 1;
        } else {
            if (this.isOptionArgMandatoryByOption(c)) {
                String string = ResourceStrings.getString("getopt_cannot_group");
                Object[] objectArray = new Object[]{new Character(c)};
                String string5 = MessageFormat.format(string, objectArray);
                throw new IllegalArgumentException(string5);
            }
            if (this.argv[this.optind].length() == this.OPTION_POSITION + 1) {
                this.OPTION_POSITION = 1;
                ++this.optind;
            } else {
                ++this.OPTION_POSITION;
            }
        }
        return c;
    }

    public int getNextOptionIndex() {
        return this.optind;
    }

    public String getOptionArg() {
        return this.optarg;
    }

    private boolean isOptionArgAllowedByOption(char c) {
        char c2 = c;
        return this.isValidOption(c) && this.optionString.length() > this.optionString.indexOf(c) + 1 && (this.optionString.charAt(this.optionString.indexOf(c) + 1) == ':' || this.optionString.charAt(this.optionString.indexOf(c) + 1) == ';');
    }

    private boolean isOptionArgMandatoryByOption(char c) {
        char c2 = c;
        return this.isValidOption(c) && this.optionString.length() > this.optionString.indexOf(c) + 1 && this.optionString.charAt(this.optionString.indexOf(c) + 1) == ':';
    }

    private boolean isValidOption(char c) {
        return c != ':' && this.optionString.indexOf(c) != -1;
    }
}

