/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.cli.common;

import com.sun.dhcpmgr.bridge.NoDefaultsException;
import com.sun.dhcpmgr.cli.common.DhcpCliOptions;
import com.sun.dhcpmgr.cli.common.DhcpCliPrint;
import com.sun.dhcpmgr.cli.common.ResourceStrings;
import com.sun.dhcpmgr.data.DhcpDatastore;
import com.sun.dhcpmgr.data.Option;
import com.sun.dhcpmgr.data.StandardOptions;
import com.sun.dhcpmgr.server.DhcpMgr;
import com.sun.dhcpmgr.server.DhcpMgrImpl;
import com.sun.dhcpmgr.server.DhcpNetMgr;
import com.sun.dhcpmgr.server.DhcpServiceMgr;
import com.sun.dhcpmgr.server.DhcptabMgr;

public abstract class DhcpCliFunction {
    protected DhcpCliOptions options = null;
    protected int[] validOptions;
    private static DhcpMgr dhcpMgr = null;
    private static DhcpNetMgr netMgr = null;
    private static DhcptabMgr dhcptabMgr = null;
    private static DhcpServiceMgr svcMgr = null;
    private DhcpDatastore datastore = null;

    public DhcpCliFunction() {
        dhcpMgr = new DhcpMgrImpl();
    }

    public DhcpDatastore createDhcpDatastore(String string, String string2, String string3) {
        return this.createDhcpDatastore(string, string2, string3, -1);
    }

    public DhcpDatastore createDhcpDatastore(String string, String string2, String string3, int n) {
        DhcpDatastore dhcpDatastore = null;
        if (string != null || string2 != null || string3 != null || n != -1) {
            dhcpDatastore = new DhcpDatastore(string, string2, string3, n);
        }
        return dhcpDatastore;
    }

    public abstract int execute() throws IllegalArgumentException;

    public DhcpDatastore getDhcpDatastore() {
        return this.datastore;
    }

    public static DhcpMgr getDhcpMgr() {
        return dhcpMgr;
    }

    public static DhcptabMgr getDhcptabMgr() {
        if (dhcptabMgr == null) {
            dhcptabMgr = dhcpMgr.getDhcptabMgr();
        }
        return dhcptabMgr;
    }

    public static String getMessage(Throwable throwable) {
        String string = throwable.getMessage();
        if (string == null) {
            string = throwable.toString();
        }
        return string;
    }

    public static DhcpNetMgr getNetMgr() {
        if (netMgr == null) {
            netMgr = dhcpMgr.getNetMgr();
        }
        return netMgr;
    }

    public static DhcpServiceMgr getSvcMgr() {
        if (svcMgr == null) {
            svcMgr = dhcpMgr.getDhcpServiceMgr();
        }
        return svcMgr;
    }

    public boolean isVersionValid(boolean bl) {
        boolean bl2 = false;
        try {
            bl2 = DhcpCliFunction.getSvcMgr().isVersionCurrent();
            if (!bl2) {
                this.printCmnErrMessage("need_to_convert_datastore");
            }
        }
        catch (NoDefaultsException noDefaultsException) {
            if (!bl) {
                this.printCmnErrMessage("no_conf_warning");
            }
            bl2 = true;
        }
        catch (Throwable throwable) {
            this.printCmnErrMessage(throwable.getMessage());
        }
        return bl2;
    }

    public void printCmnErrMessage(String string) {
        DhcpCliPrint.printErrMessage(ResourceStrings.getString(string));
    }

    public void printCmnMessage(String string) {
        DhcpCliPrint.printMessage(ResourceStrings.getString(string));
    }

    public void setDhcpDatastore(DhcpDatastore dhcpDatastore) {
        this.datastore = dhcpDatastore;
    }

    public void setDhcpDatastore(String string, String string2, String string3) {
        this.datastore = this.createDhcpDatastore(string, string2, string3);
    }

    public void setOptions(DhcpCliOptions dhcpCliOptions) throws IllegalArgumentException {
        dhcpCliOptions.validate(this.validOptions);
        this.options = dhcpCliOptions;
    }

    public void setStandardOptions() {
        try {
            StandardOptions.setAllOptions((Option[])DhcpCliFunction.getSvcMgr().getInittabOptions(Option.ctxts[Option.STANDARD].getCode()));
        }
        catch (Throwable throwable) {
            this.printCmnErrMessage(throwable.getMessage());
        }
    }
}

