/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.ui;

import com.sun.dhcpmgr.ui.ResourceStrings;
import com.sun.dhcpmgr.ui.SelectionListener;
import com.sun.dhcpmgr.ui.View;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MainFrame
extends JFrame {
    public static final int FILE_MENU = 0;
    public static final int EDIT_MENU = 1;
    public static final int VIEW_MENU = 2;
    public static final int ACTIONS_MENU = 3;
    public static final int HELP_MENU = 4;
    public static final int MENU_COUNT = 5;
    private static String[] menuKeys = new String[]{"file_menu", "edit_menu", "view_menu", "actions_menu", "help_menu"};
    private static int[] menuMnemonics = new int[]{70, 69, 86, 83, 72};
    private Action[][] menuActions = new Action[][]{{new ExitAction()}, {new CreateAction(), new DeleteAction(), new DuplicateAction(), new PropertiesAction()}, {new UpdateAction()}, new Action[0], new Action[0]};
    private JMenuBar menuBar;
    private JMenu[] menuList;
    private static StatusBar statusBar;
    private Component display = null;
    private JTabbedPane displayPanel;
    private View activeView;
    private View initialView;
    private Vector views;
    private int[] separatorIndex = new int[5];
    private ButtonGroup viewButtonGroup = new ButtonGroup();
    private ViewSelectionListener viewSelectionListener = new ViewSelectionListener();
    private boolean initialized = false;

    public MainFrame() {
        this("");
    }

    public MainFrame(String string) {
        super(string);
        int n;
        this.views = new Vector();
        Container container = this.getContentPane();
        this.menuBar = new JMenuBar();
        this.menuList = new JMenu[menuKeys.length];
        int n2 = 0;
        while (n2 < this.menuList.length) {
            this.menuList[n2] = this.menuBar.add(new JMenu(ResourceStrings.getString(menuKeys[n2])));
            this.menuList[n2].setMnemonic(menuMnemonics[n2]);
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.menuActions.length) {
            n = 0;
            while (n < this.menuActions[n3].length) {
                this.menuList[n3].add(this.menuActions[n3][n]);
                ++n;
            }
            ++n3;
        }
        n = 0;
        while (n < 5) {
            this.separatorIndex[n] = -1;
            ++n;
        }
        this.setJMenuBar(this.menuBar);
        container.setLayout(new BorderLayout());
        statusBar = new StatusBar();
        container.add((Component)statusBar, "South");
        this.displayPanel = new JTabbedPane();
        this.displayPanel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                block2: {
                    if (!MainFrame.this.initialized) break block2;
                    try {
                        MainFrame.this.setActiveView((View)MainFrame.this.views.elementAt(MainFrame.this.displayPanel.getSelectedIndex()));
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            }
        });
        container.add((Component)this.displayPanel, "Center");
        this.activeView = null;
    }

    public void addMenuAction(int n, Action action) {
        this.menuList[n].add(action);
    }

    public void addView(View view, boolean bl) {
        this.views.addElement(view);
        this.displayPanel.addTab(view.getName(), view.getDisplay());
        if (bl) {
            this.initialView = view;
        }
        view.addSelectionListener(this.viewSelectionListener);
    }

    public void deleteView(View view) {
        this.views.removeElement(view);
        if (view == this.activeView) {
            if (view != this.initialView) {
                this.setActiveView(this.initialView);
            } else {
                this.setActiveView((View)this.views.firstElement());
            }
        }
        this.displayPanel.remove(view.getDisplay());
        view.removeSelectionListener(this.viewSelectionListener);
    }

    public static String getStatusText() {
        return statusBar.getText();
    }

    public void initialize() {
        if (this.initialView != null) {
            this.setActiveView(this.initialView);
            this.initialized = true;
        }
    }

    public void refreshAllViews() {
        Enumeration enumeration = this.views.elements();
        while (enumeration.hasMoreElements()) {
            View view = (View)enumeration.nextElement();
            view.handleUpdate();
        }
    }

    public void setActiveView(View view) {
        Object object;
        Object object2;
        if (this.activeView != null) {
            this.activeView.setActive(false);
        }
        int n = 6;
        while (n < this.menuBar.getMenuCount()) {
            this.menuBar.remove(n);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.menuList.length) {
            JMenuItem jMenuItem;
            object2 = this.menuBar.getMenu(n2);
            if (this.activeView != null && (object = this.activeView.menuItems(n2)) != null) {
                if (this.separatorIndex[n2] != -1) {
                    ((JMenu)object2).remove(this.separatorIndex[n2]);
                    this.separatorIndex[n2] = -1;
                }
                while (object.hasMoreElements()) {
                    jMenuItem = (JMenuItem)object.nextElement();
                    if (jMenuItem == null) continue;
                    ((JMenu)object2).remove((Component)jMenuItem);
                }
            }
            if ((object = view.menuItems(n2)) != null) {
                while (object.hasMoreElements()) {
                    if (this.separatorIndex[n2] == -1) {
                        this.separatorIndex[n2] = ((JMenu)object2).getItemCount();
                        ((JMenu)object2).addSeparator();
                    }
                    if ((jMenuItem = (JMenuItem)object.nextElement()) == null) continue;
                    ((JMenu)object2).add(jMenuItem);
                }
            }
            ++n2;
        }
        object2 = view.menus();
        while (object2 != null && object2.hasMoreElements()) {
            object = (JMenu)object2.nextElement();
            if (object == null) continue;
            this.menuBar.add((JMenu)object);
        }
        this.activeView = view;
        this.activeView.setActive(true);
        this.viewSelectionListener.valueChanged();
        this.invalidate();
        this.validate();
    }

    public void setMenuEnabled(int n, boolean bl) {
        this.menuList[n].setEnabled(bl);
    }

    public static void setStatusText(String string) {
        statusBar.setText(string);
    }

    class StatusBar
    extends JPanel {
        private JLabel data;
        private FindPanel finder;

        public StatusBar() {
            super(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            this.data = new JLabel("", 2);
            Font font = this.data.getFont();
            Font font2 = new Font(font.getName(), 0, font.getSize());
            this.data.setFont(font2);
            this.data.setForeground(Color.black);
            this.add((Component)this.data, "West");
            this.finder = new FindPanel();
            this.add((Component)this.finder, "East");
        }

        public String getText() {
            return this.data.getText();
        }

        public void setText(String string) {
            this.data.setText(string);
            this.invalidate();
            this.validate();
        }
    }

    class FindPanel
    extends JPanel
    implements ActionListener {
        private JTextField text = new JTextField("", 20);
        private JButton button = new JButton(ResourceStrings.getString("next_button"));

        public FindPanel() {
            this.button.addActionListener(this);
            this.text.addActionListener(this);
            this.add(new JLabel(ResourceStrings.getString("find_label")));
            this.add(this.text);
            this.add(this.button);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.activeView.find(this.text.getText());
        }
    }

    class ExitAction
    extends AbstractAction {
        public ExitAction() {
            super(ResourceStrings.getString("exit_item"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ((Component)MainFrame.this).setVisible(false);
            MainFrame.this.dispose();
        }
    }

    class CreateAction
    extends AbstractAction {
        public CreateAction() {
            super(ResourceStrings.getString("create_item"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.activeView.handleCreate();
        }
    }

    class DeleteAction
    extends AbstractAction {
        public DeleteAction() {
            super(ResourceStrings.getString("delete_item"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.activeView.handleDelete();
        }
    }

    class DuplicateAction
    extends AbstractAction {
        public DuplicateAction() {
            super(ResourceStrings.getString("duplicate_item"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.activeView.handleDuplicate();
        }
    }

    class PropertiesAction
    extends AbstractAction {
        public PropertiesAction() {
            super(ResourceStrings.getString("properties_item"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.activeView.handleProperties();
        }
    }

    class UpdateAction
    extends AbstractAction {
        public UpdateAction() {
            super(ResourceStrings.getString("update_item"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.activeView.handleUpdate();
        }
    }

    class ViewSelectionListener
    implements SelectionListener {
        ViewSelectionListener() {
        }

        public void valueChanged() {
            int n = 1;
            while (n < MainFrame.this.menuActions[1].length) {
                if (n == 2) {
                    MainFrame.this.menuActions[1][n].setEnabled(!MainFrame.this.activeView.isSelectionEmpty() && !MainFrame.this.activeView.isSelectionMultiple());
                } else {
                    MainFrame.this.menuActions[1][n].setEnabled(MainFrame.this.activeView.isSelectionEmpty() ^ true);
                }
                ++n;
            }
        }
    }
}

