/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.client;

import com.sun.dhcpmgr.bridge.BridgeException;
import com.sun.dhcpmgr.client.ResourceStrings;
import com.sun.dhcpmgr.data.DhcpClientRecord;
import com.sun.dhcpmgr.data.Macro;
import com.sun.dhcpmgr.data.Network;
import com.sun.dhcpmgr.data.Option;
import com.sun.dhcpmgr.data.OptionsTable;
import com.sun.dhcpmgr.data.StandardOptions;
import com.sun.dhcpmgr.server.DhcpMgr;
import com.sun.dhcpmgr.server.DhcpMgrImpl;
import com.sun.dhcpmgr.server.DhcpNetMgr;
import com.sun.dhcpmgr.server.DhcpServiceMgr;
import com.sun.dhcpmgr.server.DhcptabMgr;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Arrays;
import javax.swing.JOptionPane;

public class DataManager {
    private DhcpMgr server;
    private DhcpNetMgr netMgr;
    private DhcptabMgr dhcptabMgr;
    private DhcpServiceMgr dhcpServiceMgr;
    private Network[] networks;
    private DhcpClientRecord[] clients;
    private String clientNet;
    private Macro[] macros;
    private Option[] options;
    private String serverName;
    private String shortServerName;
    private InetAddress serverAddress;
    private static DataManager mgr = null;

    private DataManager() {
        this.reset();
    }

    public static synchronized DataManager get() {
        if (mgr == null) {
            mgr = new DataManager();
        }
        return mgr;
    }

    public DhcpClientRecord[] getClients(String string, boolean bl) throws BridgeException {
        DhcpClientRecord[] dhcpClientRecordArray = this.clients;
        synchronized (dhcpClientRecordArray) {
            if (bl || this.clients.length == 0 || !string.equals(this.clientNet)) {
                this.clients = this.getDhcpNetMgr().loadNetwork(string);
                if (this.clients == null) {
                    this.clients = new DhcpClientRecord[0];
                }
                this.clientNet = string;
            }
        }
        return this.clients;
    }

    public synchronized DhcpNetMgr getDhcpNetMgr() {
        if (this.netMgr == null) {
            this.netMgr = this.getServer().getNetMgr();
        }
        return this.netMgr;
    }

    public synchronized DhcpServiceMgr getDhcpServiceMgr() {
        if (this.dhcpServiceMgr == null) {
            this.dhcpServiceMgr = this.getServer().getDhcpServiceMgr();
        }
        return this.dhcpServiceMgr;
    }

    public synchronized DhcptabMgr getDhcptabMgr() {
        if (this.dhcptabMgr == null) {
            this.dhcptabMgr = this.getServer().getDhcptabMgr();
        }
        return this.dhcptabMgr;
    }

    public Macro[] getMacros(boolean bl) throws BridgeException {
        Macro[] macroArray = this.macros;
        synchronized (macroArray) {
            if (bl || this.macros.length == 0) {
                this.macros = this.getDhcptabMgr().getMacros();
                if (this.macros == null) {
                    this.macros = new Macro[0];
                }
            }
        }
        return this.macros;
    }

    public Network[] getNetworks(boolean bl) throws BridgeException {
        Network[] networkArray = this.networks;
        synchronized (networkArray) {
            if (bl || this.networks.length == 0) {
                this.networks = this.getDhcpNetMgr().getNetworks();
                if (this.networks == null) {
                    this.networks = new Network[0];
                } else {
                    Arrays.sort(this.networks);
                }
            }
        }
        return this.networks;
    }

    public Option[] getOptions(boolean bl) throws BridgeException {
        Option[] optionArray = this.options;
        synchronized (optionArray) {
            if (bl || this.options.length == 0) {
                this.options = this.getDhcptabMgr().getOptions();
                if (this.options == null) {
                    this.options = new Option[0];
                }
                OptionsTable.getTable().add(this.options);
            }
        }
        return this.options;
    }

    public synchronized DhcpMgr getServer() {
        return this.server;
    }

    public synchronized InetAddress getServerAddress() {
        return this.serverAddress;
    }

    public synchronized String getServerName() {
        return this.serverName;
    }

    public synchronized String getShortServerName() {
        return this.shortServerName;
    }

    public synchronized void reset() {
        this.server = new DhcpMgrImpl();
        this.netMgr = null;
        this.dhcptabMgr = null;
        this.dhcpServiceMgr = null;
        this.networks = new Network[0];
        this.clients = new DhcpClientRecord[0];
        this.clientNet = null;
        this.macros = new Macro[0];
        this.options = new Option[0];
        try {
            this.serverAddress = InetAddress.getLocalHost();
            this.setServerName(this.serverAddress.getHostName());
        }
        catch (UnknownHostException unknownHostException) {
            this.shortServerName = "";
            this.serverName = "";
        }
        try {
            StandardOptions.setAllOptions((Option[])this.getDhcpServiceMgr().getInittabOptions(Option.ctxts[Option.STANDARD].getCode()));
        }
        catch (Throwable throwable) {
            MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("stdopts_init_error"));
            Object[] objectArray = new Object[]{throwable instanceof BridgeException ? throwable.getMessage() : throwable.toString()};
            JOptionPane.showMessageDialog(null, messageFormat.format(objectArray), ResourceStrings.getString("init_error"), 0);
        }
    }

    public synchronized void setServer(String string) throws Exception {
        this.setServerName(string);
        this.serverAddress = null;
    }

    private void setServerName(String string) {
        this.serverName = string;
        int n = this.serverName.indexOf(46);
        this.shortServerName = n == -1 ? this.serverName : this.serverName.substring(0, n);
    }
}

