/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.client;

import com.sun.dhcpmgr.bridge.ExistsException;
import com.sun.dhcpmgr.client.DSWizard;
import com.sun.dhcpmgr.client.DataManager;
import com.sun.dhcpmgr.client.DhcpmgrApplet;
import com.sun.dhcpmgr.client.ErrorTable;
import com.sun.dhcpmgr.client.ResourceStrings;
import com.sun.dhcpmgr.data.DhcpDatastore;
import com.sun.dhcpmgr.data.DhcpdOptions;
import com.sun.dhcpmgr.data.Network;
import com.sun.dhcpmgr.server.DhcpNetMgr;
import com.sun.dhcpmgr.server.DhcpServiceMgr;
import com.sun.dhcpmgr.server.DhcptabMgr;
import com.sun.dhcpmgr.ui.FieldLayout;
import com.sun.dhcpmgr.ui.ProgressManager;
import com.sun.dhcpmgr.ui.Wizard;
import com.sun.dhcpmgr.ui.WizardStep;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.text.MessageFormat;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class ConvertWizard
extends DSWizard {
    private DhcpServiceMgr svcServer;
    private DhcptabMgr dhcptabServer;
    private DhcpNetMgr netServer;
    private DhcpdOptions dhcpdOptions;
    private DSWizard.DSConf defaultDsconf;
    private SaveTablesStep saveTablesStep;
    private Network[] networks = null;
    static /* synthetic */ Class class$java$lang$String;

    public ConvertWizard(Frame frame, String string) {
        super(frame, string);
        try {
            this.svcServer = DataManager.get().getDhcpServiceMgr();
            this.dhcptabServer = DataManager.get().getDhcptabMgr();
            this.netServer = DataManager.get().getDhcpNetMgr();
            this.dhcpdOptions = this.svcServer.readDefaults();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
        this.dsconfList = new DSWizard.DSConfList(this);
        this.dsconfList.init(this.svcServer);
        this.defaultDsconf = this.dsconfList.findDsconf(this.dhcpdOptions.getResource());
        String string2 = null;
        string2 = this.defaultDsconf != null ? this.defaultDsconf.getModule().getDescription() : this.dhcpdOptions.getResource();
        Object[] objectArray = new Object[]{string2};
        MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("cvt_wiz_explain"));
        String string3 = messageFormat.format(objectArray);
        ConvertWizard convertWizard = this;
        convertWizard.getClass();
        DSWizard.DatastoreStep datastoreStep = new DSWizard.DatastoreStep(convertWizard, string3, ResourceStrings.getString("cvt_wiz_store_explain"));
        this.addStep(datastoreStep);
        this.addStep(new DSWizard.DatastoreModuleStep(this));
        this.saveTablesStep = new SaveTablesStep();
        this.addStep(this.saveTablesStep);
        this.addStep(new ReviewStep());
        this.showFirstStep();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void doFinish() {
        this.getDsconf().setLocation();
        this.getDsconf().setConfig();
        final DhcpDatastore dhcpDatastore = this.getDsconf().getDS();
        final DhcpDatastore dhcpDatastore2 = this.dhcpdOptions.getDhcpDatastore();
        if (dhcpDatastore.equals((Object)dhcpDatastore2)) {
            JOptionPane.showMessageDialog(this, ResourceStrings.getString("cvt_wiz_same_datastore_error"), ResourceStrings.getString("cvt_wiz_error"), 0);
            return;
        }
        try {
            this.svcServer.makeLocation(dhcpDatastore);
        }
        catch (ExistsException existsException) {
        }
        catch (Throwable throwable) {
            MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("cvt_wiz_location_error"));
            Object[] objectArray = new Object[]{dhcpDatastore.getLocation()};
            String string = messageFormat.format(objectArray);
            JOptionPane.showMessageDialog(this, string, ResourceStrings.getString("cvt_wiz_error"), 0);
            return;
        }
        try {
            this.networks = this.netServer.getNetworks(dhcpDatastore2);
            if (this.networks == null) {
                this.networks = new Network[0];
            }
        }
        catch (Throwable throwable) {
            MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("cvt_wiz_networks_error"));
            Object[] objectArray = new Object[]{throwable.getMessage()};
            String string = messageFormat.format(objectArray);
            JOptionPane.showMessageDialog(this, string, ResourceStrings.getString("cvt_wiz_error"), 0);
            this.reallyFinish();
            return;
        }
        final int n = this.networks.length + 1;
        int n2 = !this.saveTablesStep.isSaveTablesSelected() ? n * 2 : n;
        final ProgressManager progressManager = new ProgressManager(this, ResourceStrings.getString("cvt_wiz_progress"), "", 0, n2 += 3);
        final Runnable runnable = new Runnable(){

            public void run() {
                ConvertWizard.this.reallyFinish();
            }
        };
        Thread thread = new Thread(){

            public void run() {
                String string;
                Object var11_23;
                String string2;
                String string3 = null;
                Object[] objectArray = new Object[1];
                boolean bl = saveTablesStep.isSaveTablesSelected();
                ErrorTable errorTable = new ErrorTable(ResourceStrings.getString("cvt_wiz_table"), class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = ConvertWizard.class$("java.lang.String")));
                int n4 = 0;
                try {
                    try {
                        svcServer.shutdown();
                        string3 = ResourceStrings.getString("cvt_wiz_server_shutdown");
                    }
                    catch (Throwable throwable) {
                        string3 = ResourceStrings.getString("cvt_wiz_shutdown_err");
                        errorTable.addError("", throwable.getMessage());
                        bl = true;
                    }
                    string2 = null;
                }
                catch (Throwable throwable) {
                    Object var9_13 = null;
                    try {
                        progressManager.update(++n4, string3);
                    }
                    catch (InterruptedException interruptedException) {
                        SwingUtilities.invokeLater(runnable);
                        return;
                    }
                    throw throwable;
                }
                try {
                    progressManager.update(++n4, string3);
                }
                catch (InterruptedException interruptedException) {
                    SwingUtilities.invokeLater(runnable);
                    return;
                }
                try {
                    try {
                        dhcptabServer.cvtDhcptab(dhcpDatastore);
                        string3 = ResourceStrings.getString("cvt_wiz_progress_dhcptab_cvt");
                    }
                    catch (Throwable throwable) {
                        string3 = ResourceStrings.getString("cvt_wiz_progress_dhcptab_cvt_err");
                        errorTable.addError(ResourceStrings.getString("cvt_wiz_dhcptab"), throwable.getMessage());
                        bl = true;
                    }
                    string2 = null;
                }
                catch (Throwable throwable) {
                    string2 = null;
                    try {
                        progressManager.update(++n4, string3);
                    }
                    catch (InterruptedException interruptedException) {
                        SwingUtilities.invokeLater(runnable);
                        return;
                    }
                    throw throwable;
                }
                try {
                    progressManager.update(++n4, string3);
                }
                catch (InterruptedException interruptedException) {
                    SwingUtilities.invokeLater(runnable);
                    return;
                }
                MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("cvt_wiz_progress_network_cvt"));
                MessageFormat messageFormat2 = new MessageFormat(ResourceStrings.getString("cvt_wiz_progress_network_cvt_err"));
                int n2 = 0;
                while (n2 < networks.length) {
                    string2 = networks[n2].toString();
                    objectArray[0] = string2;
                    try {
                        try {
                            netServer.cvtNetwork(string2, dhcpDatastore);
                            string3 = messageFormat.format(objectArray);
                        }
                        catch (Throwable throwable) {
                            string3 = messageFormat2.format(objectArray);
                            errorTable.addError(string2, throwable.getMessage());
                            bl = true;
                        }
                        var11_23 = null;
                    }
                    catch (Throwable throwable) {
                        var11_23 = null;
                        try {
                            progressManager.update(++n4, string3);
                        }
                        catch (InterruptedException interruptedException) {
                            SwingUtilities.invokeLater(runnable);
                            return;
                        }
                        throw throwable;
                    }
                    try {
                        progressManager.update(++n4, string3);
                    }
                    catch (InterruptedException interruptedException) {
                        SwingUtilities.invokeLater(runnable);
                        return;
                    }
                    ++n2;
                }
                dhcpdOptions.setDhcpDatastore(dhcpDatastore);
                try {
                    try {
                        svcServer.writeDefaults(dhcpdOptions);
                        string3 = ResourceStrings.getString("cvt_wiz_progress_defaults");
                    }
                    catch (Throwable throwable) {
                        string3 = ResourceStrings.getString("cvt_wiz_progress_defaults_err");
                        errorTable.addError(ResourceStrings.getString("cvt_wiz_defaults"), throwable.getMessage());
                        bl = true;
                    }
                    string = null;
                }
                catch (Throwable throwable) {
                    string = null;
                    try {
                        progressManager.update(++n4, string3);
                    }
                    catch (InterruptedException interruptedException) {
                        SwingUtilities.invokeLater(runnable);
                        return;
                    }
                    throw throwable;
                }
                try {
                    progressManager.update(++n4, string3);
                }
                catch (InterruptedException interruptedException) {
                    SwingUtilities.invokeLater(runnable);
                    return;
                }
                if (!bl) {
                    messageFormat = new MessageFormat(ResourceStrings.getString("cvt_wiz_progress_network_del"));
                    messageFormat2 = new MessageFormat(ResourceStrings.getString("cvt_wiz_progress_network_del_err"));
                    int n3 = 0;
                    while (n3 < networks.length) {
                        Object var12_28;
                        string = networks[n3].toString();
                        objectArray[0] = string;
                        try {
                            try {
                                netServer.deleteNetwork(string, false, false, dhcpDatastore2);
                                string3 = messageFormat.format(objectArray);
                            }
                            catch (Throwable throwable) {
                                string3 = messageFormat2.format(objectArray);
                                errorTable.addError(string, throwable.getMessage());
                            }
                            var12_28 = null;
                        }
                        catch (Throwable throwable) {
                            var12_28 = null;
                            try {
                                progressManager.update(++n4, string3);
                            }
                            catch (InterruptedException interruptedException) {
                                SwingUtilities.invokeLater(runnable);
                                return;
                            }
                            throw throwable;
                        }
                        try {
                            progressManager.update(++n4, string3);
                        }
                        catch (InterruptedException interruptedException) {
                            SwingUtilities.invokeLater(runnable);
                            return;
                        }
                        ++n3;
                    }
                    try {
                        try {
                            dhcptabServer.deleteDhcptab(dhcpDatastore2);
                            string3 = ResourceStrings.getString("cvt_wiz_progress_dhcptab_del");
                        }
                        catch (Throwable throwable) {
                            string3 = ResourceStrings.getString("cvt_wiz_progress_dhcptab_del_err");
                            errorTable.addError(ResourceStrings.getString("cvt_wiz_dhcptab"), throwable.getMessage());
                        }
                        var11_23 = null;
                    }
                    catch (Throwable throwable) {
                        var11_23 = null;
                        try {
                            progressManager.update(++n4, string3);
                        }
                        catch (InterruptedException interruptedException) {
                            SwingUtilities.invokeLater(runnable);
                            return;
                        }
                        throw throwable;
                    }
                    try {
                        progressManager.update(++n4, string3);
                    }
                    catch (InterruptedException interruptedException) {
                        SwingUtilities.invokeLater(runnable);
                        return;
                    }
                }
                if (!saveTablesStep.isSaveTablesSelected()) {
                    try {
                        progressManager.update(n4 += n, "");
                    }
                    catch (InterruptedException interruptedException) {
                        SwingUtilities.invokeLater(runnable);
                        return;
                    }
                }
                if (dhcpdOptions.isDaemonEnabled()) {
                    try {
                        try {
                            svcServer.startup();
                            string3 = ResourceStrings.getString("cvt_wiz_server_started");
                        }
                        catch (Throwable throwable) {
                            string3 = ResourceStrings.getString("cvt_wiz_start_err");
                            errorTable.addError("", throwable.getMessage());
                        }
                        string = null;
                    }
                    catch (Throwable throwable) {
                        string = null;
                        try {
                            progressManager.update(++n4, string3);
                        }
                        catch (InterruptedException interruptedException) {
                            SwingUtilities.invokeLater(runnable);
                            return;
                        }
                        throw throwable;
                    }
                    try {
                        progressManager.update(++n4, string3);
                    }
                    catch (InterruptedException interruptedException) {
                        SwingUtilities.invokeLater(runnable);
                        return;
                    }
                }
                if (!errorTable.isEmpty()) {
                    Runnable runnable2 = new Runnable(errorTable, this){
                        private final /* synthetic */ ConvertWizard this$0;
                        private final /* synthetic */ ErrorTable val$failedTable;
                        {
                            this.val$failedTable = errorTable;
                            this.this$0 = convertWizard;
                        }

                        public void run() {
                            Object[] objectArray = new Object[2];
                            objectArray[0] = ResourceStrings.getString("cvt_wiz_errors");
                            JScrollPane jScrollPane = new JScrollPane(this.val$failedTable);
                            Dimension dimension = this.val$failedTable.getPreferredScrollableViewportSize();
                            dimension.height = 80;
                            this.val$failedTable.setPreferredScrollableViewportSize(dimension);
                            objectArray[1] = jScrollPane;
                            JOptionPane.showMessageDialog(this.this$0, objectArray, ResourceStrings.getString("server_error_title"), 0);
                        }
                    };
                    try {
                        SwingUtilities.invokeAndWait(runnable2);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
                SwingUtilities.invokeLater(runnable);
            }
        };
        thread.start();
    }

    public void doHelp() {
        DhcpmgrApplet.showHelp("convert_wizard");
    }

    protected void reallyFinish() {
        super.doFinish();
    }

    protected class SaveTablesStep
    implements WizardStep {
        private Box stepBox = Box.createVerticalBox();
        private JCheckBox saveTables;

        public SaveTablesStep() {
            this.stepBox.add(Wizard.createTextArea(ResourceStrings.getString("cvt_wiz_save_explain"), 4, 45));
            this.stepBox.add(Box.createVerticalStrut(10));
            this.stepBox.add(Box.createVerticalGlue());
            this.saveTables = new JCheckBox(ResourceStrings.getString("cvt_wiz_save_label"), false);
            this.saveTables.setAlignmentX(0.0f);
            this.stepBox.add(this.saveTables);
            this.stepBox.add(Box.createVerticalGlue());
            this.stepBox.add(Wizard.createTextArea(ResourceStrings.getString("cvt_wiz_save_note"), 4, 45));
            this.stepBox.add(Box.createVerticalStrut(10));
            this.stepBox.add(Box.createVerticalGlue());
        }

        public Component getComponent() {
            return this.stepBox;
        }

        public String getDescription() {
            return ResourceStrings.getString("cvt_wiz_save_tables_desc");
        }

        public boolean isSaveTablesSelected() {
            return this.saveTables.isSelected();
        }

        public void setActive(int n) {
            ConvertWizard.this.setForwardEnabled(true);
        }

        public boolean setInactive(int n) {
            return true;
        }
    }

    class ReviewStep
    implements WizardStep {
        private JLabel oldStoreLabel;
        private JLabel newStoreLabel;
        private JLabel saveLabel;
        private Box stepBox = Box.createVerticalBox();
        private JPanel panel;

        public ReviewStep() {
            this.stepBox.add(Wizard.createTextArea(ResourceStrings.getString("cvt_wiz_review_explain"), 3, 45));
            this.panel = new JPanel(new FieldLayout());
            this.addLabel("cvt_wiz_old_datastore");
            this.oldStoreLabel = this.addField("uninitialized");
            this.addLabel("cvt_wiz_new_datastore");
            this.newStoreLabel = this.addField("uninitialized");
            this.addLabel("cvt_wiz_save_tables");
            this.saveLabel = this.addField("uninitialized");
            this.stepBox.add(this.panel);
            this.stepBox.add(Box.createVerticalGlue());
            this.stepBox.add(Wizard.createTextArea(ResourceStrings.getString("cvt_wiz_review_note"), 4, 45));
            this.stepBox.add(Box.createVerticalStrut(10));
            this.stepBox.add(Box.createVerticalGlue());
        }

        private JLabel addField(String string) {
            JLabel jLabel = new JLabel(string);
            jLabel.setForeground(Color.black);
            this.panel.add("Field", jLabel);
            return jLabel;
        }

        private void addLabel(String string) {
            this.panel.add("Label", new JLabel(ResourceStrings.getString(string)));
        }

        public Component getComponent() {
            return this.stepBox;
        }

        public String getDescription() {
            return ResourceStrings.getString("cvt_wiz_review_desc");
        }

        public void setActive(int n) {
            ConvertWizard.this.setFinishEnabled(true);
            String string = null;
            string = ConvertWizard.this.defaultDsconf != null ? ConvertWizard.this.defaultDsconf.getModule().getDescription() : ConvertWizard.this.dhcpdOptions.getResource();
            this.oldStoreLabel.setText(string);
            this.newStoreLabel.setText(ConvertWizard.this.getDsconf().getModule().getDescription());
            String string2 = null;
            string2 = ConvertWizard.this.saveTablesStep.isSaveTablesSelected() ? ResourceStrings.getString("yes") : ResourceStrings.getString("no");
            this.saveLabel.setText(string2);
        }

        public boolean setInactive(int n) {
            return true;
        }
    }
}

