/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.security;

import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMNameSpace;
import com.sun.wbem.cim.CIMSecurityException;
import com.sun.wbem.client.ClientProps;
import com.sun.wbem.security.ClientSecurityContext;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.Principal;
import java.util.StringTokenizer;
import java.util.Vector;

public class ClientSecurityFactory {
    private static final String PROP_SECURITY = "security";
    private static final String PROP_TRANSPORT = "transport";
    private static final String PROP_PROTOCOL = "protocol";
    private static final String PROP_MECHANISM = "mechanism";
    private static final String PROP_CLASS = "client.class";
    private static final String PROP_DEFAULT_SECURITY = "security.default";
    private static final String HTTP_PROTOCOL = "http";
    private static final String RMI_PROTOCOL = "rmi";
    private static final String DFLT_HTTP_SECURITY = "httpbasic";
    private static final String DFLT_RMI_SECURITY = "rmidigest";
    private static final String DFLT_HTTPBASIC_CLASS = "com.sun.wbem.security.HttpClientSecurity";
    private static final String DFLT_RMIDIGEST_CLASS = "com.sun.wbem.security.RmiClientSecurity";
    static /* synthetic */ Class class$com$sun$wbem$cim$CIMNameSpace;
    static /* synthetic */ Class class$java$security$Principal;
    static /* synthetic */ Class class$java$lang$Object;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static ClientSecurityContext createClientSecurity(CIMNameSpace cIMNameSpace, Principal principal, Object object, String string, int n) throws CIMException {
        String string2;
        String string3;
        String string4 = null;
        String string5 = null;
        if (string != null) {
            string5 = string.toLowerCase();
        }
        if ((string3 = ClientProps.getProperty(string4 = "transport.protocol." + n)) == null) {
            if (n == 0) {
                string3 = HTTP_PROTOCOL;
            } else if (n == 1) {
                string3 = RMI_PROTOCOL;
            }
        }
        if (string3 == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", PROP_PROTOCOL);
        }
        string3 = string3.toLowerCase();
        if ((string5 == null || string5.trim().length() == 0) && (string5 = ClientProps.getProperty(string4 = "transport." + string3 + "." + PROP_DEFAULT_SECURITY)) == null) {
            if (string3.equals(HTTP_PROTOCOL)) {
                string5 = DFLT_HTTP_SECURITY;
            } else if (string3.equals(RMI_PROTOCOL)) {
                string5 = DFLT_RMI_SECURITY;
            } else {
                throw new CIMSecurityException("No default mechanism");
            }
        }
        if ((string2 = ClientProps.getProperty(string4 = "security." + string3 + "." + PROP_TRANSPORT)) == null) {
            if (string5.equals(DFLT_HTTP_SECURITY)) {
                string2 = HTTP_PROTOCOL;
            } else if (string5.equals(DFLT_RMI_SECURITY)) {
                string2 = RMI_PROTOCOL;
            }
        }
        if (string2 == null) {
            throw new CIMSecurityException("Invalid mechanism for protocol");
        }
        Vector vector = ClientSecurityFactory.parseList(string2);
        if (!vector.contains(string3)) {
            throw new CIMSecurityException("Invalid mechanism for protocol");
        }
        string4 = "security." + string5 + "." + PROP_CLASS;
        String string6 = ClientProps.getProperty(string4);
        if (string6 == null) {
            if (string5.equals(DFLT_HTTP_SECURITY)) {
                string6 = DFLT_HTTPBASIC_CLASS;
            } else if (string5.equals(DFLT_RMI_SECURITY)) {
                string6 = DFLT_RMIDIGEST_CLASS;
            }
        }
        if (string6 == null) {
            throw new CIMSecurityException("No class for mechanism");
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string6);
        }
        catch (Exception exception) {
            throw new CIMException("No class for mechanism");
        }
        ClientSecurityContext clientSecurityContext = null;
        try {
            Class[] classArray = new Class[]{class$com$sun$wbem$cim$CIMNameSpace != null ? class$com$sun$wbem$cim$CIMNameSpace : (class$com$sun$wbem$cim$CIMNameSpace = ClientSecurityFactory.class$("com.sun.wbem.cim.CIMNameSpace")), class$java$security$Principal != null ? class$java$security$Principal : (class$java$security$Principal = ClientSecurityFactory.class$("java.security.Principal")), class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = ClientSecurityFactory.class$("java.lang.Object"))};
            Object[] objectArray = new Object[]{cIMNameSpace, principal, object};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            clientSecurityContext = (ClientSecurityContext)constructor.newInstance(objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            System.out.println("ClientSecurityFactory: error in " + string6 + " constructor: " + throwable.getMessage());
            throw new CIMException("Cannot instantiate client security");
        }
        catch (Exception exception) {
            System.out.println("ClientSecurityFactory: error creating " + string6 + " instance: " + exception.getMessage());
            throw new CIMException("Cannot instantiate client security");
        }
        return clientSecurityContext;
    }

    public static String[] getSecurityMechanisms() {
        String string = "security.mechanism";
        return ClientProps.getPropertyList(string);
    }

    private static Vector parseList(String string) {
        Vector<String> vector = new Vector<String>(10);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = (String)stringTokenizer.nextElement();
            vector.addElement(string2);
        }
        return vector;
    }
}

