/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.query;

import com.sun.wbem.cim.UnsignedInt16;
import com.sun.wbem.cim.UnsignedInt32;
import com.sun.wbem.cim.UnsignedInt64;
import com.sun.wbem.cim.UnsignedInt8;
import com.sun.wbem.query.ValueExp;

public class NumericValue
extends ValueExp {
    private long longVal;
    private double doubleVal;
    private UnsignedInt64 uint64;
    private boolean uint = false;
    private boolean sint = false;
    private boolean dbl = false;

    public NumericValue() {
        this.longVal = 0L;
        this.sint = true;
    }

    public NumericValue(Number number) {
        if (number instanceof Long || number instanceof Integer || number instanceof Short || number instanceof Byte) {
            this.longVal = number.longValue();
            this.sint = true;
        } else if (number instanceof UnsignedInt64 || number instanceof UnsignedInt8 || number instanceof UnsignedInt16 || number instanceof UnsignedInt32) {
            this.uint64 = number instanceof UnsignedInt64 ? (UnsignedInt64)number : new UnsignedInt64(number.toString());
            this.uint = true;
        } else {
            this.doubleVal = new Double(String.valueOf(String.valueOf(number)));
            this.dbl = true;
        }
    }

    public double doubleValue() {
        if (this.sint) {
            return this.longVal;
        }
        if (this.uint) {
            return this.uint64.doubleValue();
        }
        return this.doubleVal;
    }

    public boolean isReal() {
        return this.dbl;
    }

    public boolean isSint() {
        return this.sint;
    }

    public boolean isUint() {
        return this.uint;
    }

    public long longValue() {
        if (this.sint) {
            return this.longVal;
        }
        if (this.uint) {
            return this.uint64.longValue();
        }
        return (long)this.doubleVal;
    }

    public String toString() {
        if (this.uint) {
            return this.uint64.toString();
        }
        if (this.sint) {
            return String.valueOf(this.longVal);
        }
        return String.valueOf(this.doubleVal);
    }

    public UnsignedInt64 uint64Value() {
        if (this.sint) {
            return new UnsignedInt64(String.valueOf(this.longVal));
        }
        if (this.uint) {
            return this.uint64;
        }
        return new UnsignedInt64(String.valueOf((long)this.doubleVal));
    }
}

