/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cim;

import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMDataType;
import com.sun.wbem.cim.CIMDateTime;
import com.sun.wbem.cim.CIMElement;
import com.sun.wbem.cim.CIMFlavor;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMMethod;
import com.sun.wbem.cim.CIMParameter;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMQualifier;
import com.sun.wbem.cim.CIMQualifierType;
import com.sun.wbem.cim.CIMScope;
import com.sun.wbem.cim.CIMValue;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;

class MOFFormatter
implements Serializable {
    static final long serialVersionUID = 200L;
    private final String INDENT = "    ";
    private final String TAB = "\t";
    private final String QUOTE = "\"";
    private final String SPACE = " ";
    private final String COLON = ":";
    private final String LINE = "\n";
    private static final String ANY = "any";
    private static final String AS = "as";
    private static final String ASSOCIATION = "association";
    private static final String CLASS = "class";
    private static final String DISABLEOVERRIDE = "disableoverride";
    private static final String DT_BOOL = "boolean";
    private static final String DT_CHAR16 = "char16";
    private static final String DT_DATETIME = "datetime";
    private static final String DT_REAL32 = "real32";
    private static final String DT_REAL64 = "real64";
    private static final String DT_SINT16 = "sint16";
    private static final String DT_SINT32 = "sint32";
    private static final String DT_SINT64 = "sint64";
    private static final String DT_SINT8 = "sint8";
    private static final String DT_STR = "string";
    private static final String DT_UINT16 = "uint16";
    private static final String DT_UINT32 = "uint32";
    private static final String DT_UINT64 = "uint64";
    private static final String DT_UINT8 = "uint8";
    private static final String ENABLEOVERRIDE = "enableoverride";
    private static final String FALSE = "false";
    private static final String FLAVOR = "Flavor";
    private static final String INDICATION = "indication";
    private static final String INSTANCE = "instance";
    private static final String METHOD = "method";
    private static final String NULL = "null";
    private static final String OF = "of";
    private static final String PARAMETER = "parameter";
    private static final String PRAGMA = "#pragma";
    private static final String PROPERTY = "property";
    private static final String QUALIFIER = "qualifier";
    private static final String REF = "ref";
    private static final String REFERENCE = "reference";
    private static final String RESTRICTED = "restricted";
    private static final String SCHEMA = "schema";
    private static final String SCOPE = "Scope";
    private static final String TOSUBCLASS = "tosubclass";
    private static final String TRANSLATABLE = "translatable";
    private static final String TRUE = "true";
    private boolean cimclass = true;

    public String cimClass(CIMClass cIMClass) {
        String string = "class " + cIMClass.getName();
        if (cIMClass.getSuperClass().length() > 0) {
            string = string.concat(":" + cIMClass.getSuperClass());
        }
        return new String(String.valueOf(this.vectorToMOFString(cIMClass.getQualifiers(), true, true)) + string + "\n" + "{" + "\n" + this.vectorToMOFString(cIMClass.getProperties()) + "\n" + this.vectorToMOFString(cIMClass.getMethods()) + "\n" + "};");
    }

    public String cimDataType(CIMDataType cIMDataType) {
        switch (cIMDataType.getType()) {
            case 0: {
                return new String(DT_UINT8);
            }
            case 1: {
                return new String(DT_SINT8);
            }
            case 2: {
                return new String(DT_UINT16);
            }
            case 3: {
                return new String(DT_SINT16);
            }
            case 4: {
                return new String(DT_UINT32);
            }
            case 5: {
                return new String(DT_SINT32);
            }
            case 6: {
                return new String(DT_UINT64);
            }
            case 7: {
                return new String(DT_SINT64);
            }
            case 10: {
                return new String(DT_REAL32);
            }
            case 11: {
                return new String(DT_REAL64);
            }
            case 8: {
                return new String(DT_STR);
            }
            case 13: {
                return new String(DT_CHAR16);
            }
            case 12: {
                return new String(DT_DATETIME);
            }
            case 9: {
                return new String(DT_BOOL);
            }
            case 14: {
                return new String("uint8[]");
            }
            case 15: {
                return new String("sint8[]");
            }
            case 16: {
                return new String("uint16[]");
            }
            case 17: {
                return new String("sint16[]");
            }
            case 18: {
                return new String("uint32[]");
            }
            case 19: {
                return new String("sint32[]");
            }
            case 20: {
                return new String("uint64[]");
            }
            case 21: {
                return new String("sint64[]");
            }
            case 24: {
                return new String("real32[]");
            }
            case 25: {
                return new String("real64[]");
            }
            case 22: {
                return new String("string[]");
            }
            case 27: {
                return new String("char16[]");
            }
            case 26: {
                return new String("datetime[]");
            }
            case 23: {
                return new String("boolean[]");
            }
            case 30: {
                return new String(NULL);
            }
            case 28: {
                return new String(String.valueOf(cIMDataType.getRefClassName()) + " REF");
            }
        }
        return "";
    }

    public String cimDateTime(CIMDateTime cIMDateTime) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss.SSS000");
        Calendar calendar = cIMDateTime.getCalendar();
        if (calendar == null) {
            return NULL;
        }
        TimeZone timeZone = calendar.getTimeZone();
        if (cIMDateTime.isInterval()) {
            return String.valueOf(simpleDateFormat.format(calendar.getTime())) + ":000";
        }
        int n = calendar.get(15) + calendar.get(16);
        double d = (double)n * 0.001 / 60.0;
        return String.valueOf(simpleDateFormat.format(calendar.getTime())) + (int)d;
    }

    public String cimFlavor(CIMFlavor cIMFlavor) {
        switch (cIMFlavor.getFlavor()) {
            case 0: {
                return ENABLEOVERRIDE;
            }
            case 1: {
                return DISABLEOVERRIDE;
            }
            case 2: {
                return RESTRICTED;
            }
            case 3: {
                return TOSUBCLASS;
            }
            case 4: {
                return TRANSLATABLE;
            }
        }
        return "UNKNOWN";
    }

    public String cimInstance(CIMInstance cIMInstance) {
        this.cimclass = false;
        String string = new String("instance of " + cIMInstance.getClassName() + " " + "{" + "\n" + this.vectorToMOFString(cIMInstance.getProperties()) + "\n" + "};");
        this.cimclass = true;
        return string;
    }

    public String cimMethod(CIMMethod cIMMethod) {
        return new String("    " + cIMMethod.getType() + " " + cIMMethod.getName() + "(" + this.vectorToMOFString(cIMMethod.getParameters(), "", false, true, false) + ");");
    }

    public String cimParameter(CIMParameter cIMParameter) {
        return new String(String.valueOf(String.valueOf(cIMParameter.getQualifiers())) + " " + cIMParameter.getType() + " " + cIMParameter.getName());
    }

    public String cimProperty(CIMProperty cIMProperty) {
        if (this.cimclass) {
            return new String(String.valueOf(this.vectorToMOFString(cIMProperty.getQualifiers(), "    ", true, true, true)) + "    " + cIMProperty.getType() + " " + cIMProperty.getName() + ";" + "\n");
        }
        return new String("    " + cIMProperty.getName() + " = " + cIMProperty.getValue() + ";");
    }

    public String cimQualifier(CIMQualifier cIMQualifier) {
        String string = cIMQualifier.getName();
        if (cIMQualifier.getValue() == null) {
            return new String(string);
        }
        if (cIMQualifier.getValue().getType() != null && cIMQualifier.getValue().getType().isArrayType()) {
            return new String(String.valueOf(string) + "{" + cIMQualifier.getValue().toString() + "}");
        }
        return new String(String.valueOf(string) + "(" + cIMQualifier.getValue().toString() + ")");
    }

    public String cimQualifierType(CIMQualifierType cIMQualifierType) {
        String string = "";
        String string2 = "";
        String string3 = "";
        if (!cIMQualifierType.getScope().isEmpty()) {
            string = "Scope(" + this.vectorToMOFString(cIMQualifierType.getScope(), "", false, true, false) + ")";
        }
        if (!cIMQualifierType.getFlavor().isEmpty()) {
            string2 = ", Flavor(" + this.vectorToMOFString(cIMQualifierType.getFlavor(), "", false, true, false) + ")";
        }
        if (!cIMQualifierType.getType().isArrayType()) {
            string3 = " = " + cIMQualifierType.getDefaultValue();
        }
        return new String("qualifier " + cIMQualifierType.getName() + " : " + cIMQualifierType.getType() + string3 + ", " + string + string2 + ";");
    }

    public String cimScope(CIMScope cIMScope) {
        switch (cIMScope.getScope()) {
            case 0: {
                return SCHEMA;
            }
            case 1: {
                return CLASS;
            }
            case 2: {
                return ASSOCIATION;
            }
            case 3: {
                return INDICATION;
            }
            case 4: {
                return PROPERTY;
            }
            case 5: {
                return REFERENCE;
            }
            case 6: {
                return METHOD;
            }
            case 7: {
                return PARAMETER;
            }
            case 8: {
                return ANY;
            }
        }
        return "UNKNOWN";
    }

    public String cimValue(CIMValue cIMValue) {
        String string = NULL;
        Object object = cIMValue.getValue();
        if (object != null) {
            if (cIMValue.isArrayValue()) {
                string = this.vectorToMOFString((Vector)object, "", false, true, false);
            } else {
                String string2 = "";
                if (new CIMDataType(8).equals(cIMValue.getType())) {
                    string2 = "\"";
                }
                string = String.valueOf(string2) + object.toString() + string2;
            }
        }
        return new String(string);
    }

    public String toString(Object object) {
        String string = "";
        if (object instanceof CIMInstance) {
            string = this.cimInstance((CIMInstance)object);
        } else if (object instanceof CIMClass) {
            string = this.cimClass((CIMClass)object);
        } else if (object instanceof CIMValue) {
            string = this.cimValue((CIMValue)object);
        } else if (object instanceof CIMQualifierType) {
            string = this.cimQualifierType((CIMQualifierType)object);
        } else if (object instanceof CIMQualifier) {
            string = this.cimQualifier((CIMQualifier)object);
        } else if (object instanceof CIMDateTime) {
            string = this.cimDateTime((CIMDateTime)object);
        } else if (object instanceof CIMProperty) {
            string = this.cimProperty((CIMProperty)object);
        } else if (object instanceof CIMScope) {
            string = this.cimScope((CIMScope)object);
        } else if (object instanceof CIMFlavor) {
            string = this.cimFlavor((CIMFlavor)object);
        } else if (object instanceof CIMDataType) {
            string = this.cimDataType((CIMDataType)object);
        } else if (object instanceof CIMMethod) {
            string = this.cimMethod((CIMMethod)object);
        } else if (object instanceof CIMParameter) {
            string = this.cimParameter((CIMParameter)object);
        }
        return string;
    }

    public String vectorToMOFString(Vector vector) {
        return this.vectorToMOFString(vector, "    ", false, false, true);
    }

    public String vectorToMOFString(Vector vector, String string) {
        return this.vectorToMOFString(vector, string, false, false, true);
    }

    public String vectorToMOFString(Vector vector, String string, boolean bl, boolean bl2, boolean bl3) {
        String string2 = "";
        string2 = bl3 ? ",\n" : ", ";
        String string3 = new String("");
        if (vector != null && !vector.isEmpty()) {
            if (bl) {
                string3 = String.valueOf(string) + "[";
            }
            int n = 0;
            while (n < vector.size()) {
                if (n > 0) {
                    string3 = bl2 ? string3.concat(String.valueOf(string2) + string + " ") : string3.concat("\n");
                }
                string3 = vector.elementAt(n) instanceof CIMElement ? string3.concat(this.toString(vector.elementAt(n))) : (vector.elementAt(n) instanceof CIMScope ? string3.concat(((CIMScope)vector.elementAt(n)).toString()) : (vector.elementAt(n) instanceof CIMFlavor ? string3.concat(((CIMFlavor)vector.elementAt(n)).toString()) : string3.concat("\"" + vector.elementAt(n).toString() + "\"")));
                ++n;
            }
            if (bl) {
                string3 = string3.concat("\n" + string + "]" + "\n");
            }
        }
        return string3;
    }

    public String vectorToMOFString(Vector vector, boolean bl) {
        return this.vectorToMOFString(vector, "    ", bl, false, true);
    }

    public String vectorToMOFString(Vector vector, boolean bl, boolean bl2) {
        return this.vectorToMOFString(vector, "    ", bl, bl2, true);
    }

    public String vectorToMOFString(Vector vector, boolean bl, boolean bl2, boolean bl3) {
        return this.vectorToMOFString(vector, "    ", bl, bl2, bl3);
    }

    public String wrapText(String string, int n) {
        String string2 = "\n";
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n", true);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.equals(string2)) {
                n2 = 0;
            } else if (n2 + string3.length() > n) {
                stringBuffer.append(string2);
                n2 = 0;
            }
            if (string3.equals(" ") && stringBuffer.toString().endsWith(string2)) continue;
            stringBuffer.append(string3);
            n2 += string3.length();
        }
        return stringBuffer.toString();
    }
}

