/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jserv;

import java.io.IOException;
import org.apache.java.io.LogWriter;
import org.apache.java.io.Logger;
import org.apache.java.util.Configurations;
import org.apache.jserv.JServConnection;
import org.apache.jserv.JServSendError;

final class JServLog
implements JServSendError,
Logger {
    private String errorMessage = null;
    private LogWriter logger = null;
    public boolean active = false;

    public JServLog(String string, Configurations configurations) {
        try {
            this.logger = new LogWriter(string, configurations);
            this.active = this.logger.active;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.errorMessage = iOException.getMessage();
        }
    }

    public void flush() {
        if (this.logger != null) {
            this.logger.flush();
        }
    }

    public String getSubsystemError() {
        return this.errorMessage;
    }

    public boolean isActive() {
        return this.logger != null ? this.logger.active : false;
    }

    public boolean isActive(String string) {
        return this.logger != null ? this.logger.isActive(string) : false;
    }

    public boolean isSane() {
        return this.logger != null;
    }

    public void log(String string, String string2) {
        if (this.logger != null) {
            this.logger.log(string, string2);
        }
    }

    public void log(String string, Throwable throwable) {
        if (this.logger != null) {
            this.logger.log(string, throwable);
        }
    }

    public void sendError(int n, String string) {
        this.log(null, String.valueOf(JServConnection.findStatusString(n)) + ": " + string);
    }

    public void sendError(Throwable throwable) {
        this.log(null, throwable);
    }
}

