/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.HotSync;

import com.sun.pdasync.Logger.Logger;
import com.sun.pdasync.SyncUtils.SyncConstants;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class DBListDef {
    public static final String DBLISTDEF_FILENAME = String.valueOf(SyncConstants.USER_PROPS_DIR_PATH) + SyncConstants.SEPARATOR + "DBList.def";
    public static final String DELIMITER = "|";
    public static final int FIELD_NUM = 2;
    protected Vector dblists = new Vector();

    public void addElement(String dbName, int creatorID) {
        DBItem item = new DBItem(dbName, creatorID);
        if (!this.hasItem(item)) {
            this.dblists.addElement(item);
        }
    }

    public int findCreatorID(String dbName) {
        int i = 0;
        while (i < this.dblists.size()) {
            DBItem item = (DBItem)this.dblists.elementAt(i);
            if (item.dbName.equals(dbName)) {
                return item.creatorID;
            }
            ++i;
        }
        return -1;
    }

    public String[] getDBNames() {
        String[] names = new String[this.dblists.size()];
        int i = 0;
        while (i < this.dblists.size()) {
            DBItem item = (DBItem)this.dblists.elementAt(i);
            names[i] = item.dbName;
            ++i;
        }
        return names;
    }

    private boolean hasItem(DBItem db) {
        int i = 0;
        while (i < this.dblists.size()) {
            DBItem item = (DBItem)this.dblists.elementAt(i);
            if (db.dbName.equals(item.dbName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void main(String[] args) {
        DBListDef dblist = new DBListDef();
        dblist.read();
        String[] names = dblist.getDBNames();
        System.out.println("Get DBName list");
        int i = 0;
        while (i < names.length) {
            System.out.println("dbname -- " + names[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < names.length) {
            int id = dblist.findCreatorID(names[i2]);
            System.out.println("name = " + names[i2] + ", id = " + id);
            ++i2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read() {
        BufferedReader buffer = null;
        File dblistFile = new File(DBLISTDEF_FILENAME);
        if (!dblistFile.exists()) {
            return -1;
        }
        int retcode = 0;
        try {
            try {
                String line;
                FileReader reader = new FileReader(dblistFile);
                buffer = new BufferedReader(reader);
                while ((line = buffer.readLine()) != null) {
                    if (line.charAt(0) == '#') continue;
                    DBItem dbItem = new DBItem();
                    if (dbItem.parseLine(line)) {
                        if (this.hasItem(dbItem)) continue;
                        this.dblists.addElement(dbItem);
                        continue;
                    }
                    retcode = -2;
                }
            }
            catch (Exception exception) {
                int n = -2;
                Object var9_8 = null;
                if (buffer == null) return n;
                try {
                    buffer.close();
                    return n;
                }
                catch (IOException iOException) {}
                return n;
            }
            Object var9_9 = null;
            if (buffer == null) return retcode;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (buffer == null) throw throwable;
            try {
                buffer.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            buffer.close();
            return retcode;
        }
        catch (IOException iOException) {}
        return retcode;
    }

    public void removeElement(String dbName, int creatorID) {
        int i = 0;
        while (i < this.dblists.size()) {
            DBItem item = (DBItem)this.dblists.elementAt(i);
            if (item.dbName.equals(dbName) && item.creatorID == creatorID) {
                this.dblists.removeElementAt(i);
                return;
            }
            ++i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void save() {
        BufferedWriter buffer = null;
        try {
            try {
                FileWriter writer = new FileWriter(DBLISTDEF_FILENAME);
                buffer = new BufferedWriter(writer);
                int i = 0;
                while (i < this.dblists.size()) {
                    DBItem dbItem = (DBItem)this.dblists.elementAt(i);
                    buffer.write(dbItem.encode());
                    buffer.newLine();
                    ++i;
                }
            }
            catch (IOException iOException) {
                Logger.doDebugLogging((String)"Cannot write DBList.def.", (int)4);
            }
            Object var4_5 = null;
            if (buffer == null) return;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            if (buffer == null) throw throwable;
            try {
                buffer.flush();
                buffer.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            buffer.flush();
            buffer.close();
            return;
        }
        catch (IOException iOException) {}
    }

    class DBItem {
        String dbName;
        int creatorID;

        public DBItem() {
            this.dbName = null;
            this.creatorID = -1;
        }

        public DBItem(String dbname, int creator_id) {
            this.dbName = dbname;
            this.creatorID = creator_id;
        }

        protected String encode() {
            return String.valueOf(this.dbName) + DBListDef.DELIMITER + this.creatorID;
        }

        protected boolean parseLine(String line) {
            StringTokenizer strTok = new StringTokenizer(line, DBListDef.DELIMITER);
            String[] tokens = new String[2];
            int counter = 0;
            while (strTok.hasMoreTokens()) {
                tokens[counter] = new String(strTok.nextToken());
                ++counter;
            }
            if (counter != 2) {
                return false;
            }
            this.dbName = tokens[0];
            try {
                this.creatorID = Integer.parseInt(tokens[1]);
            }
            catch (Exception exception) {
                return false;
            }
            return true;
        }
    }
}

