/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.core;

import com.sun.web.core.HttpServletResponseFacade;
import com.sun.web.core.Request;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpUtils;

public abstract class Response {
    protected Request request;
    protected HttpServletResponseFacade responseFacade;
    protected Vector cookies = new Vector();
    protected String contentType = "text/plain";
    protected String characterEncoding = "ISO-8859-1";
    protected int contentLength = -1;
    protected int status = 200;

    public Response() {
        this.responseFacade = new HttpServletResponseFacade(this);
    }

    public void addCookie(Cookie cookie) {
        this.cookies.addElement(cookie);
    }

    private void close() throws IOException {
        try {
            PrintWriter printWriter = this.getWriter();
            printWriter.close();
        }
        catch (IllegalStateException illegalStateException) {
            ServletOutputStream servletOutputStream = this.getOutputStream();
            servletOutputStream.close();
        }
    }

    public abstract boolean containsHeader(String var1);

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    HttpServletResponseFacade getFacade() {
        return this.responseFacade;
    }

    public abstract ServletOutputStream getOutputStream();

    public int getStatus() {
        return this.status;
    }

    public abstract PrintWriter getWriter();

    public abstract boolean isCommitted();

    public abstract boolean isStarted();

    private String makeAbsolute(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            String string2 = HttpUtils.getRequestURL(this.request.getFacade()).toString();
            try {
                uRL = new URL(new URL(string2), string);
            }
            catch (MalformedURLException malformedURLException2) {
                return string;
            }
        }
        return uRL.toString();
    }

    public void reset() {
        this.cookies.removeAllElements();
        this.contentType = "text/plain";
        this.characterEncoding = "ISO-8859-1";
        this.contentLength = -1;
        this.status = 200;
    }

    public void sendBodyText(String string) throws IOException {
        try {
            PrintWriter printWriter = this.getWriter();
            printWriter.print(string);
        }
        catch (IllegalStateException illegalStateException) {
            ServletOutputStream servletOutputStream = this.getOutputStream();
            servletOutputStream.print(string);
        }
    }

    public void sendError(int n) throws IOException {
        this.sendError(n, "No detailed message");
    }

    public void sendError(int n, String string) throws IOException {
        this.status = n;
        this.setContentType("text/html");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<h1>Error: " + n + "</h1>\r\n");
        stringBuffer.append(String.valueOf(string) + "\r\n");
        this.sendBodyText(stringBuffer.toString());
        this.close();
    }

    public void sendRedirect(String string) throws IOException {
        this.setStatus(302);
        this.setContentType("text/html");
        string = this.makeAbsolute(string);
        this.setHeader("Location", string);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<head><title>Document moved</title></head>\r\n");
        stringBuffer.append("<body><h1>Document moved</h1>\r\n");
        stringBuffer.append("This document has moved <a href=\"");
        stringBuffer.append(string);
        stringBuffer.append("\">here</a>.<p>\r\n");
        stringBuffer.append("</body>\r\n");
        String string2 = stringBuffer.toString();
        this.setContentLength(string2.length());
        this.sendBodyText(string2);
        this.close();
    }

    public void setContentLength(int n) {
        this.contentLength = n;
    }

    public void setContentType(String string) {
        this.contentType = string;
    }

    public abstract void setDateHeader(String var1, long var2);

    public abstract void setHeader(String var1, String var2);

    public abstract void setIntHeader(String var1, int var2);

    public void setRequest(Request request) {
        this.request = request;
    }

    public void setStatus(int n) {
        this.status = n;
    }
}

