/*
 * Decompiled with CFR 0.152.
 */
package javax.management.snmp;

import javax.management.snmp.SnmpOid;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpValue;

public class SnmpString
extends SnmpValue {
    static final String name = "String";
    protected byte[] value = null;

    public SnmpString() {
        this.value = new byte[0];
    }

    public SnmpString(String string) {
        this.value = string.getBytes();
    }

    public SnmpString(byte[] byArray) {
        this.value = (byte[])byArray.clone();
    }

    public SnmpString(Byte[] byteArray) {
        this.value = new byte[byteArray.length];
        int n = 0;
        while (n < byteArray.length) {
            this.value[n] = byteArray[n];
            ++n;
        }
    }

    public static String BinToChar(String string) {
        char[] cArray = new char[string.length() / 8];
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = (char)Integer.parseInt(string.substring(8 * n2, 8 * n2 + 8), 2);
            ++n2;
        }
        return new String(cArray);
    }

    public static String HexToChar(String string) {
        char[] cArray = new char[string.length() / 2];
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = (char)Integer.parseInt(string.substring(2 * n2, 2 * n2 + 2), 16);
            ++n2;
        }
        return new String(cArray);
    }

    public static void appendToOid(SnmpOid snmpOid, SnmpOid snmpOid2) {
        snmpOid2.append(snmpOid.getLength());
        snmpOid2.append(snmpOid);
    }

    public byte[] byteValue() {
        return this.value;
    }

    public synchronized Object clone() {
        SnmpString snmpString = null;
        try {
            snmpString = (SnmpString)super.clone();
            snmpString.value = new byte[this.value.length];
            System.arraycopy(this.value, 0, snmpString.value, 0, this.value.length);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        return snmpString;
    }

    public final synchronized SnmpValue duplicate() {
        return (SnmpValue)this.clone();
    }

    public String getTypeName() {
        return name;
    }

    public static int nextOid(long[] lArray, int n) throws SnmpStatusException {
        try {
            int n2;
            if (lArray[n] > Integer.MAX_VALUE) {
                throw new SnmpStatusException(2);
            }
            if ((n += (n2 = (int)lArray[n++])) <= lArray.length) {
                return n;
            }
            throw new SnmpStatusException(2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new SnmpStatusException(2);
        }
    }

    public Byte[] toByte() {
        Byte[] byteArray = new Byte[this.value.length];
        int n = 0;
        while (n < this.value.length) {
            byteArray[n] = new Byte(this.value[n]);
            ++n;
        }
        return byteArray;
    }

    public SnmpOid toOid() {
        long[] lArray = new long[this.value.length];
        int n = 0;
        while (n < this.value.length) {
            lArray[n] = this.value[n] & 0xFF;
            ++n;
        }
        return new SnmpOid(lArray);
    }

    public static SnmpOid toOid(long[] lArray, int n) throws SnmpStatusException {
        try {
            if (lArray[n] > Integer.MAX_VALUE) {
                throw new SnmpStatusException(2);
            }
            int n2 = (int)lArray[n++];
            long[] lArray2 = new long[n2];
            int n3 = 0;
            while (n3 < n2) {
                lArray2[n3] = lArray[n + n3];
                ++n3;
            }
            return new SnmpOid(lArray2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new SnmpStatusException(2);
        }
    }

    public String toString() {
        return new String(this.value);
    }
}

