/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.data;

import com.sun.dhcpmgr.data.DhcptabRecord;
import com.sun.dhcpmgr.data.OptionContext;
import com.sun.dhcpmgr.data.OptionType;
import com.sun.dhcpmgr.data.ValidationException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class Option
extends DhcptabRecord
implements Serializable,
Cloneable {
    private byte context;
    private short code;
    private byte type;
    private int granularity;
    private int maximum;
    private Vector vendors;
    private boolean valueClean = false;
    private boolean validValue = true;
    public static short MAX_NAME_SIZE = (short)128;
    public static byte STANDARD = 0;
    public static byte EXTEND = 1;
    public static byte VENDOR = (byte)2;
    public static byte SITE = (byte)3;
    public static byte CONTEXTS = (byte)4;
    public static OptionContext[] ctxts = new OptionContext[]{new OptionContext(STANDARD, "Standard", "standard_option"), new OptionContext(EXTEND, "Extend", "extended_option"), new OptionContext(VENDOR, "Vendor=", "vendor_option"), new OptionContext(SITE, "Site", "site_option")};
    public static byte ASCII = 0;
    public static byte OCTET = 1;
    public static byte IP = (byte)2;
    public static byte NUMBER = (byte)3;
    public static byte BOOLEAN = (byte)4;
    public static byte UNUMBER8 = (byte)5;
    public static byte UNUMBER16 = (byte)6;
    public static byte UNUMBER32 = (byte)7;
    public static byte UNUMBER64 = (byte)8;
    public static byte SNUMBER8 = (byte)9;
    public static byte SNUMBER16 = (byte)10;
    public static byte SNUMBER32 = (byte)11;
    public static byte SNUMBER64 = (byte)12;
    public static byte TYPES = (byte)13;
    public static OptionType[] types = new OptionType[]{new OptionType(0, "ASCII", "ascii_type"), new OptionType(1, "OCTET", "octet_type"), new OptionType(2, "IP", "ip_type"), new OptionType(3, "NUMBER", "number_type"), new OptionType(4, "BOOL", "boolean_type"), new OptionType(6, "UNUMBER8", "unumber8_type"), new OptionType(7, "UNUMBER16", "unumber16_type"), new OptionType(8, "UNUMBER32", "unumber32_type"), new OptionType(9, "UNUMBER64", "unumber64_type"), new OptionType(10, "SNUMBER8", "snumber8_type"), new OptionType(11, "SNUMBER16", "snumber16_type"), new OptionType(12, "SNUMBER32", "snumber32_type"), new OptionType(13, "SNUMBER64", "snumber64_type")};
    public static String DSYM_CLASS_DEL_SPACE = " ";
    public static String DSYM_CLASS_DEL = String.valueOf(DSYM_CLASS_DEL_SPACE) + "\t\n";
    public static String DSYM_CLASS_DEL_REGEXP = ".*[" + DSYM_CLASS_DEL + "].*";
    public static char DSYM_FIELD_DEL = (char)44;
    public static char DSYM_QUOTE = (char)34;

    public Option() {
        super("", "s", "");
        this.vendors = new Vector();
        this.context = ctxts[SITE].getCode();
        this.type = types[IP].getCode();
    }

    public Option(String string, byte by, String[] stringArray, short s, byte by2, int n, int n2, String string2, boolean bl) {
        super("", "s", "");
        this.validValue = bl;
        this.setKey(string);
        this.setContext(by);
        this.setVendors(stringArray);
        this.setCode(s);
        this.setType(by2);
        this.setGranularity(n);
        this.setMaximum(n2);
        if (string2 != null) {
            this.setSignature(string2);
        }
    }

    public void addVendor(String string) throws ValidationException {
        if (string.indexOf(DSYM_FIELD_DEL) != -1) {
            throw new ValidationException(string);
        }
        this.vendors.addElement(string);
        this.valueClean = false;
    }

    public void clearVendors() {
        this.vendors = new Vector();
        this.valueClean = false;
    }

    public Object clone() {
        Option option = new Option();
        option.setKey(this.getKey());
        option.setContext(this.getContext());
        option.setCode(this.getCode());
        option.vendors = new Vector();
        Enumeration enumeration = this.vendors.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            option.vendors.addElement(new String(string));
        }
        option.setType(this.getType());
        option.setGranularity(this.getGranularity());
        option.setMaximum(this.getMaximum());
        option.setSignature(this.getSignature());
        return option;
    }

    public static OptionContext findContext(byte by) {
        OptionContext optionContext = null;
        int n = 0;
        while (n < CONTEXTS) {
            if (ctxts[n].getCode() == by) {
                optionContext = ctxts[n];
                break;
            }
            ++n;
        }
        return optionContext;
    }

    public static OptionType findType(byte by) {
        OptionType optionType = null;
        int n = 0;
        while (n < TYPES) {
            if (types[n].getCode() == by) {
                optionType = types[n];
                break;
            }
            ++n;
        }
        return optionType;
    }

    public short getCode() {
        return this.code;
    }

    public byte getContext() {
        return this.context;
    }

    public static String getContextDhcptabString(byte by) {
        OptionContext optionContext = Option.findContext(by);
        if (optionContext == null) {
            return "undefined";
        }
        return optionContext.getDhcptabString();
    }

    public static String getContextString(byte by) {
        OptionContext optionContext = Option.findContext(by);
        if (optionContext == null) {
            return "undefined";
        }
        return optionContext.toString();
    }

    public int getGranularity() {
        return this.granularity;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public byte getType() {
        return this.type;
    }

    public static String getTypeDhcptabString(byte by) {
        OptionType optionType = Option.findType(by);
        if (optionType == null) {
            return "undefined";
        }
        return optionType.getDhcptabString();
    }

    public static String getTypeString(byte by) {
        OptionType optionType = Option.findType(by);
        if (optionType == null) {
            return "undefined";
        }
        return optionType.toString();
    }

    public String getValue() {
        if (!this.valueClean) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(Option.getContextDhcptabString(this.context));
            if (this.context == ctxts[VENDOR].getCode()) {
                boolean bl = true;
                Enumeration enumeration = this.getVendors();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    if (!bl) {
                        stringBuffer.append(DSYM_CLASS_DEL_SPACE);
                    } else {
                        bl = false;
                    }
                    boolean bl2 = false;
                    string = string.trim();
                    int n = 0;
                    while (n < string.length() - 1) {
                        if (DSYM_CLASS_DEL.indexOf(string.charAt(n)) != -1) {
                            bl2 = true;
                            break;
                        }
                        ++n;
                    }
                    if (bl2) {
                        stringBuffer.append(DSYM_QUOTE);
                    }
                    stringBuffer.append(string);
                    if (!bl2) continue;
                    stringBuffer.append(DSYM_QUOTE);
                }
            }
            stringBuffer.append(DSYM_FIELD_DEL);
            stringBuffer.append(this.code);
            stringBuffer.append(DSYM_FIELD_DEL);
            stringBuffer.append(Option.getTypeDhcptabString(this.type));
            stringBuffer.append(DSYM_FIELD_DEL);
            stringBuffer.append(this.granularity);
            stringBuffer.append(DSYM_FIELD_DEL);
            stringBuffer.append(this.maximum);
            try {
                super.setValue(stringBuffer.toString());
            }
            catch (ValidationException validationException) {}
            this.valueClean = true;
        }
        return super.getValue();
    }

    public String getVendorAt(int n) {
        return (String)this.vendors.elementAt(n);
    }

    public int getVendorCount() {
        return this.vendors.size();
    }

    public Enumeration getVendors() {
        return this.vendors.elements();
    }

    public boolean isValid() {
        return this.validValue;
    }

    public void removeVendorAt(int n) {
        this.vendors.removeElementAt(n);
        this.valueClean = false;
    }

    public void setCode(short s) {
        this.code = s;
        this.valueClean = false;
    }

    public void setContext(byte by) {
        this.context = by;
        this.valueClean = false;
    }

    public void setGranularity(int n) {
        this.granularity = n;
        this.valueClean = false;
    }

    public void setKey(String string) {
        try {
            super.setKey(string);
        }
        catch (ValidationException validationException) {}
    }

    public void setMaximum(int n) {
        this.maximum = n;
        this.valueClean = false;
    }

    public void setType(byte by) {
        this.type = by;
        this.valueClean = false;
    }

    public void setVendorAt(String string, int n) {
        if (n >= this.vendors.size()) {
            this.vendors.setSize(n + 1);
        }
        this.vendors.setElementAt(string, n);
        this.valueClean = false;
    }

    private void setVendors(String[] stringArray) {
        this.vendors = new Vector();
        if (stringArray == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            this.vendors.addElement(stringArray[n]);
            ++n;
        }
    }

    public String toString() {
        return String.valueOf(this.getKey()) + " s " + this.getValue();
    }
}

