/*
 * Decompiled with CFR 0.152.
 */
package com.sun.smartcard.scf;

import com.sun.smartcard.scf.CommException;
import com.sun.smartcard.scf.InternalException;
import com.sun.smartcard.scf.InternalTerminal;
import com.sun.smartcard.scf.InternalTerminalManager;
import com.sun.smartcard.scf.InvalidStateException;
import com.sun.smartcard.scf.Logger;
import com.sun.smartcard.scf.NoSuchTerminalException;
import com.sun.smartcard.scf.Terminal;
import java.util.HashMap;
import java.util.Iterator;

class TerminalManager {
    private final Logger logger = Logger.createLogger("TerminalManager");
    private boolean isActive = false;
    private InternalTerminalManager internalTerminalManager;
    private HashMap terminals;

    TerminalManager() {
    }

    void activate() {
        this.logger.log("activate", "");
        this.isActive = true;
    }

    synchronized void close() {
        this.logger.log("close", "");
        if (!this.isActive) {
            return;
        }
        this.isActive = false;
        Iterator iterator = this.terminals.values().iterator();
        while (iterator.hasNext()) {
            ((Terminal)iterator.next()).close();
        }
    }

    synchronized Terminal getTerminal(String string) throws InvalidStateException, CommException, InternalException, NoSuchTerminalException {
        this.logger.log("getTerminal", "terminalName=" + string);
        Terminal terminal = (Terminal)this.terminals.get(string);
        if (terminal != null) {
            this.logger.log("getTerminal", "Terminal found: " + string);
            return terminal;
        }
        InternalTerminal internalTerminal = this.internalTerminalManager.getInternalTerminal(string);
        terminal = new Terminal();
        terminal.init(internalTerminal, this);
        terminal.activate();
        this.terminals.put(string, terminal);
        return terminal;
    }

    void init(InternalTerminalManager internalTerminalManager) {
        this.logger.log("init", "");
        this.internalTerminalManager = internalTerminalManager;
        this.terminals = new HashMap();
    }

    synchronized void terminalClosed(String string) {
        this.logger.log("terminalClosed", "");
        if (this.isActive) {
            this.terminals.remove(string);
        }
    }
}

