/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.Conduits.CalendarSync;

import com.sun.pdasync.Conduits.CalendarSync.CalendarSyncConstants;
import com.sun.pdasync.Conduits.CalendarSync.CalendarSyncException;
import com.sun.pdasync.Conduits.CalendarSync.CalendarSyncProperties;
import com.sun.pdasync.Conduits.CalendarSync.CalendarSyncPropsUI;
import com.sun.pdasync.Conduits.CalendarSync.CalendarSyncRecMgr;
import com.sun.pdasync.Conduits.CalendarSync.CalendarSyncUtils;
import com.sun.pdasync.Conduits.CalendarSync.CalendarSyncWriter;
import com.sun.pdasync.SyncUtils.SyncConstants;
import com.sun.pdasync.SyncUtils.SyncUtils;
import java.awt.Dialog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import palm.conduit.Conduit;
import palm.conduit.ConfigureConduitInfo;
import palm.conduit.SyncException;
import palm.conduit.SyncManager;
import palm.conduit.SyncProperties;

public class CalendarSyncConduit
implements Conduit,
Serializable {
    private static Locale theLocale;
    private static ResourceBundle calendarRes;
    Class recordClass;
    CalendarSyncWriter dtWriter;
    CalendarSyncRecMgr calRecMgr;
    String dtCalFilePath;
    String calDataFilePath;
    Vector dtRecords;
    Vector buRecords = null;
    Vector archiveRecords;
    Vector cbkRecords;
    int db = -1;
    FileOutputStream out;
    private CalendarSyncPropsUI calendarPropsUI;
    private CalendarSyncProperties calSyncProps = new CalendarSyncProperties();
    SyncProperties syncProps = null;

    static {
        try {
            theLocale = Locale.getDefault();
            calendarRes = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.CalendarSyncConduitMessages", theLocale);
        }
        catch (MissingResourceException e) {
            System.err.println("PDASync: can't find properties");
            System.err.println("PDASync:" + e.getMessage());
            System.exit(1);
        }
    }

    public int configure(ConfigureConduitInfo info) {
        if (this.calendarPropsUI == null) {
            this.calendarPropsUI = new CalendarSyncPropsUI(SyncUtils.getParentOfAllConduits(), this.calSyncProps);
        }
        ((Dialog)((Object)this.calendarPropsUI)).show();
        info.syncPermanent = this.calSyncProps.syncBehavior.equals("desktop") ? 3 : (this.calSyncProps.syncBehavior.equals("pda") ? 2 : 0);
        info.syncTemporary = info.syncPermanent;
        return 0;
    }

    private void delHHCalPopup() {
        Object[] objs = new Object[20];
        JFrame p = SyncUtils.getParentOfAllConduits();
        objs[0] = calendarRes.getString("PDASync has determined that you have been sync'ing");
        objs[1] = calendarRes.getString("your handheld using a shareware package called PilotManager");
        objs[2] = new String("\n");
        objs[3] = calendarRes.getString("PilotManager has stored your calendar data on the PalmPilot");
        objs[4] = calendarRes.getString("in a way that is not compatible with PDASync");
        objs[5] = new String("\n");
        objs[6] = calendarRes.getString("If you wish to know the specifics you may");
        objs[7] = calendarRes.getString("consult a text file in");
        objs[8] = new String("/usr/dt/appconfig/sdtpdasync/lib/pilot-mgrFAQ.txt");
        objs[9] = new String("\n");
        objs[10] = calendarRes.getString("PDASync will not proceed with sync'ing your");
        objs[11] = calendarRes.getString("calendar unless you run the script");
        objs[12] = new String("/usr/dt/appconfig/sdtpdasync/lib/deleteHHcalendar.");
        objs[13] = new String("\n");
        objs[14] = calendarRes.getString("The script will explain what it is doing and");
        objs[15] = calendarRes.getString("the actions you must take.");
        objs[16] = new String("\n");
        objs[17] = calendarRes.getString("This notice will show up again until you have");
        objs[18] = calendarRes.getString("taken the action described above.");
        objs[19] = new String("\n");
        JOptionPane.showMessageDialog(p, objs, calendarRes.getString("PDA Synchronization Info"), 1, null);
    }

    public String name() {
        try {
            return calendarRes.getString("Calendar");
        }
        catch (MissingResourceException missingResourceException) {
            return "Calendar";
        }
    }

    public void open(SyncProperties props) {
        Date lookupRangeStartDate = null;
        Date lookupRangeEndDate = null;
        boolean restore = false;
        this.syncProps = props;
        CalendarSyncUtils.doDebug("syncProps.syncType is " + this.syncProps.syncType);
        if (this.syncProps.syncType == 6 || this.syncProps.syncType == 5 || this.syncProps.syncType == 7 || this.syncProps.syncType < 0 || this.syncProps.syncType > 7) {
            CalendarSyncUtils.doLog(calendarRes.getString("Unknown syncType. No sync action taken."));
            return;
        }
        this.calDataFilePath = new String(CalendarSyncConstants.CALENDAR_DIR_PATH);
        File convertFile = new File(String.valueOf(this.calDataFilePath) + SyncConstants.SEPARATOR + ".convert");
        File pilotMgrFile = new File(String.valueOf(CalendarSyncConstants.PILOTMGR_DIR_PATH) + SyncConstants.SEPARATOR + "pilot-cm.db");
        File cbkFile = new File(CalendarSyncConstants.CBKFNAME);
        File tmpFile = new File(CalendarSyncConstants.CBKTMPFNAME);
        try {
            this.dtWriter = new CalendarSyncWriter(this.calSyncProps);
            CalendarSyncUtils.doTimeLog("*** " + calendarRes.getString("Start sync'ing calendar ") + CalendarSyncWriter.calName + "@" + CalendarSyncWriter.hostName + " ***");
            File dataFile = null;
            dataFile = new File(String.valueOf(this.calDataFilePath) + SyncConstants.SEPARATOR + "calendar.pdb");
            if (dataFile.exists()) {
                if (!cbkFile.exists()) {
                    dataFile.renameTo(cbkFile);
                } else {
                    dataFile.delete();
                }
            }
            if ((dataFile = new File(String.valueOf(this.calDataFilePath) + SyncConstants.SEPARATOR + "backup")).exists()) {
                dataFile.delete();
            }
            if (this.dtWriter.calDataVersion < 4) {
                CalendarSyncException cse = new CalendarSyncException(4117);
                throw cse;
            }
            this.dtRecords = new Vector();
            this.archiveRecords = new Vector();
            this.cbkRecords = new Vector();
            this.recordClass = Class.forName("com.sun.pdasync.Conduits.CalendarSync.CalendarSyncRecord");
            try {
                this.db = SyncManager.openDB((String)this.syncProps.remoteNames[0], (int)0, (int)224);
            }
            catch (SyncException e) {
                if (e.errorCode == 16387) {
                    this.db = SyncManager.createDB((int)this.syncProps.creator, (int)0, (int)this.syncProps.cardNo, (String)this.syncProps.remoteNames[0], (int)this.syncProps.dbType);
                }
                throw e;
            }
            this.calRecMgr = new CalendarSyncRecMgr(this.syncProps, this.db, this.recordClass, this.dtWriter);
            if (this.syncProps.syncType == 3) {
                if (this.calSyncProps.syncBehavior.equals("desktop")) {
                    this.syncProps.syncType = 3;
                } else {
                    this.cbkRecords = this.dtWriter.readCbkFromDt(this.calDataFilePath, this.cbkRecords);
                    if (this.cbkRecords == null) {
                        this.syncProps.syncType = 3;
                    } else {
                        restore = true;
                        SyncManager.purgeAllRecs((int)this.db);
                        try {
                            SyncUtils.touchFile((String)this.calDataFilePath, (String)".convert");
                        }
                        catch (IOException iOException) {}
                        this.dtRecords = this.calRecMgr.copyPCRecords(this.cbkRecords);
                        CalendarSyncUtils.doLog(calendarRes.getString("PalmPilot Datebook database restored"));
                    }
                }
            }
            if (!restore) {
                this.dtWriter.removeBackupFiles("backup." + CalendarSyncWriter.calName + "." + CalendarSyncWriter.hostName + "." + this.dtWriter.calServerVersion);
                if (!convertFile.exists() && pilotMgrFile.exists()) {
                    int recCount = SyncManager.getDBRecordCount((int)this.db);
                    if (recCount != 0) {
                        this.delHHCalPopup();
                        CalendarSyncUtils.doLog(calendarRes.getString("No data is sync'd.  Please run "));
                        CalendarSyncUtils.doLog("/usr/dt/appconfig/sdtpdasync/lib/deleteHHcalendar");
                        SyncManager.closeDB((int)this.db);
                        this.db = -1;
                        CalendarSyncUtils.doTimeLog("*** " + calendarRes.getString("Sync finished") + " ***");
                        return;
                    }
                    try {
                        SyncUtils.touchFile((String)this.calDataFilePath, (String)".convert");
                    }
                    catch (IOException iOException) {}
                }
                Calendar cal = Calendar.getInstance();
                int monthRange = this.calSyncProps.windowSize;
                cal.add(2, -monthRange);
                lookupRangeStartDate = cal.getTime();
                CalendarSyncUtils.doDebug("lookupRangeStartDate is " + lookupRangeStartDate);
                cal.add(2, 2 * monthRange);
                lookupRangeEndDate = cal.getTime();
                CalendarSyncUtils.doDebug("lookupRangeEndDate is " + lookupRangeEndDate);
                this.dtRecords = this.dtWriter.readRecordsFromDt(lookupRangeStartDate, lookupRangeEndDate);
                if (this.syncProps.syncType == 0 || this.syncProps.syncType == 1) {
                    this.buRecords = this.dtWriter.readBackupFromDt(this.calDataFilePath);
                }
                if (this.dtRecords.size() == 0) {
                    CalendarSyncUtils.doLog(calendarRes.getString("No desktop data available, copying records to desktop"));
                    this.syncProps.syncType = 2;
                }
                if (this.syncProps.syncType == 0 && this.buRecords.size() == 0) {
                    this.syncProps.syncType = 1;
                }
                switch (this.syncProps.syncType) {
                    case 0: {
                        this.cbkRecords = this.dtWriter.readCbkFromDt(this.calDataFilePath, this.cbkRecords);
                        if (this.cbkRecords == null) {
                            this.cbkRecords = new Vector();
                        }
                        this.cbkRecords = this.calRecMgr.fastSyncData(this.dtRecords, this.archiveRecords, this.buRecords, this.cbkRecords, lookupRangeStartDate, lookupRangeEndDate);
                        CalendarSyncUtils.doLog(calendarRes.getString("FastSync Performed"));
                        break;
                    }
                    case 1: {
                        this.dtRecords = this.calRecMgr.slowSyncData(this.dtRecords, this.archiveRecords, this.buRecords, this.cbkRecords, lookupRangeStartDate, lookupRangeEndDate);
                        CalendarSyncUtils.doLog(calendarRes.getString("SlowSync Performed"));
                        break;
                    }
                    case 2: {
                        this.dtRecords = this.calRecMgr.copyHHRecords();
                        this.dtWriter.writeCbkToDt(this.calDataFilePath, "data.tmp", this.dtRecords);
                        this.calRecMgr.copyRecsInRange(this.dtRecords, lookupRangeStartDate, lookupRangeEndDate);
                        this.dtWriter.writeRecordsToDt(this.dtRecords);
                        CalendarSyncUtils.doLog(calendarRes.getString("Handheld records copied to Desktop"));
                        break;
                    }
                    case 3: {
                        if (this.cbkRecords == null) {
                            this.cbkRecords = new Vector();
                        }
                        this.dtRecords = this.calRecMgr.copyRangePCRecords(this.dtRecords, this.cbkRecords, lookupRangeStartDate, lookupRangeEndDate);
                        CalendarSyncUtils.doLog(calendarRes.getString("Desktop records copied to Handheld"));
                        break;
                    }
                }
                this.dtWriter.writeBackupToDt(this.calDataFilePath, this.dtRecords, this.buRecords, this.calRecMgr.saveDeletedRecs);
                if (this.syncProps.syncType != 2) {
                    this.dtWriter.writeCbkToDt(this.calDataFilePath, "data.cbk", this.cbkRecords);
                } else if (tmpFile.exists()) {
                    try {
                        tmpFile.renameTo(cbkFile);
                    }
                    catch (SecurityException securityException) {
                        CalendarSyncException cse = new CalendarSyncException(4116);
                        throw cse;
                    }
                }
            } else {
                this.dtWriter.removeBackupFiles(null);
            }
            SyncManager.closeDB((int)this.db);
            this.db = -1;
            CalendarSyncUtils.doTimeLog("*** " + calendarRes.getString("Sync finished") + " ***");
            return;
        }
        catch (CalendarSyncException t) {
            if (t.errorCode == 4100 || t.errorCode == 4101 || t.errorCode == 4117) {
                CalendarSyncUtils.doLog(t.getMessage());
            } else {
                CalendarSyncUtils.doLog(t.getMessage());
            }
        }
        catch (SyncException t) {
            CalendarSyncUtils.doLog(t.getMessage());
            t.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (tmpFile.exists()) {
            tmpFile.delete();
        }
        if (this.db != -1) {
            try {
                SyncManager.closeDB((int)this.db);
                this.db = -1;
            }
            catch (SyncException t) {
                CalendarSyncUtils.doLog(t.getMessage());
                t.printStackTrace();
            }
        }
        CalendarSyncUtils.doTimeLog("*** " + calendarRes.getString("Sync aborted") + " ***");
    }
}

