/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.usermgr.profs;

import com.sun.wbem.solarisprovider.usermgr.common.KeyValue;
import com.sun.wbem.solarisprovider.usermgr.common.SolServerException;
import com.sun.wbem.solarisprovider.usermgr.profs.ProfAttrObj;
import com.sun.wbem.solarisprovider.usermgr.profs.ProfAttrTable;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableDoesNotExistException;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableFactory;
import com.sun.wbem.utility.directorytable.SearchTemplate;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import java.util.Vector;

public class SolarisProfAttrTable
implements ProfAttrTable {
    private static final String table = new String("prof_attr");
    private static final String emptyString = new String("");
    private static final String nameCol = "name";
    private static final String res1Col = "res1";
    private static final String res2Col = "res2";
    private static final String descCol = "long_descr";
    private static final String attrCol = "attr";
    private String scope;
    static /* synthetic */ Class array$Ljava$lang$String;

    public SolarisProfAttrTable(String string) {
        this.scope = string;
        Class[] classArray = new Class[]{};
        Class[] classArray2 = new Class[]{array$Ljava$lang$String != null ? array$Ljava$lang$String : (array$Ljava$lang$String = SolarisProfAttrTable.class$("[Ljava.lang.String;"))};
        ProfAttrObj profAttrObj = new ProfAttrObj();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void createProfAttrTable() throws DirectoryTableException {
        DirectoryTable directoryTable = null;
        boolean bl = true;
        try {
            directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
            directoryTable.open(table);
        }
        catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            bl = false;
        }
        catch (DirectoryTableException directoryTableException) {
            directoryTable.close();
            throw directoryTableException;
        }
        TableDefinitions tableDefinitions = null;
        try {
            if (!bl) {
                tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions(table);
                directoryTable.create(table);
            }
            Object var5_7 = null;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            directoryTable.close();
            throw throwable;
        }
        directoryTable.close();
    }

    public String[] getProfilesList() throws DirectoryTableException {
        Vector<String> vector = new Vector<String>();
        DirectoryTable directoryTable = this.openProfAttrTable();
        TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
        DirectoryRow directoryRow = directoryTable.getAll();
        if (directoryRow == null) {
            throw new DirectoryTableException("EXM_TABLE_EMPTY", (Object)table);
        }
        int n = 1;
        while (n <= directoryRow.getNumberOfRows()) {
            String string = directoryRow.getColumn(tableDefinitions.getColumnNumber(nameCol), n);
            vector.addElement(string);
            ++n;
        }
        directoryTable.close();
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Vector listProfAttributes() throws DirectoryTableException {
        Vector<ProfAttrObj> vector = new Vector<ProfAttrObj>();
        DirectoryTable directoryTable = this.openProfAttrTable();
        try {
            TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
            DirectoryRow directoryRow = directoryTable.getAll();
            if (directoryRow == null) {
                throw new DirectoryTableException("EXM_TABLE_EMPTY", (Object)table);
            }
            int n = 1;
            while (n <= directoryRow.getNumberOfRows()) {
                ProfAttrObj profAttrObj = new ProfAttrObj();
                profAttrObj.setProfName(directoryRow.getColumn(tableDefinitions.getColumnNumber(nameCol), n));
                profAttrObj.setLongDesc(directoryRow.getColumn(tableDefinitions.getColumnNumber(descCol), n));
                String string = directoryRow.getColumn(tableDefinitions.getColumnNumber(attrCol), n);
                KeyValue.getAttributes(string, profAttrObj.attrSet);
                vector.addElement(profAttrObj);
                ++n;
            }
        }
        finally {
            Object var5_8 = null;
            directoryTable.close();
        }
        return vector;
    }

    private DirectoryTable openProfAttrTable() throws DirectoryTableException {
        DirectoryTableFactory directoryTableFactory = new DirectoryTableFactory();
        DirectoryTable directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
        try {
            directoryTable.open(table);
        }
        catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            throw new DirectoryTableException("EXM_TABLE_EMPTY", (Object)table);
        }
        return directoryTable;
    }

    public ProfAttrObj readProfAttr(String string) throws DirectoryTableException {
        DirectoryTable directoryTable;
        ProfAttrObj profAttrObj;
        block2: {
            profAttrObj = null;
            directoryTable = this.openProfAttrTable();
            try {
                TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(nameCol), string);
                directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                if (directoryRow == null) break block2;
                profAttrObj = new ProfAttrObj(string);
                profAttrObj.setLongDesc(directoryRow.getColumn(tableDefinitions.getColumnNumber(descCol)));
                String string2 = directoryRow.getColumn(tableDefinitions.getColumnNumber(attrCol));
                KeyValue.getAttributes(string2, profAttrObj.attrSet);
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                directoryTable.close();
                throw throwable;
            }
        }
        Object var5_7 = null;
        directoryTable.close();
        return profAttrObj;
    }

    public void removeProfAttr(ProfAttrObj profAttrObj) throws DirectoryTableException, SolServerException {
        String string = profAttrObj.getProfName();
        this.removeProfAttr(string);
    }

    public void removeProfAttr(String string) throws DirectoryTableException, SolServerException {
        DirectoryTable directoryTable = this.openProfAttrTable();
        try {
            TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
            DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
            directoryRow.putColumn(tableDefinitions.getColumnNumber(nameCol), string);
            directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
            if (directoryRow == null) {
                throw new SolServerException("EXM_SUS78", string);
            }
            directoryTable.deleteRow(directoryRow);
        }
        finally {
            Object var4_5 = null;
            directoryTable.close();
        }
    }

    public void writeProfAttr(ProfAttrObj profAttrObj) throws DirectoryTableException {
        DirectoryTable directoryTable;
        block3: {
            directoryTable = this.openProfAttrTable();
            try {
                TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(nameCol), profAttrObj.getProfName());
                DirectoryRow directoryRow2 = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                String string = directoryRow2 != null ? directoryRow2.getColumn(tableDefinitions.getColumnNumber(attrCol)) : null;
                String string2 = KeyValue.putAttributes(string, profAttrObj.attrSet, false);
                directoryRow.putColumn(tableDefinitions.getColumnNumber(descCol), profAttrObj.getLongDesc());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(attrCol), string2);
                if (directoryRow2 == null) {
                    directoryTable.addRow(directoryRow);
                    break block3;
                }
                directoryTable.modifyRow(directoryRow2, directoryRow);
            }
            catch (Throwable throwable) {
                Object var4_9 = null;
                directoryTable.close();
                throw throwable;
            }
        }
        Object var4_8 = null;
        directoryTable.close();
    }
}

