/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.usermgr.execs;

import com.sun.wbem.solarisprovider.usermgr.common.KeyValue;
import com.sun.wbem.solarisprovider.usermgr.common.SolServerException;
import com.sun.wbem.solarisprovider.usermgr.execs.ExecAttrObj;
import com.sun.wbem.solarisprovider.usermgr.execs.ExecAttrTable;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableDoesNotExistException;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableFactory;
import com.sun.wbem.utility.directorytable.SearchTemplate;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;

public class SolarisExecAttrTable
implements ExecAttrTable {
    private static final String table = new String("exec_attr");
    private static final String emptyString = new String("");
    private static final String nameCol = "name";
    private static final String policyCol = "policy";
    private static final String typeCol = "type";
    private static final String res1Col = "res1";
    private static final String res2Col = "res2";
    private static final String idCol = "id";
    private static final String attrCol = "attr";
    private String scope;

    public SolarisExecAttrTable(String string) {
        this.scope = string;
        ExecAttrObj execAttrObj = new ExecAttrObj();
    }

    public void createExecAttrTable() throws DirectoryTableException {
        DirectoryTable directoryTable = null;
        boolean bl = true;
        try {
            directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
            directoryTable.open(table);
        }
        catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            bl = false;
        }
        catch (DirectoryTableException directoryTableException) {
            directoryTable.close();
            throw directoryTableException;
        }
        TableDefinitions tableDefinitions = null;
        try {
            if (!bl) {
                tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions(table);
                directoryTable.create(table);
            }
            Object var5_7 = null;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            directoryTable.close();
            throw throwable;
        }
        directoryTable.close();
    }

    public String getPolicy() throws DirectoryTableException {
        return "suser";
    }

    public String[] getProfCommand(String string) throws DirectoryTableException {
        String[] stringArray;
        DirectoryTable directoryTable;
        ExecAttrObj execAttrObj;
        block3: {
            execAttrObj = null;
            directoryTable = this.openExecAttrTable();
            try {
                TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                stringArray = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                stringArray.putColumn(tableDefinitions.getColumnNumber(nameCol), string);
                stringArray = directoryTable.getFirstRow((SearchTemplate)stringArray);
                if (stringArray == null) break block3;
                execAttrObj = new ExecAttrObj(string);
                execAttrObj.setId(stringArray.getColumn(tableDefinitions.getColumnNumber(idCol)));
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                directoryTable.close();
                throw throwable;
            }
        }
        StringTokenizer stringTokenizer = null;
        directoryTable.close();
        String string2 = execAttrObj.getId();
        stringTokenizer = new StringTokenizer(string2, ",");
        int n = stringTokenizer.countTokens();
        stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        return stringArray;
    }

    public ExecAttrObj[] listExecAttributes() throws DirectoryTableException {
        Vector<ExecAttrObj> vector = new Vector<ExecAttrObj>();
        DirectoryTable directoryTable = this.openExecAttrTable();
        try {
            TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
            DirectoryRow directoryRow = directoryTable.getAll();
            if (directoryRow == null) {
                throw new DirectoryTableException("EXM_TABLE_EMPTY", (Object)table);
            }
            int n = 1;
            while (n <= directoryRow.getNumberOfRows()) {
                ExecAttrObj execAttrObj = new ExecAttrObj();
                execAttrObj.setProfName(directoryRow.getColumn(tableDefinitions.getColumnNumber(nameCol), n));
                execAttrObj.setPolicy(directoryRow.getColumn(tableDefinitions.getColumnNumber(policyCol), n));
                execAttrObj.setType(directoryRow.getColumn(tableDefinitions.getColumnNumber(typeCol), n));
                execAttrObj.setId(directoryRow.getColumn(tableDefinitions.getColumnNumber(idCol), n));
                String string = directoryRow.getColumn(tableDefinitions.getColumnNumber(attrCol), n);
                KeyValue.getAttributes(string, execAttrObj.attrSet);
                vector.addElement(execAttrObj);
                ++n;
            }
        }
        finally {
            Object var5_8 = null;
            directoryTable.close();
        }
        Object[] objectArray = new ExecAttrObj[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private DirectoryTable openExecAttrTable() throws DirectoryTableException {
        DirectoryTableFactory directoryTableFactory = new DirectoryTableFactory();
        DirectoryTable directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
        try {
            directoryTable.open(table);
        }
        catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            throw new DirectoryTableException("EXM_TABLE_EMPTY", (Object)table);
        }
        return directoryTable;
    }

    public ArrayList readExecAttr(String string, String string2, String string3) throws DirectoryTableException {
        ArrayList<ExecAttrObj> arrayList = new ArrayList<ExecAttrObj>();
        ExecAttrObj execAttrObj = null;
        DirectoryTable directoryTable = this.openExecAttrTable();
        try {
            TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
            DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
            DirectoryRow directoryRow2 = new DirectoryRow(tableDefinitions.getNumberOfColumns());
            directoryRow.putColumn(tableDefinitions.getColumnNumber(nameCol), string);
            directoryRow.putColumn(tableDefinitions.getColumnNumber(idCol), string3);
            directoryRow2 = directoryTable.getFirstRow((SearchTemplate)directoryRow);
            while (directoryRow2 != null) {
                execAttrObj = new ExecAttrObj(string);
                execAttrObj.setPolicy(directoryRow2.getColumn(tableDefinitions.getColumnNumber(policyCol)));
                execAttrObj.setType(directoryRow2.getColumn(tableDefinitions.getColumnNumber(typeCol)));
                execAttrObj.setId(directoryRow2.getColumn(tableDefinitions.getColumnNumber(idCol)));
                String string4 = directoryRow2.getColumn(tableDefinitions.getColumnNumber(attrCol));
                KeyValue.getAttributes(string4, execAttrObj.attrSet);
                arrayList.add(execAttrObj);
                directoryRow2 = directoryTable.getNextRow((SearchTemplate)directoryRow);
            }
        }
        finally {
            Object var8_11 = null;
            directoryTable.close();
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ExecAttrObj readExecAttr(String string, String string2, String string3, String string4) throws DirectoryTableException {
        DirectoryTable directoryTable;
        block5: {
            ExecAttrObj execAttrObj;
            block4: {
                ExecAttrObj execAttrObj2 = null;
                directoryTable = this.openExecAttrTable();
                try {
                    TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                    DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                    DirectoryRow directoryRow2 = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                    directoryRow.putColumn(tableDefinitions.getColumnNumber(nameCol), string);
                    directoryRow.putColumn(tableDefinitions.getColumnNumber(idCol), string3);
                    directoryRow2 = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                    while (directoryRow2 != null) {
                        execAttrObj2 = new ExecAttrObj(string);
                        String string5 = directoryRow2.getColumn(tableDefinitions.getColumnNumber(policyCol));
                        String string6 = directoryRow2.getColumn(tableDefinitions.getColumnNumber(typeCol));
                        if (string5.equalsIgnoreCase(string4) && string6.equalsIgnoreCase(string2)) {
                            execAttrObj2.setPolicy(string4);
                            execAttrObj2.setType(string2);
                            execAttrObj2.setId(directoryRow2.getColumn(tableDefinitions.getColumnNumber(idCol)));
                            String string7 = directoryRow2.getColumn(tableDefinitions.getColumnNumber(attrCol));
                            KeyValue.getAttributes(string7, execAttrObj2.attrSet);
                            execAttrObj = execAttrObj2;
                            Object var9_14 = null;
                            break block4;
                        }
                        directoryRow2 = directoryTable.getNextRow((SearchTemplate)directoryRow);
                    }
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var9_16 = null;
                    directoryTable.close();
                    throw throwable;
                }
            }
            directoryTable.close();
            return execAttrObj;
        }
        Object var9_15 = null;
        directoryTable.close();
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ExecAttrObj[] readExecAttrs(String string, String string2, String string3) throws DirectoryTableException {
        ExecAttrObj execAttrObj = null;
        DirectoryTable directoryTable = this.openExecAttrTable();
        Vector<ExecAttrObj> vector = new Vector<ExecAttrObj>();
        try {
            TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
            DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
            DirectoryRow directoryRow2 = new DirectoryRow(tableDefinitions.getNumberOfColumns());
            directoryRow.putColumn(tableDefinitions.getColumnNumber(nameCol), string);
            directoryRow2 = directoryTable.getFirstRow((SearchTemplate)directoryRow);
            while (directoryRow2 != null) {
                block11: {
                    String string4;
                    block10: {
                        execAttrObj = new ExecAttrObj(string);
                        String string5 = directoryRow2.getColumn(tableDefinitions.getColumnNumber(policyCol));
                        string4 = directoryRow2.getColumn(tableDefinitions.getColumnNumber(typeCol));
                        if (string3 != null) {
                            if (string5.equalsIgnoreCase(string3)) {
                                execAttrObj.setPolicy(string3);
                                break block10;
                            } else {
                                directoryRow2 = directoryTable.getNextRow((SearchTemplate)directoryRow);
                                continue;
                            }
                        }
                        execAttrObj.setPolicy(string5);
                    }
                    if (string2 != null) {
                        if (string4.equalsIgnoreCase(string2)) {
                            execAttrObj.setType(string2);
                            break block11;
                        } else {
                            directoryRow2 = directoryTable.getNextRow((SearchTemplate)directoryRow);
                            continue;
                        }
                    }
                    execAttrObj.setType(string4);
                }
                execAttrObj.setId(directoryRow2.getColumn(tableDefinitions.getColumnNumber(idCol)));
                String string6 = directoryRow2.getColumn(tableDefinitions.getColumnNumber(attrCol));
                KeyValue.getAttributes(string6, execAttrObj.attrSet);
                vector.addElement(execAttrObj);
                directoryRow2 = directoryTable.getNextRow((SearchTemplate)directoryRow);
            }
        }
        finally {
            Object var8_13 = null;
            directoryTable.close();
        }
        ExecAttrObj[] execAttrObjArray = new ExecAttrObj[vector.size()];
        return vector.toArray(execAttrObjArray);
    }

    public void removeExecAttr(ExecAttrObj execAttrObj) throws DirectoryTableException, SolServerException {
        DirectoryTable directoryTable;
        block3: {
            directoryTable = this.openExecAttrTable();
            String string = execAttrObj.getProfName();
            String string2 = execAttrObj.getType();
            String string3 = execAttrObj.getId();
            String string4 = execAttrObj.getPolicy();
            try {
                TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(nameCol), string);
                directoryRow.putColumn(tableDefinitions.getColumnNumber(idCol), string3);
                directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                if (directoryRow == null) {
                    throw new SolServerException("EXM_SUS77", (Object)string, (Object)string2, string3);
                }
                String string5 = directoryRow.getColumn(tableDefinitions.getColumnNumber(policyCol));
                String string6 = directoryRow.getColumn(tableDefinitions.getColumnNumber(typeCol));
                if (!string5.equalsIgnoreCase(string4) || !string6.equalsIgnoreCase(string2)) break block3;
                directoryTable.deleteRow(directoryRow);
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                directoryTable.close();
                throw throwable;
            }
        }
        Object var8_11 = null;
        directoryTable.close();
    }

    public void removeExecAttr(String string) throws DirectoryTableException {
        DirectoryTable directoryTable = this.openExecAttrTable();
        try {
            TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
            DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
            directoryRow.putColumn(tableDefinitions.getColumnNumber(nameCol), string);
            directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
            while (directoryRow != null) {
                directoryTable.deleteRow(directoryRow);
                directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(nameCol), string);
                directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
            }
        }
        finally {
            Object var4_5 = null;
            directoryTable.close();
        }
    }

    public void writeExecAttr(ExecAttrObj execAttrObj) throws DirectoryTableException {
        DirectoryTable directoryTable;
        block4: {
            directoryTable = this.openExecAttrTable();
            try {
                String string;
                String string2;
                TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(nameCol), execAttrObj.getProfName());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(idCol), execAttrObj.getId());
                DirectoryRow directoryRow2 = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                while (directoryRow2 != null) {
                    string2 = directoryRow2.getColumn(tableDefinitions.getColumnNumber(policyCol));
                    string = directoryRow2.getColumn(tableDefinitions.getColumnNumber(typeCol));
                    if (string2.equalsIgnoreCase(execAttrObj.getPolicy()) && string.equalsIgnoreCase(execAttrObj.getType())) break;
                    directoryRow2 = directoryTable.getNextRow((SearchTemplate)directoryRow);
                }
                string2 = directoryRow2 != null ? directoryRow2.getColumn(tableDefinitions.getColumnNumber(attrCol)) : null;
                string = KeyValue.putAttributes(string2, execAttrObj.attrSet, false);
                directoryRow.putColumn(tableDefinitions.getColumnNumber(policyCol), execAttrObj.getPolicy());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(typeCol), execAttrObj.getType());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(idCol), execAttrObj.getId());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(attrCol), string);
                if (directoryRow2 == null) {
                    directoryTable.addRow(directoryRow);
                    break block4;
                }
                directoryTable.modifyRow(directoryRow2, directoryRow);
            }
            catch (Throwable throwable) {
                Object var4_9 = null;
                directoryTable.close();
                throw throwable;
            }
        }
        Object var4_8 = null;
        directoryTable.close();
    }
}

