/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.processor;

import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.cim.UnsignedInt16;
import com.sun.wbem.cim.UnsignedInt32;
import com.sun.wbem.client.CIMOMHandle;
import com.sun.wbem.provider20.InstanceProvider;
import com.sun.wbem.solarisprovider.common.ProviderUtility;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Vector;

public class Solaris_Processor
implements InstanceProvider {
    private CIMOMHandle cimomhandle = null;
    private ProviderUtility provUtil = null;

    static {
        System.loadLibrary("solprov");
    }

    native int GetCPUCount();

    native int GetCPULoad();

    native int GetCPUStatus(String var1);

    native int GetCPUUpHours(String var1);

    native int GetCurrentCPUSpeed(String var1);

    public void cleanup() throws CIMException {
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("NO_SUCH_METHOD");
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        throw new CIMException("NO_SUCH_METHOD");
    }

    public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass) throws CIMException {
        try {
            Vector<CIMObjectPath> vector = new Vector<CIMObjectPath>();
            int n = 0;
            while (n < this.GetCPUCount()) {
                CIMObjectPath cIMObjectPath2 = new CIMObjectPath(cIMObjectPath.getObjectName(), cIMObjectPath.getNameSpace());
                cIMObjectPath2.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                cIMObjectPath2.addKey("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)"Solaris_Processor"));
                cIMObjectPath2.addKey("DeviceID", new CIMValue((Object)String.valueOf(n)));
                vector.addElement(cIMObjectPath2);
                ++n;
            }
            return vector;
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, "LM_10802", "LM_10803", null, null, null, null);
            this.provUtil.writeLog(2, exception);
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass, boolean bl2) throws CIMException {
        try {
            Vector<CIMInstance> vector = new Vector<CIMInstance>();
            int n = 0;
            while (n < this.GetCPUCount()) {
                String string = String.valueOf(n);
                CIMInstance cIMInstance = cIMClass.newInstance();
                cIMInstance.setProperty("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                cIMInstance.setProperty("CreationClassName", new CIMValue((Object)"Solaris_Processor"));
                cIMInstance.setProperty("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                cIMInstance.setProperty("DeviceID", new CIMValue((Object)string));
                int n2 = this.GetCurrentCPUSpeed(string);
                cIMInstance.setProperty("MaxClockSpeed", new CIMValue((Object)new UnsignedInt32((long)n2)));
                cIMInstance.setProperty("CurrentClockSpeed", new CIMValue((Object)new UnsignedInt32((long)n2)));
                cIMInstance.setProperty("LoadPercentage", new CIMValue((Object)new UnsignedInt16(this.GetCPULoad())));
                cIMInstance.setProperty("Status", new CIMValue((Object)this.getStatus(string)));
                cIMInstance.setProperty("PowerOnHours", new CIMValue((Object)new UnsignedInt32((long)this.GetCPUUpHours(string))));
                vector.addElement(cIMInstance);
                ++n;
            }
            return vector;
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, "LM_10802", "LM_10803", null, null, null, null);
            this.provUtil.writeLog(2, exception);
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public Vector execQuery(CIMObjectPath cIMObjectPath, String string, int n, CIMClass cIMClass) {
        return null;
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, CIMClass cIMClass, boolean bl) {
        try {
            CIMInstance cIMInstance;
            String string = "0";
            Enumeration enumeration = cIMObjectPath.getKeys().elements();
            while (enumeration.hasMoreElements()) {
                cIMInstance = (CIMProperty)enumeration.nextElement();
                if (!cIMInstance.getName().equalsIgnoreCase("deviceid")) continue;
                string = (String)cIMInstance.getValue().getValue();
            }
            cIMInstance = cIMClass.newInstance();
            cIMInstance.setProperty("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
            cIMInstance.setProperty("CreationClassName", new CIMValue((Object)"Solaris_Processor"));
            cIMInstance.setProperty("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
            cIMInstance.setProperty("DeviceID", new CIMValue((Object)string));
            int n = this.GetCurrentCPUSpeed(string);
            cIMInstance.setProperty("MaxClockSpeed", new CIMValue((Object)new UnsignedInt32((long)n)));
            cIMInstance.setProperty("CurrentClockSpeed", new CIMValue((Object)new UnsignedInt32((long)n)));
            cIMInstance.setProperty("LoadPercentage", new CIMValue((Object)new UnsignedInt16(this.GetCPULoad())));
            cIMInstance.setProperty("Status", new CIMValue((Object)this.getStatus(string)));
            cIMInstance.setProperty("PowerOnHours", new CIMValue((Object)new UnsignedInt32((long)this.GetCPUUpHours(string))));
            return cIMInstance;
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, "LM_10800", "LM_10801", null, null, null, null);
            this.provUtil.writeLog(2, exception);
            System.out.println("Returning NULL from get Instance");
            return null;
        }
    }

    private String getStatus(String string) {
        switch (this.GetCPUStatus(string)) {
            case 1: {
                return "offline";
            }
            case 2: {
                return "online";
            }
            case 3: {
                return "unknown";
            }
            case 4: {
                return "bad";
            }
            case 5: {
                return "poweroff";
            }
        }
        return "unknown";
    }

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        this.cimomhandle = cIMOMHandle;
        this.provUtil = new ProviderUtility(cIMOMHandle, "Disk Manager");
    }

    public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }
}

