/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.perfmon;

import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMProviderException;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.client.CIMOMHandle;
import com.sun.wbem.provider20.InstanceProvider;
import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.perfmon.CPUVminfo;
import com.sun.wbem.solarisprovider.perfmon.PerformanceMonitor;
import com.sun.wbem.utility.log.LogUtil;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Vector;

public class Solaris_CpuVminfoPerformanceMonitor
implements InstanceProvider {
    public static final String PROVIDERNAME = "Solaris Performance Monitor";
    public static final String CAPTION = "Solaris per Cpu Virtual Memory Statistical Information : CpuID# ";
    private static CIMOMHandle cimomHandle = null;
    private static ProviderUtility provUtil = null;
    private LogUtil logUtil = null;
    private PerformanceMonitor perfMon = null;

    public void cleanup() throws CIMException {
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        try {
            String[] stringArray = new String[]{"Create Instance"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", "LM_9603", stringArray, null, false, 0, 0);
        }
        catch (CIMException cIMException) {}
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        try {
            String[] stringArray = new String[]{"Delete Instance"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", "LM_9603", stringArray, null, false, 0, 0);
        }
        catch (CIMException cIMException) {}
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass) throws CIMException {
        Vector<CIMObjectPath> vector = new Vector<CIMObjectPath>();
        Vector vector2 = null;
        try {
            provUtil.checkAuthenticated();
        }
        catch (CIMException cIMException) {
            String[] stringArray = new String[]{"enumInstances"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", "LM_9602", stringArray, null, false, 0, 2);
            throw new CIMException("CIM_ERR_ACCESS_DENIED");
        }
        try {
            vector2 = this.perfMon.getAllCpuVMObjs();
            if (vector2 == null) {
                return null;
            }
            int n = 0;
            while (n < vector2.size()) {
                CIMObjectPath cIMObjectPath2 = null;
                cIMObjectPath2 = new CIMObjectPath(cIMObjectPath.getObjectName(), cIMObjectPath.getNameSpace());
                CIMObjectPath cIMObjectPath3 = new CIMObjectPath("Solaris_CpuVminfo");
                CIMObjectPath cIMObjectPath4 = new CIMObjectPath(cIMObjectPath3.getObjectName(), cIMObjectPath3.getNameSpace());
                cIMObjectPath4.addKey("Name", new CIMValue((Object)String.valueOf(((CPUVminfo)vector2.elementAt(n)).getCpuId())));
                cIMObjectPath4.addKey("DeviceID", new CIMValue((Object)String.valueOf(((CPUVminfo)vector2.elementAt(n)).getCpuId())));
                cIMObjectPath4.addKey("CreationClassName", new CIMValue((Object)"Solaris_CpuVminfo"));
                cIMObjectPath4.addKey("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                cIMObjectPath4.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                CIMObjectPath cIMObjectPath5 = new CIMObjectPath("Solaris_Processor");
                CIMObjectPath cIMObjectPath6 = new CIMObjectPath(cIMObjectPath5.getObjectName(), cIMObjectPath5.getNameSpace());
                cIMObjectPath6.addKey("DeviceID", new CIMValue((Object)String.valueOf(((CPUVminfo)vector2.elementAt(n)).getCpuId())));
                cIMObjectPath6.addKey("CreationClassName", new CIMValue((Object)"Solaris_Processor"));
                cIMObjectPath6.addKey("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                cIMObjectPath6.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                cIMObjectPath2.addKey("Stats", new CIMValue((Object)cIMObjectPath4));
                cIMObjectPath2.addKey("Element", new CIMValue((Object)cIMObjectPath6));
                vector.addElement(cIMObjectPath2);
                ++n;
            }
        }
        catch (Exception exception) {
            String string = this.perfMon.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
        return vector;
    }

    public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass, boolean bl2) throws CIMException {
        Vector<CIMInstance> vector = new Vector<CIMInstance>();
        Vector vector2 = null;
        try {
            provUtil.checkAuthenticated();
        }
        catch (CIMException cIMException) {
            String[] stringArray = new String[]{"enumInstances"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", "LM_9602", stringArray, null, false, 0, 2);
            throw new CIMException("CIM_ERR_ACCESS_DENIED");
        }
        try {
            vector2 = this.perfMon.getAllCpuVMObjs();
            if (vector2 == null) {
                return null;
            }
            int n = 0;
            while (n < vector2.size()) {
                CIMInstance cIMInstance = cIMClass.newInstance();
                CIMObjectPath cIMObjectPath2 = new CIMObjectPath("Solaris_CpuVminfo");
                CIMObjectPath cIMObjectPath3 = new CIMObjectPath(cIMObjectPath2.getObjectName(), cIMObjectPath2.getNameSpace());
                cIMObjectPath3.addKey("Name", new CIMValue((Object)String.valueOf(((CPUVminfo)vector2.elementAt(n)).getCpuId())));
                cIMObjectPath3.addKey("DeviceID", new CIMValue((Object)String.valueOf(((CPUVminfo)vector2.elementAt(n)).getCpuId())));
                cIMObjectPath3.addKey("CreationClassName", new CIMValue((Object)"Solaris_CpuVminfo"));
                cIMObjectPath3.addKey("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                cIMObjectPath3.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                CIMObjectPath cIMObjectPath4 = new CIMObjectPath("Solaris_Processor");
                CIMObjectPath cIMObjectPath5 = new CIMObjectPath(cIMObjectPath4.getObjectName(), cIMObjectPath4.getNameSpace());
                cIMObjectPath5.addKey("DeviceID", new CIMValue((Object)String.valueOf(((CPUVminfo)vector2.elementAt(n)).getCpuId())));
                cIMObjectPath5.addKey("CreationClassName", new CIMValue((Object)"Solaris_Processor"));
                cIMObjectPath5.addKey("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                cIMObjectPath5.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                cIMInstance.setProperty("Stats", new CIMValue((Object)cIMObjectPath3));
                cIMInstance.setProperty("Element", new CIMValue((Object)cIMObjectPath5));
                vector.addElement(cIMInstance);
                ++n;
            }
        }
        catch (Exception exception) {
            String string = this.perfMon.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
        return vector;
    }

    public Vector execQuery(CIMObjectPath cIMObjectPath, String string, int n, CIMClass cIMClass) throws CIMException {
        try {
            String[] stringArray = new String[]{"execQuery"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", "LM_9603", stringArray, null, false, 0, 0);
        }
        catch (CIMException cIMException) {}
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    protected static CIMOMHandle getCimomHandle() {
        return cimomHandle;
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, CIMClass cIMClass, boolean bl) throws CIMException {
        CIMObjectPath cIMObjectPath2 = null;
        CIMObjectPath cIMObjectPath3 = null;
        try {
            provUtil.checkAuthenticated();
        }
        catch (CIMException cIMException) {
            String[] stringArray = new String[]{"getInstance"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", "LM_9602", stringArray, null, false, 0, 2);
            throw new CIMException("CIM_ERR_ACCESS_DENIED");
        }
        CIMInstance cIMInstance = cIMClass.newInstance();
        try {
            Enumeration enumeration = cIMObjectPath.getKeys().elements();
            while (enumeration.hasMoreElements()) {
                CIMProperty cIMProperty = (CIMProperty)enumeration.nextElement();
                if (cIMProperty.getName().equalsIgnoreCase("Stats")) {
                    cIMObjectPath3 = (CIMObjectPath)cIMProperty.getValue().getValue();
                }
                if (!cIMProperty.getName().equalsIgnoreCase("Element")) continue;
                cIMObjectPath2 = (CIMObjectPath)cIMProperty.getValue().getValue();
            }
            cIMInstance.setProperty("Stats", new CIMValue(cIMObjectPath3));
            cIMInstance.setProperty("Element", new CIMValue(cIMObjectPath2));
        }
        catch (Exception exception) {
            String string = this.perfMon.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
        return cIMInstance;
    }

    protected static ProviderUtility getProviderUtil() {
        return provUtil;
    }

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        cimomHandle = cIMOMHandle;
        this.logUtil = LogUtil.getInstance((CIMOMHandle)cIMOMHandle);
        try {
            provUtil = new ProviderUtility(cimomHandle, "Solaris per Cpu Virtual Memory Performance Monitor");
        }
        catch (CIMException cIMException) {
            throw new CIMException("CIM_ERR_FAILED");
        }
        this.perfMon = new PerformanceMonitor(cIMOMHandle, this.logUtil, provUtil);
    }

    public synchronized void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        try {
            String[] stringArray = new String[]{"Set Instance"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", "LM_9603", stringArray, null, false, 0, 0);
        }
        catch (CIMException cIMException) {}
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }
}

