/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.perfmon;

import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMElement;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMProviderException;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.cim.UnsignedInt32;
import com.sun.wbem.client.CIMOMHandle;
import com.sun.wbem.provider.MethodProvider;
import com.sun.wbem.provider.PropertyProvider;
import com.sun.wbem.provider20.Authorizable;
import com.sun.wbem.provider20.InstanceProvider;
import com.sun.wbem.query.NonJoinExp;
import com.sun.wbem.query.QueryExp;
import com.sun.wbem.query.SelectExp;
import com.sun.wbem.query.SelectList;
import com.sun.wbem.query.WQLParser;
import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.perfmon.CPUVminfo;
import com.sun.wbem.solarisprovider.perfmon.PerformanceMonitor;
import com.sun.wbem.utility.log.LogUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;

public class Solaris_CpuVminfo
implements InstanceProvider,
PropertyProvider,
MethodProvider,
Authorizable {
    public static final String PROVIDERNAME = "Solaris System Performance Monitor";
    public static final String CAPTION = "Solaris CPU virtual memory Information: cpuID# ";
    private static CIMOMHandle cimomHandle = null;
    private static ProviderUtility provUtil = null;
    private LogUtil logUtil = null;
    private PerformanceMonitor perfMon = null;

    public void cleanup() throws CIMException {
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        try {
            String[] stringArray = new String[]{"Create Instance"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", "LM_9603", stringArray, null, false, 0, 0);
        }
        catch (CIMException cIMException) {}
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        try {
            String[] stringArray = new String[]{"Delete Instance"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", "LM_9603", stringArray, null, false, 0, 0);
        }
        catch (CIMException cIMException) {}
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass) throws CIMException {
        Vector<CIMObjectPath> vector = new Vector<CIMObjectPath>();
        Vector vector2 = null;
        try {
            provUtil.checkAuthenticated();
        }
        catch (CIMException cIMException) {
            String[] stringArray = new String[]{"enumInstances"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", "LM_9602", stringArray, null, false, 0, 2);
            throw new CIMException("CIM_ERR_ACCESS_DENIED");
        }
        try {
            vector2 = this.perfMon.getAllCpuVMObjs();
            if (vector2 == null) {
                return null;
            }
            int n = 0;
            while (n < vector2.size()) {
                CIMObjectPath cIMObjectPath2 = null;
                cIMObjectPath2 = new CIMObjectPath(cIMObjectPath.getObjectName(), cIMObjectPath.getNameSpace());
                cIMObjectPath2.addKey("Name", new CIMValue((Object)String.valueOf(((CPUVminfo)vector2.elementAt(n)).getCpuId())));
                cIMObjectPath2.addKey("DeviceID", new CIMValue((Object)String.valueOf(((CPUVminfo)vector2.elementAt(n)).getCpuId())));
                cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)"Solaris_CpuVminfo"));
                try {
                    cIMObjectPath2.addKey("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                }
                catch (UnknownHostException unknownHostException) {}
                cIMObjectPath2.addKey("DeviceCreationClassName", new CIMValue((Object)"Solaris_Processor"));
                cIMObjectPath2.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                vector.addElement(cIMObjectPath2);
                ++n;
            }
            return vector;
        }
        catch (Exception exception) {
            String string = this.perfMon.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
    }

    public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass, boolean bl2) throws CIMException {
        Vector<CIMInstance> vector = new Vector<CIMInstance>();
        Vector vector2 = null;
        try {
            provUtil.checkAuthenticated();
        }
        catch (CIMException cIMException) {
            String[] stringArray = new String[]{"enumInstances"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", "LM_9602", stringArray, null, false, 0, 2);
            throw new CIMException("CIM_ERR_ACCESS_DENIED");
        }
        try {
            vector2 = this.perfMon.getAllCpuVMObjs();
            if (vector2 == null) {
                return null;
            }
            int n = 0;
            while (n < vector2.size()) {
                CIMInstance cIMInstance = cIMClass.newInstance();
                CPUVminfo cPUVminfo = null;
                cPUVminfo = (CPUVminfo)vector2.elementAt(n);
                if (cPUVminfo != null) {
                    cIMInstance.setProperty("PageReclaims", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getPageReclaims())));
                    cIMInstance.setProperty("PgReclaimsFlst", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getPgReclaimsFlst())));
                    cIMInstance.setProperty("PageIns", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getPageIns())));
                    cIMInstance.setProperty("PagesPagedIn", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getPagesPagedIn())));
                    cIMInstance.setProperty("PageOuts", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getPageOuts())));
                    cIMInstance.setProperty("PagesPagedOut", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getPagesPagedOut())));
                    cIMInstance.setProperty("SwapIns", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getSwapIns())));
                    cIMInstance.setProperty("PagesSwappedIn", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getPagesSwappedIn())));
                    cIMInstance.setProperty("SwapOuts", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getSwapOuts())));
                    cIMInstance.setProperty("PagesSwappedOut", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getPagesSwappedOut())));
                    cIMInstance.setProperty("PagesZfilledOd", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getPagesZfilledOd())));
                    cIMInstance.setProperty("PagesDfreed", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getPagesDfreed())));
                    cIMInstance.setProperty("PageoutDscan", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getPageoutDscan())));
                    cIMInstance.setProperty("PageDaemonRevs", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getPageDaemonRevs())));
                    cIMInstance.setProperty("HatPageFaults", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getHatPageFaults())));
                    cIMInstance.setProperty("AsPageFaults", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getAsPageFaults())));
                    cIMInstance.setProperty("MajPageFaults", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getMajPageFaults())));
                    cIMInstance.setProperty("CowFaults", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getCowFaults())));
                    cIMInstance.setProperty("ProtFaults", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getProtFaults())));
                    cIMInstance.setProperty("SoftLockFaults", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getSoftLockFaults())));
                    cIMInstance.setProperty("KernelAsFaults", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getKernelAsFaults())));
                    cIMInstance.setProperty("PagerRun", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getPagerRun())));
                    cIMInstance.setProperty("ExecPagein", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getExecPagein())));
                    cIMInstance.setProperty("ExecPageout", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getExecPageout())));
                    cIMInstance.setProperty("ExecFreePages", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getExecFreePages())));
                    cIMInstance.setProperty("AnonPagein", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getAnonPagein())));
                    cIMInstance.setProperty("AnonPageout", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getAnonPageout())));
                    cIMInstance.setProperty("AnonPagesFreed", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getAnonPagesFreed())));
                    cIMInstance.setProperty("FsPagein", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getFsPagein())));
                    cIMInstance.setProperty("FsPageout", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getFsPageout())));
                    cIMInstance.setProperty("FsPagesFree", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getFsPagesFree())));
                    cIMInstance.setProperty("Name", new CIMValue((Object)String.valueOf(cPUVminfo.getCpuId())));
                    cIMInstance.setProperty("DeviceID", new CIMValue((Object)String.valueOf(cPUVminfo.getCpuId())));
                }
                if (!bl2) {
                    cIMInstance.setProperty("CreationClassName", new CIMValue((Object)"Solaris_CpuVminfo"));
                    try {
                        cIMInstance.setProperty("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                    }
                    catch (UnknownHostException unknownHostException) {}
                    cIMInstance.setProperty("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                    cIMInstance.setProperty("DeviceCreationClassName", new CIMValue((Object)"Solaris_Processor"));
                    cIMInstance.setProperty("Description", new CIMValue((Object)PROVIDERNAME));
                    cIMInstance.setProperty("Caption", new CIMValue((Object)(CAPTION + cPUVminfo.getCpuId())));
                }
                vector.addElement(cIMInstance);
                ++n;
            }
            return vector;
        }
        catch (Exception exception) {
            String string = this.perfMon.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
    }

    public Vector execQuery(CIMObjectPath cIMObjectPath, String string, int n, CIMClass cIMClass) throws CIMException {
        try {
            provUtil.checkAuthenticated();
        }
        catch (CIMException cIMException) {
            String[] stringArray = new String[]{"execQuery"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", "LM_9602", stringArray, null, false, 0, 2);
            throw new CIMException("CIM_ERR_ACCESS_DENIED");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        WQLParser wQLParser = new WQLParser((InputStream)byteArrayInputStream);
        Vector<CIMElement> vector = new Vector<CIMElement>();
        try {
            SelectExp selectExp = (SelectExp)wQLParser.querySpecification();
            SelectList selectList = selectExp.getSelectList();
            NonJoinExp nonJoinExp = (NonJoinExp)selectExp.getFromClause();
            QueryExp queryExp = selectExp.getWhereClause();
            Vector vector2 = new Vector();
            vector2 = this.enumInstances(cIMObjectPath, false, cIMClass, true);
            int n2 = 0;
            while (n2 < vector2.size()) {
                if (queryExp == null || queryExp.apply((CIMElement)((CIMInstance)vector2.elementAt(n2)))) {
                    vector.addElement(selectList.apply((CIMElement)((CIMInstance)vector2.elementAt(n2))));
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            String[] stringArray = new String[]{string};
            String string2 = this.perfMon.writeLog(2, "LM_9630", stringArray, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string2);
        }
        return vector;
    }

    public Integer getBulkData(Vector vector) throws CIMException {
        Integer n;
        try {
            String string = this.perfMon.getBulkCpuVmInfo();
            if (string == null) {
                n = new Integer(-1);
            } else {
                vector.addElement(new CIMValue((Object)string));
                n = new Integer(0);
            }
        }
        catch (Exception exception) {
            String string = this.perfMon.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
        return n;
    }

    protected static CIMOMHandle getCimomHandle() {
        return cimomHandle;
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, CIMClass cIMClass, boolean bl) throws CIMException {
        CIMInstance cIMInstance = cIMClass.newInstance();
        try {
            provUtil.checkAuthenticated();
        }
        catch (CIMException cIMException) {
            String[] stringArray = new String[]{"getInstance"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", "LM_9602", stringArray, null, false, 0, 2);
            throw new CIMException("CIM_ERR_ACCESS_DENIED");
        }
        try {
            CPUVminfo cPUVminfo;
            String string = null;
            Enumeration enumeration = cIMObjectPath.getKeys().elements();
            while (enumeration != null && enumeration.hasMoreElements()) {
                cPUVminfo = (CIMProperty)enumeration.nextElement();
                if (!cPUVminfo.getName().equalsIgnoreCase("Name")) continue;
                string = (String)cPUVminfo.getValue().getValue();
            }
            cPUVminfo = this.perfMon.getCpuVMObj(Integer.parseInt(string));
            if (cPUVminfo != null) {
                cIMInstance.setProperty("PageReclaims", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getPageReclaims())));
                cIMInstance.setProperty("PgReclaimsFlst", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getPgReclaimsFlst())));
                cIMInstance.setProperty("PageIns", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getPageIns())));
                cIMInstance.setProperty("PagesPagedIn", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getPagesPagedIn())));
                cIMInstance.setProperty("PageOuts", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getPageOuts())));
                cIMInstance.setProperty("PagesPagedOut", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getPagesPagedOut())));
                cIMInstance.setProperty("SwapIns", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getSwapIns())));
                cIMInstance.setProperty("PagesSwappedIn", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getPagesSwappedIn())));
                cIMInstance.setProperty("SwapOuts", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getSwapOuts())));
                cIMInstance.setProperty("PagesSwappedOut", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getPagesSwappedOut())));
                cIMInstance.setProperty("PagesZfilledOd", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getPagesZfilledOd())));
                cIMInstance.setProperty("PagesDfreed", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getPagesDfreed())));
                cIMInstance.setProperty("PageoutDscan", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getPageoutDscan())));
                cIMInstance.setProperty("PageDaemonRevs", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getPageDaemonRevs())));
                cIMInstance.setProperty("HatPageFaults", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getHatPageFaults())));
                cIMInstance.setProperty("AsPageFaults", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getAsPageFaults())));
                cIMInstance.setProperty("MajPageFaults", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getMajPageFaults())));
                cIMInstance.setProperty("CowFaults", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getCowFaults())));
                cIMInstance.setProperty("ProtFaults", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getProtFaults())));
                cIMInstance.setProperty("SoftLockFaults", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getSoftLockFaults())));
                cIMInstance.setProperty("KernelAsFaults", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getKernelAsFaults())));
                cIMInstance.setProperty("PagerRun", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getPagerRun())));
                cIMInstance.setProperty("ExecPagein", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getExecPagein())));
                cIMInstance.setProperty("ExecPageout", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getExecPageout())));
                cIMInstance.setProperty("ExecFreePages", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getExecFreePages())));
                cIMInstance.setProperty("AnonPagein", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getAnonPagein())));
                cIMInstance.setProperty("AnonPageout", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getAnonPageout())));
                cIMInstance.setProperty("AnonPagesFreed", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getAnonPagesFreed())));
                cIMInstance.setProperty("FsPagein", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getFsPagein())));
                cIMInstance.setProperty("FsPageout", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getFsPageout())));
                cIMInstance.setProperty("FsPagesFree", new CIMValue((Object)new UnsignedInt32(cPUVminfo.getFsPagesFree())));
                cIMInstance.setProperty("Name", new CIMValue((Object)String.valueOf(cPUVminfo.getCpuId())));
                cIMInstance.setProperty("DeviceID", new CIMValue((Object)String.valueOf(cPUVminfo.getCpuId())));
            }
            if (bl) {
                return cIMInstance;
            }
            cIMInstance.setProperty("CreationClassName", new CIMValue((Object)"Solaris_CpuVminfo"));
            try {
                cIMInstance.setProperty("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
            }
            catch (UnknownHostException unknownHostException) {}
            cIMInstance.setProperty("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
            cIMInstance.setProperty("DeviceCreationClassName", new CIMValue((Object)"Solaris_Processor"));
            cIMInstance.setProperty("Description", new CIMValue((Object)PROVIDERNAME));
            cIMInstance.setProperty("Caption", new CIMValue((Object)(CAPTION + cPUVminfo.getCpuId())));
        }
        catch (Exception exception) {
            String string = this.perfMon.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
        return cIMInstance;
    }

    public synchronized CIMValue getPropertyValue(CIMObjectPath cIMObjectPath, String string, String string2) throws CIMException {
        CIMValue cIMValue;
        block43: {
            Object object;
            String[] stringArray;
            String string3 = null;
            CPUVminfo cPUVminfo = null;
            try {
                provUtil.checkAuthenticated();
            }
            catch (CIMException cIMException) {
                String[] stringArray2 = new String[]{"getPropertyValue"};
                this.logUtil.writeLog(PROVIDERNAME, "LM_9600", "LM_9602", stringArray2, null, false, 0, 2);
                throw new CIMException("CIM_ERR_ACCESS_DENIED");
            }
            try {
                stringArray = cIMObjectPath.getKeys().elements();
                while (stringArray != null && stringArray.hasMoreElements()) {
                    object = (CIMProperty)stringArray.nextElement();
                    if (!object.getName().equalsIgnoreCase("Name")) continue;
                    string3 = (String)object.getValue().getValue();
                }
                cPUVminfo = this.perfMon.getCpuVMObj(Integer.parseInt(string3));
            }
            catch (Exception exception) {
                String string4 = this.perfMon.writeLog(2, null, null, exception);
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string4);
            }
            try {
                if (string2.equalsIgnoreCase("PageReclaims")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUVminfo.getPageReclaims()));
                    break block43;
                }
                if (string2.equalsIgnoreCase("PgReclaimsFlst")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUVminfo.getPgReclaimsFlst()));
                    break block43;
                }
                if (string2.equalsIgnoreCase("PageIns")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUVminfo.getPageIns()));
                    break block43;
                }
                if (string2.equalsIgnoreCase("PagesPagedIn")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUVminfo.getPagesPagedIn()));
                    break block43;
                }
                if (string2.equalsIgnoreCase("PageOuts")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUVminfo.getPageOuts()));
                    break block43;
                }
                if (string2.equalsIgnoreCase("PagesPagedOut")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUVminfo.getPagesPagedOut()));
                    break block43;
                }
                if (string2.equalsIgnoreCase("SwapIns")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUVminfo.getSwapIns()));
                    break block43;
                }
                if (string2.equalsIgnoreCase("PagesSwappedIn")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUVminfo.getPagesSwappedIn()));
                    break block43;
                }
                if (string2.equalsIgnoreCase("SwapOuts")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUVminfo.getSwapOuts()));
                    break block43;
                }
                if (string2.equalsIgnoreCase("PagesSwappedOut")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUVminfo.getPagesSwappedOut()));
                    break block43;
                }
                if (string2.equalsIgnoreCase("PagesZfilledOd")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUVminfo.getPagesZfilledOd()));
                    break block43;
                }
                if (string2.equalsIgnoreCase("PagesDfreed")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUVminfo.getPagesDfreed()));
                    break block43;
                }
                if (string2.equalsIgnoreCase("PageoutDscan")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUVminfo.getPageoutDscan()));
                    break block43;
                }
                if (string2.equalsIgnoreCase("PageDaemonRevs")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUVminfo.getPageDaemonRevs()));
                    break block43;
                }
                if (string2.equalsIgnoreCase("HatPageFaults")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUVminfo.getHatPageFaults()));
                    break block43;
                }
                if (string2.equalsIgnoreCase("AsPageFaults")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUVminfo.getAsPageFaults()));
                    break block43;
                }
                if (string2.equalsIgnoreCase("MajPageFaults")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUVminfo.getMajPageFaults()));
                    break block43;
                }
                if (string2.equalsIgnoreCase("CowFaults")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUVminfo.getCowFaults()));
                    break block43;
                }
                if (string2.equalsIgnoreCase("ProtFaults")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUVminfo.getProtFaults()));
                    break block43;
                }
                if (string2.equalsIgnoreCase("SoftLockFaults")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUVminfo.getSoftLockFaults()));
                    break block43;
                }
                if (string2.equalsIgnoreCase("KernelAsFaults")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUVminfo.getKernelAsFaults()));
                    break block43;
                }
                if (string2.equalsIgnoreCase("PagerRun")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUVminfo.getPagerRun()));
                    break block43;
                }
                if (string2.equalsIgnoreCase("ExecPagein")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUVminfo.getExecPagein()));
                    break block43;
                }
                if (string2.equalsIgnoreCase("ExecPageout")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUVminfo.getExecPageout()));
                    break block43;
                }
                if (string2.equalsIgnoreCase("ExecFreePages")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUVminfo.getExecFreePages()));
                    break block43;
                }
                if (string2.equalsIgnoreCase("AnonPagein")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUVminfo.getAnonPagein()));
                    break block43;
                }
                if (string2.equalsIgnoreCase("AnonPageout")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUVminfo.getAnonPageout()));
                    break block43;
                }
                if (string2.equalsIgnoreCase("AnonPagesFreed")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUVminfo.getAnonPagesFreed()));
                    break block43;
                }
                if (string2.equalsIgnoreCase("FsPagein")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUVminfo.getFsPagein()));
                    break block43;
                }
                if (string2.equalsIgnoreCase("FsPageout")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUVminfo.getFsPageout()));
                    break block43;
                }
                if (string2.equalsIgnoreCase("FsPagesFree")) {
                    cIMValue = new CIMValue((Object)new UnsignedInt32(cPUVminfo.getFsPagesFree()));
                    break block43;
                }
                if (string2.equalsIgnoreCase("Name")) {
                    cIMValue = new CIMValue((Object)String.valueOf(cPUVminfo.getCpuId()));
                    break block43;
                }
                if (string2.equalsIgnoreCase("DeviceID")) {
                    cIMValue = new CIMValue((Object)String.valueOf(cPUVminfo.getCpuId()));
                    break block43;
                }
                if (string2.equalsIgnoreCase("CreationClassName")) {
                    cIMValue = new CIMValue((Object)"Solaris_CpuVminfo");
                    break block43;
                }
                if (string2.equalsIgnoreCase("SystemName")) {
                    cIMValue = new CIMValue((Object)InetAddress.getLocalHost().getHostName());
                    break block43;
                }
                if (string2.equalsIgnoreCase("SystemCreationClassName")) {
                    cIMValue = new CIMValue((Object)"Solaris_ComputerSystem");
                    break block43;
                }
                stringArray = new String[]{string2};
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)this.logUtil.getLocalizedMessage("LM_9601", stringArray));
            }
            catch (Exception exception) {
                object = this.perfMon.writeLog(2, null, null, exception);
                throw new CIMProviderException("GENERAL_EXCEPTION", object);
            }
        }
        return cIMValue;
    }

    protected static ProviderUtility getProviderUtil() {
        return provUtil;
    }

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        cimomHandle = cIMOMHandle;
        this.logUtil = LogUtil.getInstance((CIMOMHandle)cIMOMHandle);
        try {
            provUtil = new ProviderUtility(cimomHandle, PROVIDERNAME);
        }
        catch (CIMException cIMException) {
            throw new CIMException("CIM_ERR_FAILED");
        }
        this.perfMon = new PerformanceMonitor(cIMOMHandle, this.logUtil, provUtil);
    }

    public synchronized CIMValue invokeMethod(CIMObjectPath cIMObjectPath, String string, Vector vector, Vector vector2) throws CIMException {
        try {
            provUtil.checkAuthenticated();
        }
        catch (CIMException cIMException) {
            String[] stringArray = new String[]{"invokeMethod"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", "LM_9602", stringArray, null, false, 0, 2);
            throw new CIMException("CIM_ERR_ACCESS_DENIED");
        }
        if (string.equalsIgnoreCase("getBulkData")) {
            return new CIMValue((Object)this.getBulkData(vector2));
        }
        return null;
    }

    public synchronized void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        try {
            String[] stringArray = new String[]{"Set Instance"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", "LM_9603", stringArray, null, false, 0, 0);
        }
        catch (CIMException cIMException) {}
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public synchronized void setPropertyValue(CIMObjectPath cIMObjectPath, String string, String string2, CIMValue cIMValue) throws CIMException {
        try {
            String[] stringArray = new String[]{"setPropertyValue"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", "LM_9603", stringArray, null, false, 0, 0);
        }
        catch (CIMException cIMException) {}
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }
}

