/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.fsmgr.mount;

import com.sun.wbem.solarisprovider.fsmgr.common.FsMgrException;
import com.sun.wbem.solarisprovider.fsmgr.mount.FsMgrMount;
import com.sun.wbem.solarisprovider.fsmgr.mount.FsMgrMountInterface;
import com.sun.wbem.solarisprovider.fsmgr.mount.FsMgrMountWrapper;
import com.sun.wbem.utility.common.CommonTools;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableFactory;
import com.sun.wbem.utility.directorytable.FileTableDefinitions;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class FsMgrMountTable
implements FsMgrMountInterface {
    public static final String MOUNTTAB = new String("mounttab");
    private static String resource = new String("resource");
    private static String fsckDevice = new String("fsckDevice");
    private static String mountPoint = new String("mountPoint");
    private static String fsType = new String("fsType");
    private static String fsckPass = new String("fsckPass");
    private static String bootMount = new String("bootMount");
    private static String options = new String("options");
    private int resourceColumn = 0;
    private int fsckDeviceColumn = 0;
    private int mountPointColumn = 0;
    private int fsTypeColumn = 0;
    private int fsckPassColumn = 0;
    private int bootMountColumn = 0;
    private int optionsColumn = 0;
    private static final String umountCommand = new String("/usr/sbin/umount");
    private static final String mountCommand = new String("/usr/sbin/mount");
    private static final String mountOption = new String("-p");
    private static final String fileType = new String("File");
    private static final String FSM = new String("FSM");
    private static final String emptyString = new String("");
    private FileTableDefinitions fileTableDefinitions = new FileTableDefinitions();
    private File tempFile = null;
    private FsMgrMountWrapper wrapper = null;

    public FsMgrMountTable(FsMgrMountWrapper fsMgrMountWrapper) throws DirectoryTableException {
        this.wrapper = fsMgrMountWrapper;
        this.fileTableDefinitions.loadTableDefinitions(MOUNTTAB);
        this.resourceColumn = this.fileTableDefinitions.getColumnNumber(resource);
        this.fsckDeviceColumn = this.fileTableDefinitions.getColumnNumber(fsckDevice);
        this.mountPointColumn = this.fileTableDefinitions.getColumnNumber(mountPoint);
        this.fsTypeColumn = this.fileTableDefinitions.getColumnNumber(fsType);
        this.fsckPassColumn = this.fileTableDefinitions.getColumnNumber(fsckPass);
        this.bootMountColumn = this.fileTableDefinitions.getColumnNumber(bootMount);
        this.optionsColumn = this.fileTableDefinitions.getColumnNumber(options);
    }

    public void addMount(FsMgrMount fsMgrMount) throws FsMgrException {
        String string = fsMgrMount.getMountPoint();
        String string2 = fsMgrMount.getResource();
        Vector vector = CommonTools.CMN_ExecWithStdErrNoCRLF((String[])fsMgrMount.toArray());
        String[] stringArray = (String[])vector.elementAt(1);
        if (stringArray.length != 0) {
            stringArray[0] = this.parseStdErr(stringArray[0]);
            this.wrapper.writeLog(2, "LM_4064", "LM_4099", stringArray[0], null, null, null);
            int n = stringArray[0].indexOf(58) + 2;
            throw new FsMgrException("EXM_FSS_MOUNT_ERROR", string2, string, stringArray[0].substring(n));
        }
    }

    private void closeMountTable(DirectoryTable directoryTable) throws DirectoryTableException {
        if (this.tempFile != null) {
            this.tempFile.delete();
        }
        if (directoryTable != null) {
            directoryTable.close();
        }
    }

    public FsMgrMount getMountEntry(String string, String string2) throws DirectoryTableException, FsMgrException {
        DirectoryTable directoryTable = this.openMountTable();
        DirectoryRow directoryRow = null;
        FsMgrMount fsMgrMount = null;
        try {
            directoryRow = directoryTable.getFirstRow();
            while (directoryRow != null) {
                fsMgrMount = this.parseMountEntry(directoryRow);
                if (fsMgrMount != null) {
                    if (string.equals(fsMgrMount.getResource()) && string2.equals(fsMgrMount.getMountPoint())) break;
                    fsMgrMount = null;
                }
                directoryRow = directoryTable.getNextRow();
            }
            this.closeMountTable(directoryTable);
        }
        catch (DirectoryTableException directoryTableException) {
            this.closeMountTable(directoryTable);
            throw directoryTableException;
        }
        return fsMgrMount;
    }

    public Vector list() throws DirectoryTableException, FsMgrException {
        Vector<FsMgrMount> vector = new Vector<FsMgrMount>();
        DirectoryTable directoryTable = this.openMountTable();
        DirectoryRow directoryRow = null;
        FsMgrMount fsMgrMount = null;
        try {
            directoryRow = directoryTable.getFirstRow();
            while (directoryRow != null) {
                fsMgrMount = this.parseMountEntry(directoryRow);
                vector.addElement(fsMgrMount);
                directoryRow = directoryTable.getNextRow();
            }
            this.closeMountTable(directoryTable);
        }
        catch (DirectoryTableException directoryTableException) {
            this.closeMountTable(directoryTable);
            throw directoryTableException;
        }
        return vector;
    }

    public Vector list(String string) throws DirectoryTableException, FsMgrException {
        Vector<FsMgrMount> vector = new Vector<FsMgrMount>();
        DirectoryTable directoryTable = this.openMountTable();
        DirectoryRow directoryRow = null;
        FsMgrMount fsMgrMount = null;
        try {
            directoryRow = directoryTable.getFirstRow();
            while (directoryRow != null) {
                fsMgrMount = this.parseMountEntry(directoryRow);
                if (fsMgrMount.getFsType().equalsIgnoreCase(string)) {
                    vector.addElement(fsMgrMount);
                }
                directoryRow = directoryTable.getNextRow();
            }
            this.closeMountTable(directoryTable);
        }
        catch (DirectoryTableException directoryTableException) {
            this.closeMountTable(directoryTable);
            throw directoryTableException;
        }
        return vector;
    }

    public void modifyMount(FsMgrMount fsMgrMount, FsMgrMount fsMgrMount2) throws FsMgrException {
        this.removeMount(fsMgrMount);
        try {
            this.addMount(fsMgrMount2);
        }
        catch (FsMgrException fsMgrException) {
            this.addMount(fsMgrMount);
            throw fsMgrException;
        }
    }

    private DirectoryTable openMountTable() throws DirectoryTableException, FsMgrException {
        String[] stringArray = new String[]{mountCommand, mountOption};
        Vector vector = CommonTools.CMN_exec((String[])stringArray, (boolean)true);
        String[] stringArray2 = (String[])vector.elementAt(0);
        String[] stringArray3 = (String[])vector.elementAt(1);
        if (stringArray3.length != 0) {
            this.wrapper.writeLog(2, "LM_4068", "LM_4099", stringArray3[0], null, null, null);
            int n = stringArray3[0].indexOf(58) + 1;
            throw new FsMgrException("EXM_FSS_MNTLIST_ERROR", stringArray3[0].substring(n));
        }
        try {
            this.tempFile = CommonTools.CMN_CreateTempFile((String)FSM);
            if (stringArray2.length != 0) {
                CommonTools.CMN_WriteArray((File)this.tempFile, (String[])stringArray2);
            }
        }
        catch (IOException iOException) {
            this.wrapper.writeLog(2, "LM_4062", "LM_4063", this.tempFile.getAbsolutePath(), null, null, null);
            throw new FsMgrException("EXM_FSS_DIE");
        }
        String string = this.tempFile.getAbsolutePath();
        this.fileTableDefinitions.setMappedTableName(string);
        DirectoryTableFactory directoryTableFactory = new DirectoryTableFactory();
        DirectoryTable directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)fileType, (String)emptyString, (String)emptyString);
        directoryTable.open((TableDefinitions)this.fileTableDefinitions);
        return directoryTable;
    }

    private FsMgrMount parseMountEntry(DirectoryRow directoryRow) throws DirectoryTableException {
        String string = directoryRow.getColumn(this.resourceColumn);
        String string2 = directoryRow.getColumn(this.fsckDeviceColumn);
        String string3 = directoryRow.getColumn(this.mountPointColumn);
        String string4 = directoryRow.getColumn(this.fsTypeColumn);
        String string5 = directoryRow.getColumn(this.fsckPassColumn);
        String string6 = directoryRow.getColumn(this.bootMountColumn);
        String string7 = directoryRow.getColumn(this.optionsColumn);
        FsMgrMount fsMgrMount = new FsMgrMount(string, string2, string3, string4, string5, string6, string7);
        return fsMgrMount;
    }

    private String parseStdErr(String string) {
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            string2 = String.valueOf(string2) + stringTokenizer.nextToken();
            string2 = String.valueOf(string2) + " ";
        }
        string2 = string2.trim();
        return string2;
    }

    public void removeMount(FsMgrMount fsMgrMount) throws FsMgrException {
        String string = fsMgrMount.getMountPoint();
        String[] stringArray = new String[]{umountCommand, string};
        Vector vector = CommonTools.CMN_exec((String[])stringArray, (boolean)true);
        String[] stringArray2 = (String[])vector.elementAt(1);
        if (stringArray2.length != 0) {
            this.wrapper.writeLog(2, "LM_4065", "LM_4099", stringArray2[0], null, null, null);
            int n = stringArray2[0].indexOf(58) + 1;
            throw new FsMgrException("EXM_FSS_UMOUNT_ERROR", string, stringArray2[0].substring(n));
        }
    }
}

