/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.server;

import com.sun.dhcpmgr.bridge.Bridge;
import com.sun.dhcpmgr.bridge.BridgeException;
import com.sun.dhcpmgr.data.DhcpDatastore;
import com.sun.dhcpmgr.data.DhcpdOptions;
import com.sun.dhcpmgr.data.IPAddress;
import com.sun.dhcpmgr.data.IPInterface;
import com.sun.dhcpmgr.data.Option;
import com.sun.dhcpmgr.data.OptionsTable;
import com.sun.dhcpmgr.server.DhcpHostsTable;
import com.sun.dhcpmgr.server.DhcpServiceMgr;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class DhcpServiceMgrImpl
implements DhcpServiceMgr {
    private Bridge bridge;
    private String serverName;
    private String shortServerName;
    private InetAddress serverAddress;

    public DhcpServiceMgrImpl(Bridge bridge) {
        this.bridge = bridge;
        try {
            this.serverAddress = InetAddress.getLocalHost();
            this.serverName = this.serverAddress.getHostName();
            int n = this.serverName.indexOf(46);
            this.shortServerName = n == -1 ? this.serverName : this.serverName.substring(0, n);
        }
        catch (UnknownHostException unknownHostException) {
            this.shortServerName = "";
            this.serverName = "";
        }
    }

    public String[] getArguments(String string) throws BridgeException {
        return this.bridge.getArguments(string);
    }

    public DhcpDatastore getDataStore(String string) throws BridgeException {
        return this.bridge.getDataStore(string);
    }

    public String getDataStoreClassname(String string) throws BridgeException {
        String string2 = new String("/usr/sadm/admin/dhcpmgr/");
        String string3 = string2.concat(string).concat(".jar");
        String string4 = null;
        try {
            JarFile jarFile = new JarFile(string3);
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) {
                throw new BridgeException();
            }
            Attributes attributes = manifest.getMainAttributes();
            if (attributes == null) {
                throw new BridgeException();
            }
            string4 = attributes.getValue("Name");
            if (!string4.endsWith(".class")) {
                throw new BridgeException();
            }
            string4 = string4.substring(0, string4.length() - 6);
            string4 = string4.replace('/', '.');
        }
        catch (Throwable throwable) {
            throw new BridgeException();
        }
        return string4;
    }

    public DhcpDatastore[] getDataStores() throws BridgeException {
        return this.bridge.getDataStores();
    }

    public synchronized IPAddress[] getIPOption(String string, String string2) throws BridgeException {
        Option option = OptionsTable.getTable().get(string);
        return this.bridge.getIPOption(option.getCode(), string2);
    }

    public Option[] getInittabOptions(byte by) throws BridgeException {
        return this.bridge.getInittabOptions(by);
    }

    public IPInterface[] getInterfaces() throws BridgeException {
        return this.bridge.getInterfaces();
    }

    public synchronized long[] getNumberOption(String string, String string2) throws BridgeException {
        Option option = OptionsTable.getTable().get(string);
        return this.bridge.getNumberOption(option.getCode(), string2);
    }

    public InetAddress getServerAddress() {
        return this.serverAddress;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getShortServerName() {
        return this.shortServerName;
    }

    public synchronized String getStringOption(String string, String string2) throws BridgeException {
        Option option = OptionsTable.getTable().get(string);
        return this.bridge.getStringOption(option.getCode(), string2);
    }

    public boolean isHostsValid(String string, String string2) {
        return DhcpHostsTable.isHostsValid(string, string2);
    }

    public boolean isServerRunning() throws BridgeException {
        return this.bridge.isServerRunning();
    }

    public boolean isVersionCurrent() throws BridgeException {
        return this.bridge.isVersionCurrent();
    }

    public void makeLocation(DhcpDatastore dhcpDatastore) throws BridgeException {
        this.bridge.makeLocation(dhcpDatastore);
    }

    public DhcpdOptions readDefaults() throws BridgeException {
        return this.bridge.readDefaults();
    }

    public void reload() throws BridgeException {
        this.bridge.reload();
    }

    public void removeDefaults() throws BridgeException {
        this.bridge.removeDefaults();
    }

    public void shutdown() throws BridgeException {
        this.bridge.shutdown();
    }

    public void startup() throws BridgeException {
        this.bridge.startup();
    }

    public void writeDefaults(DhcpdOptions dhcpdOptions) throws BridgeException {
        this.bridge.writeDefaults(dhcpdOptions);
    }
}

