/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.Conduits.MemoSync;

import com.sun.pdasync.Conduits.MemoSync.MemoSyncConduit;
import com.sun.pdasync.Conduits.MemoSync.MemoSyncConstants;
import com.sun.pdasync.Conduits.MemoSync.MemoSyncRecord;
import com.sun.pdasync.Conduits.Utils.DesktopManager;
import com.sun.pdasync.Conduits.Utils.SUNWCategory;
import com.sun.pdasync.SyncUtils.SyncConstants;
import com.sun.pdasync.SyncUtils.SyncUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import palm.conduit.Category;
import palm.conduit.Record;
import palm.conduit.SyncProperties;

public class MemoSyncWriter
implements DesktopManager {
    private static Locale theLocale;
    private static ResourceBundle memoRes;
    private static final String SccsID = "@(#)MemoSyncWriter.java\t1.27 11/10/99 CRT 00911 Bug 4261135";
    private static final String FIELD_DELIMITER = "||";
    private static final String MEMOS_BEGIN = "&&MEMBEG&&";
    private static final String MEMOS_END = "&&MEMEND&&";
    private static final String REC_BEGIN = "&&RECBEGIN&&";
    private static final String REC_DELIMITER = "&&RECDELIM&&";
    private static final String CAT_LIST_BEGIN = "&&CATBEG&&";
    private static final String CAT_LIST_END = "&&CATEND&&";
    private static final String CAT_DELIMITER = "&&CATDELIM&&";
    private static final String LASTSYNCSTAMP_BEGIN = "&&LASTSYNCSTAMPBEG&&";
    private static final String LASTSYNCSTAMP_END = "&&LASTSYNCSTAMPEND&&";
    public static final String MEMO_SUFFIX = ".txt";
    File memoDataFile;
    String dtMemoFilePath;
    SyncProperties props;
    Vector pcRecords;
    static Vector pcCategories;
    Vector renamedCategories;
    static long syncStamp;
    public boolean dataFileExists;
    FileOutputStream out;
    PrintWriter printWriter;

    static {
        try {
            theLocale = Locale.getDefault();
            memoRes = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.MemoSyncConduitMessages", theLocale);
        }
        catch (MissingResourceException e) {
            System.err.println("memosync: can't find properties file");
            System.err.println("memosync:" + e.getMessage());
        }
        syncStamp = 0L;
    }

    public MemoSyncWriter(String memoDataFileName) {
        this.dtMemoFilePath = new String(String.valueOf(MemoSyncConstants.MEMOS_DIR_PATH) + SyncConstants.SEPARATOR + memoDataFileName);
        int index = memoDataFileName.lastIndexOf(".");
        if (index != -1) {
            String frontPart = String.valueOf(MemoSyncConstants.MEMOS_DIR_PATH) + SyncConstants.SEPARATOR + memoDataFileName.substring(0, index);
        } else {
            String frontPart = this.dtMemoFilePath;
        }
        this.memoDataFile = new File(this.dtMemoFilePath);
        if (!this.memoDataFile.exists()) {
            this.dataFileExists = false;
            this.memoDataFile = null;
        } else {
            this.dataFileExists = true;
        }
        pcCategories = null;
        this.pcRecords = null;
        this.renamedCategories = new Vector();
    }

    public void createAndUpdateRecords(Vector dtRecords, Vector dtCategories) throws FileNotFoundException {
        File memoDir = new File(MemoSyncConstants.MEMOS_DIR_PATH);
        String[] memoDirContents = memoDir.list();
        int subdir = 0;
        while (subdir < memoDirContents.length) {
            String subdirPath = String.valueOf(MemoSyncConstants.MEMOS_DIR_PATH) + SyncConstants.SEPARATOR + memoDirContents[subdir];
            File subfile = new File(subdirPath);
            if (subfile.isDirectory()) {
                File oldfile;
                String filename;
                boolean mustMoveToUnfiled = false;
                try {
                    mustMoveToUnfiled = this.populateCategoryList(dtCategories, memoDirContents[subdir]);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                FilenameFilter filter = new FilenameFilter(){

                    public boolean accept(File subfile, String name) {
                        return name.endsWith(MemoSyncWriter.MEMO_SUFFIX);
                    }
                };
                String[] files = subfile.list(filter);
                boolean fileSplit = false;
                FileInputStream fis = null;
                int available = 0;
                int i = 0;
                while (i < files.length) {
                    block23: {
                        block22: {
                            try {
                                fis = new FileInputStream(String.valueOf(subdirPath) + SyncConstants.SEPARATOR + files[i]);
                                if (fis == null) break block22;
                                available = fis.available();
                                fis.close();
                            }
                            catch (IOException iOException) {
                                break block23;
                            }
                        }
                        if (available > 4096) {
                            this.split(MemoSyncConstants.MEMOS_DIR_PATH, memoDirContents[subdir], files[i]);
                            fileSplit = true;
                        }
                    }
                    ++i;
                }
                if (fileSplit) {
                    files = subfile.list(filter);
                }
                int i2 = 0;
                while (i2 < files.length) {
                    filename = String.valueOf(MemoSyncConstants.MEMOS_DIR_PATH) + SyncConstants.SEPARATOR + memoDirContents[subdir] + SyncConstants.SEPARATOR + files[i2];
                    if (mustMoveToUnfiled) {
                        File newfile;
                        String memoFile = "";
                        String newname = String.valueOf(MemoSyncConstants.MEMOS_DIR_PATH) + SyncConstants.SEPARATOR + "Unfiled";
                        File unfiled = new File(newname);
                        if (unfiled != null && !unfiled.exists()) {
                            unfiled.mkdirs();
                        }
                        if ((newfile = new File(newname = String.valueOf(MemoSyncConstants.MEMOS_DIR_PATH) + SyncConstants.SEPARATOR + "Unfiled" + SyncConstants.SEPARATOR + files[i2])) != null && newfile.exists()) {
                            int fileSeqNo = 0;
                            String name = newfile.getName();
                            int dot = name.lastIndexOf(46);
                            if (dot > 0) {
                                name = name.substring(0, dot);
                            }
                            while (newfile.exists()) {
                                memoFile = new String(String.valueOf(MemoSyncConstants.MEMOS_DIR_PATH) + SyncConstants.SEPARATOR + "Unfiled" + SyncConstants.SEPARATOR + name + Integer.toString(fileSeqNo++) + MEMO_SUFFIX);
                                newfile = new File(memoFile);
                            }
                            newname = memoFile;
                        }
                        if ((unfiled = new File(filename)) != null && unfiled.exists()) {
                            unfiled.renameTo(newfile);
                        }
                        filename = newname;
                    }
                    if (!this.inMemoDataFile(filename)) {
                        if (mustMoveToUnfiled) {
                            this.updateOrAddRecordToDtRecords(filename, "Unfiled", dtRecords, dtCategories);
                        } else {
                            this.updateOrAddRecordToDtRecords(filename, memoDirContents[subdir], dtRecords, dtCategories);
                        }
                    }
                    ++i2;
                }
                if (mustMoveToUnfiled && (oldfile = new File(filename = String.valueOf(MemoSyncConstants.MEMOS_DIR_PATH) + SyncConstants.SEPARATOR + memoDirContents[subdir])) != null) {
                    oldfile.delete();
                }
            }
            ++subdir;
        }
        try {
            this.out = new FileOutputStream(this.dtMemoFilePath);
            this.printWriter = new PrintWriter(this.out);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void createCategory(String catName) {
        block2: {
            String dirName = String.valueOf(MemoSyncConstants.MEMOS_DIR_PATH) + SyncConstants.SEPARATOR + catName;
            File dir = new File(dirName);
            if (dir.exists()) break block2;
            try {
                dir.mkdirs();
            }
            catch (Exception exception) {
                MemoSyncConduit.doLog(String.valueOf(memoRes.getString("cannot create memo category ")) + dirName);
            }
        }
    }

    public void createRecord(Record rec) {
        MemoSyncRecord mRec = (MemoSyncRecord)rec;
        mRec.createMemoFile(pcCategories);
    }

    public void deleteAllFiles() {
        this.deleteDataFile();
        this.recursiveDelete(MemoSyncConstants.MEMOS_DIR_PATH);
        if (this.pcRecords != null) {
            this.pcRecords.removeAllElements();
        }
        if (pcCategories != null) {
            pcCategories.removeAllElements();
        }
    }

    public boolean deleteCategory(Category cat) {
        SUNWCategory mCat = (SUNWCategory)cat;
        File dir = new File(mCat.getPath());
        boolean removeSuccess = true;
        if (dir.exists() && dir.isDirectory()) {
            String[] dirContents = dir.list();
            boolean subdir = false;
            int i = 0;
            while (i < dirContents.length) {
                File file = new File(dir, dirContents[i]);
                if (file.isFile()) {
                    if (file.lastModified() < syncStamp) {
                        try {
                            file.delete();
                        }
                        catch (Exception exception) {
                            subdir = true;
                        }
                    } else {
                        removeSuccess = false;
                    }
                } else {
                    subdir = true;
                }
                ++i;
            }
            if (!subdir) {
                dir.delete();
            }
        }
        return true;
    }

    public void deleteDataFile() {
        if (this.memoDataFile != null) {
            this.memoDataFile.delete();
            this.memoDataFile = null;
            this.dataFileExists = false;
        }
    }

    public void deleteRecord(Record rec) {
        MemoSyncRecord mRec = (MemoSyncRecord)rec;
        mRec.deleteMemoFile();
    }

    public static Vector getCategories() {
        return pcCategories;
    }

    public int getCategoryIndexFromVector(String catName, Vector catVec) {
        int i = 0;
        while (i < catVec.size()) {
            SUNWCategory pcCat = (SUNWCategory)catVec.elementAt(i);
            if (pcCat.getName().equals(catName)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private String getCategoryName(Record record, Vector categories) {
        int i = 0;
        while (i < categories.size()) {
            Category category = (Category)categories.elementAt(i);
            if (category.getIndex() == record.getCategoryIndex()) {
                return category.getName();
            }
            ++i;
        }
        return null;
    }

    public String getMemoFilePath() {
        return this.dtMemoFilePath;
    }

    public Vector getRecords() {
        return this.pcRecords;
    }

    private boolean inMemoDataFile(String filename) {
        int j = 0;
        while (j < this.pcRecords.size()) {
            MemoSyncRecord dtRecord = (MemoSyncRecord)((Object)this.pcRecords.elementAt(j));
            String tempFile = dtRecord.getMemoFile();
            if (filename.equals(tempFile)) {
                File dtMemo = new File(filename);
                if (dtMemo.lastModified() > dtRecord.modTime) {
                    dtRecord.setMemoFromFilename(dtRecord.getMemoFile());
                    dtRecord.setIsModified(true);
                    String newName = this.renameToHHName(dtRecord, this.pcRecords);
                    if (newName != null) {
                        dtRecord.setMemoFile(newName);
                    }
                }
                return true;
            }
            ++j;
        }
        return false;
    }

    private void populateCategory(String nameValue, SUNWCategory category) {
        int index = nameValue.indexOf("=");
        if (index != -1) {
            String name = nameValue.substring(0, index);
            String value = nameValue.substring(index + 1);
            if (name.equals("ID")) {
                category.setId(Integer.parseInt(value));
            } else if (name.equals("INDEX")) {
                category.setIndex(Integer.parseInt(value));
            } else if (name.equals("ISMODIFIED") && value.equals("true")) {
                category.setIsModified(true);
            } else if (name.equals("NAME")) {
                category.setName(value);
            }
        }
    }

    public boolean populateCategoryList(Vector catVec, String catName) throws IOException {
        SUNWCategory pcCat;
        int i;
        int highest = 0;
        int used = 0;
        if (catVec.size() == 0) {
            i = 0;
            while (i < 16) {
                pcCat = new SUNWCategory("", 0, i);
                catVec.addElement(pcCat);
                ++i;
            }
            pcCat = (SUNWCategory)catVec.elementAt(0);
            pcCat.setId(0);
            pcCat.setName("Unfiled");
            pcCat.setIndex(0);
            pcCat.setIsModified(true);
        }
        i = 0;
        while (i < catVec.size()) {
            String pcname;
            pcCat = (SUNWCategory)catVec.elementAt(i);
            if (pcCat.getIndex() > highest) {
                highest = pcCat.getIndex();
            }
            if ((pcname = pcCat.getName()).equals("")) break;
            if (pcCat.getName().equals(catName)) {
                return false;
            }
            ++used;
            ++highest;
            ++i;
        }
        if (used >= 16) {
            MemoSyncConduit.doLog(memoRes.getString("category exception: maximum category limit reached"));
            MemoSyncConduit.doLog(memoRes.getString("you can only have a maximum of 16 category directories for your memos"));
            return true;
        }
        pcCat = (SUNWCategory)catVec.elementAt(highest);
        pcCat.setId(highest);
        pcCat.setName(catName);
        pcCat.setIndex(highest);
        pcCat.setIsModified(true);
        pcCat.setPath(String.valueOf(MemoSyncConstants.MEMOS_DIR_PATH) + SyncConstants.SEPARATOR + catName);
        return false;
    }

    private void populateRecord(String nameValue, MemoSyncRecord record) {
        int index = nameValue.indexOf("=");
        if (index != -1) {
            String name = nameValue.substring(0, index);
            String value = nameValue.substring(index + 1);
            boolean valueb = false;
            if (value.equals("true")) {
                valueb = true;
            }
            if (name.equals("ID")) {
                record.setId(Integer.parseInt(value));
            } else if (name.equals("INDEX")) {
                record.setIndex(Integer.parseInt(value));
            } else if (name.equals("CATEGORYID")) {
                record.setCategoryIndex(Integer.parseInt(value));
            } else if (name.equals("ISDELETED")) {
                record.setIsDeleted(valueb);
            } else if (name.equals("ISMODIFIED")) {
                record.setIsModified(valueb);
            } else if (name.equals("ISARCHIVED")) {
                record.setIsArchived(valueb);
            } else if (name.equals("ISNEW")) {
                if (value.equals("true")) {
                    record.setIsNew(true);
                }
            } else if (name.equals("ISPRIVATE")) {
                record.setIsPrivate(valueb);
            } else if (name.equals("MEMO")) {
                record.setMemoFile(value);
                File file = new File(value);
                if (!file.exists()) {
                    record.setIsDeleted(true);
                }
            } else if (name.equals("MODTIME")) {
                record.setModTime(Long.parseLong(value));
            }
        }
    }

    private void processCategories(String memoData) {
        String allCategories = memoData.substring(memoData.indexOf(CAT_LIST_BEGIN) + CAT_LIST_BEGIN.length(), memoData.indexOf(CAT_LIST_END));
        StringTokenizer multiFieldTokenizer = new StringTokenizer(allCategories, CAT_DELIMITER);
        int theindex = allCategories.indexOf(CAT_DELIMITER);
        int theoldindex = 0;
        while (theindex != -1) {
            String multiFieldString = allCategories.substring(theoldindex, theindex);
            if (multiFieldString.indexOf("ID=") != -1) {
                multiFieldString = multiFieldString.substring(multiFieldString.indexOf("ID"));
                SUNWCategory pcCategory = new SUNWCategory();
                StringTokenizer lineTokenizer = new StringTokenizer(multiFieldString, FIELD_DELIMITER);
                while (lineTokenizer.hasMoreElements()) {
                    String nameValue = lineTokenizer.nextToken();
                    this.populateCategory(nameValue, pcCategory);
                }
                pcCategories.addElement(pcCategory);
            }
            theoldindex = theindex + CAT_DELIMITER.length();
            theindex = allCategories.indexOf(CAT_DELIMITER, theoldindex);
        }
        pcCategories.trimToSize();
    }

    private boolean processDataFile() {
        if (pcCategories == null) {
            pcCategories = new Vector(16);
        }
        if (this.pcRecords == null) {
            this.pcRecords = new Vector();
        }
        try {
            int minSize;
            if (this.memoDataFile == null) {
                return false;
            }
            FileInputStream in = new FileInputStream(this.memoDataFile);
            int fileSize = (int)this.memoDataFile.length();
            if (fileSize <= (minSize = MEMOS_BEGIN.getBytes().length + MEMOS_END.getBytes().length + CAT_LIST_BEGIN.getBytes().length + CAT_LIST_END.getBytes().length)) {
                return false;
            }
            byte[] fileBytes = new byte[fileSize];
            int bytesRead = in.read(fileBytes);
            in.close();
            if (bytesRead < fileSize) {
                return false;
            }
            String wholeFile = new String(fileBytes, 0, fileBytes.length);
            pcCategories.removeAllElements();
            this.processCategories(wholeFile);
            this.pcRecords.removeAllElements();
            this.processRecords(wholeFile);
            this.processLastSyncTime(wholeFile);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private void processLastSyncTime(String memoData) {
        int index;
        String nameValue;
        String multiFieldString = "temp";
        if (memoData.indexOf(LASTSYNCSTAMP_BEGIN) < 0 || memoData.lastIndexOf(LASTSYNCSTAMP_END) < 0) {
            syncStamp = 0L;
            return;
        }
        String allRecords = memoData.substring(memoData.indexOf(LASTSYNCSTAMP_BEGIN) + LASTSYNCSTAMP_BEGIN.length(), memoData.lastIndexOf(LASTSYNCSTAMP_END));
        int theindex = allRecords.indexOf(REC_DELIMITER);
        if (theindex < 0) {
            syncStamp = 0L;
            return;
        }
        int theoldindex = 0;
        multiFieldString = allRecords.substring(theoldindex, theindex);
        if (multiFieldString.indexOf("LASTSYNCTIME=") != -1) {
            StringTokenizer lineTokenizer = new StringTokenizer(multiFieldString, FIELD_DELIMITER);
            nameValue = lineTokenizer.nextToken();
            index = nameValue.indexOf("=");
            if (index < 0) {
                syncStamp = 0L;
                return;
            }
        } else {
            syncStamp = 0L;
            return;
        }
        String name = nameValue.substring(0, index);
        String value = nameValue.substring(index + 1);
        syncStamp = Long.parseLong(value);
    }

    private void processRecords(String memoData) {
        String multiFieldString = "temp";
        if (memoData.indexOf(MEMOS_BEGIN) < 0 || memoData.lastIndexOf(MEMOS_END) < 0) {
            this.deleteDataFile();
            return;
        }
        String allRecords = memoData.substring(memoData.indexOf(MEMOS_BEGIN) + MEMOS_BEGIN.length(), memoData.lastIndexOf(MEMOS_END));
        int theindex = allRecords.indexOf(REC_DELIMITER);
        int theoldindex = 0;
        while (theindex != -1) {
            multiFieldString = allRecords.substring(theoldindex, theindex);
            if (multiFieldString.indexOf("ID=") != -1) {
                multiFieldString = multiFieldString.substring(multiFieldString.indexOf("ID"));
                MemoSyncRecord localRecord = new MemoSyncRecord();
                StringTokenizer lineTokenizer = new StringTokenizer(multiFieldString, FIELD_DELIMITER);
                while (lineTokenizer.hasMoreElements()) {
                    String nameValue = lineTokenizer.nextToken();
                    this.populateRecord(nameValue, localRecord);
                }
                this.pcRecords.addElement(localRecord);
            }
            theoldindex = theindex + REC_DELIMITER.length();
            theindex = allRecords.indexOf(REC_DELIMITER, theoldindex);
        }
    }

    public Vector readCategories() {
        if (pcCategories == null || pcCategories.size() == 0) {
            this.processDataFile();
        }
        return pcCategories;
    }

    public Vector readRecords() {
        if (this.pcRecords == null || this.pcRecords.size() == 0) {
            this.processDataFile();
        }
        return this.pcRecords;
    }

    private void recursiveDelete(String path) {
        File file = new File(path);
        String[] fileContents = file.list();
        int i = 0;
        while (i < fileContents.length) {
            File subFile = new File(file, fileContents[i]);
            if (subFile.isDirectory()) {
                this.recursiveDelete(subFile.getPath());
            } else {
                subFile.delete();
            }
            ++i;
        }
        if (!path.equals(MemoSyncConstants.MEMOS_DIR_PATH)) {
            file.delete();
        }
    }

    public void renameCategory(Category cat, String catName) {
        SUNWCategory memoCat = (SUNWCategory)cat;
        String path = memoCat.getPath();
        File dir = new File(path);
        if (dir.exists() && dir.isDirectory()) {
            int lastIndex = path.lastIndexOf(SyncConstants.SEPARATOR);
            String newName = String.valueOf(path.substring(0, lastIndex + 1)) + catName;
            dir.renameTo(new File(newName));
            String[] renamedCat = new String[]{path, newName};
            this.renamedCategories.addElement(renamedCat);
        }
    }

    private String renameToHHName(MemoSyncRecord rec, Vector dtRecords) {
        File oldFile;
        boolean bytesRead = false;
        boolean fileSize = false;
        String oldName = rec.getMemoFile();
        if (oldName == null) {
            return null;
        }
        String contents = rec.getMemo();
        if (contents == null) {
            rec.setMemoFromFilename();
            contents = rec.getMemo();
            oldFile = new File(oldName);
        } else {
            oldFile = new File(rec.getMemoFile());
        }
        if (oldFile == null) {
            return null;
        }
        String newName = contents.length() >= 16 ? contents.substring(0, 16) : contents;
        int indexSubString = newName.indexOf(10);
        if (indexSubString != -1) {
            newName = newName.substring(0, indexSubString);
        }
        newName = newName.trim();
        newName = MemoSyncWriter.replaceInvalidChars(newName);
        String parent = oldFile.getParent();
        if (parent != null) {
            String fullFilename = String.valueOf(parent) + SyncConstants.SEPARATOR + newName + MEMO_SUFFIX;
            if (fullFilename.equals(rec.getMemoFile())) {
                return null;
            }
            int count = 0;
            File newMemo = new File(fullFilename);
            boolean foundDup = true;
            while (foundDup) {
                foundDup = false;
                int i = 0;
                while (i < dtRecords.size()) {
                    MemoSyncRecord dtRecord = (MemoSyncRecord)((Object)dtRecords.elementAt(i));
                    if (dtRecord.getMemoFile() != null) {
                        if (fullFilename.equals(dtRecord.getMemoFile())) {
                            fullFilename = String.valueOf(parent) + SyncConstants.SEPARATOR + newName + count++ + MEMO_SUFFIX;
                            newMemo = new File(fullFilename);
                            i = 0;
                            continue;
                        }
                        ++i;
                        continue;
                    }
                    ++i;
                }
                while (newMemo.exists()) {
                    fullFilename = String.valueOf(parent) + SyncConstants.SEPARATOR + newName + count++ + MEMO_SUFFIX;
                    newMemo = new File(fullFilename);
                    foundDup = true;
                }
            }
            oldFile.renameTo(newMemo);
            rec.setMemoFile(fullFilename);
            return fullFilename;
        }
        return null;
    }

    public static String replaceInvalidChars(String text) {
        String newName = new String(text);
        newName = newName.replace(' ', '_');
        newName = newName.replace('#', '_');
        newName = newName.replace('&', '_');
        newName = newName.replace('\'', '_');
        newName = newName.replace('\t', '_');
        newName = newName.replace('`', '_');
        newName = newName.replace('~', '_');
        newName = newName.replace('@', '_');
        newName = newName.replace('!', '_');
        newName = newName.replace('$', '_');
        newName = newName.replace('%', '_');
        newName = newName.replace('*', '_');
        newName = newName.replace('(', '_');
        return newName;
    }

    public void resetRecCategories() {
        if (this.pcRecords == null || this.pcRecords.size() == 0) {
            return;
        }
        if (pcCategories.size() == 0) {
            return;
        }
        this.updateRenamedCategories();
        int i = 0;
        while (i < this.pcRecords.size()) {
            int end;
            int beg;
            MemoSyncRecord rec = (MemoSyncRecord)((Object)this.pcRecords.elementAt(i));
            String temp = rec.getMemoFile();
            String memCat = temp.substring((beg = temp.lastIndexOf("/", (end = temp.lastIndexOf("/")) - 1)) + 1, end);
            if (memCat != null && memCat.length() != 0) {
                int j = 0;
                while (j < pcCategories.size()) {
                    Category dtCat = (Category)pcCategories.elementAt(j);
                    if (memCat.equals(dtCat.getName())) {
                        rec.setCategoryIndex(j);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public void setCategories(Vector cat) {
        pcCategories = null;
        pcCategories = cat;
    }

    public void setRecords(Vector recs) {
        this.pcRecords = null;
        this.pcRecords = recs;
    }

    private void split(String dir, String category, String value) throws FileNotFoundException {
        String fullname;
        int fileNameLength = 12;
        String filename = dir.concat(String.valueOf(SyncConstants.SEPARATOR) + category + SyncConstants.SEPARATOR + value);
        MemoSyncConduit.doLog("the memo file " + filename + " file size is greater than PalmPilot's memo record size of 800 words.");
        MemoSyncConduit.doLog(String.valueOf(filename) + " memo will be split into smaller memos.");
        File file = new File(filename);
        long size = file.length();
        int recSize = 4096;
        int off = 0;
        byte[] b = new byte[(int)size];
        try {
            FileInputStream fis = new FileInputStream(file);
            fis.read(b, off, (int)size);
            fis.close();
        }
        catch (IOException iOException) {
            throw new FileNotFoundException("File not found " + filename);
        }
        byte[] fileBytes = new byte[fileNameLength];
        int i = 0;
        while (i < fileNameLength) {
            fileBytes[i] = b[i];
            ++i;
        }
        String tempFile = new String(fileBytes);
        String name = new String((tempFile = MemoSyncWriter.replaceInvalidChars(tempFile)).trim());
        if (name.length() < 1) {
            tempFile = new String("temp");
        }
        name = new String(tempFile.trim());
        tempFile = dir.concat(String.valueOf(SyncConstants.SEPARATOR) + category + SyncConstants.SEPARATOR + name);
        int offset = 0;
        int extraBytes = 0;
        int i2 = 0;
        while ((long)i2 < size / (long)recSize + 1L) {
            fullname = new String(String.valueOf(name) + i2 + "\n");
            extraBytes += fullname.length();
            ++i2;
        }
        if ((size + (long)extraBytes) / (long)recSize + 1L > size / (long)recSize + 1L) {
            fullname = new String(String.valueOf(name) + i2 + "\n");
            extraBytes += fullname.length();
        }
        i2 = 0;
        while ((long)i2 < (size + (long)extraBytes) / (long)recSize + 1L) {
            FileOutputStream fos;
            fullname = new String(String.valueOf(tempFile) + i2 + MEMO_SUFFIX);
            String tempname = new String(String.valueOf(name) + i2 + "\n");
            File fileCheck = new File(fullname);
            int count = 0;
            while (fileCheck.exists()) {
                fullname = new String(String.valueOf(MemoSyncConstants.MEMOS_DIR_PATH) + SyncConstants.SEPARATOR + category + SyncConstants.SEPARATOR + name + Integer.toString(count++) + MEMO_SUFFIX);
                fileCheck = new File(fullname);
            }
            try {
                fos = new FileOutputStream(fileCheck);
            }
            catch (IOException iOException) {
                throw new FileNotFoundException("File not created >>" + fullname + "<<");
            }
            try {
                fos.write(tempname.getBytes());
                if (offset + recSize > b.length) {
                    fos.write(b, offset, (int)(size - (long)offset));
                } else {
                    fos.write(b, offset, recSize - tempname.length());
                }
                offset += recSize - tempname.length();
                fos.close();
            }
            catch (IOException iOException) {}
            ++i2;
        }
        file.delete();
    }

    private void updateOrAddRecordToDtRecords(String memoPath, String category, Vector dtRecords, Vector dtCategories) {
        MemoSyncRecord record = new MemoSyncRecord();
        record.setMemoFile(memoPath);
        File mf = new File(memoPath);
        if (mf.length() <= 0L) {
            mf.delete();
            return;
        }
        record.setMemoFromFilename(memoPath);
        String newName = this.renameToHHName(record, dtRecords);
        if (newName != null) {
            record.setMemoFile(newName);
        }
        File file = new File(record.getMemoFile());
        record.modTime = file.lastModified();
        record.setCategoryIndex(this.getCategoryIndexFromVector(category, dtCategories));
        record.setId(0);
        record.setIndex(0);
        record.setIsDeleted(false);
        record.setIsModified(false);
        record.setIsArchived(false);
        record.setIsNew(true);
        record.setIsPrivate(false);
        dtRecords.addElement(record);
    }

    public void updateRenamedCategories() {
        if (this.renamedCategories.size() == 0) {
            return;
        }
        int i = 0;
        while (i < this.pcRecords.size()) {
            MemoSyncRecord localRec = (MemoSyncRecord)((Object)this.pcRecords.elementAt(i));
            String memoFilename = localRec.getMemoFile();
            if (memoFilename != null) {
                int index = memoFilename.lastIndexOf(SyncConstants.SEPARATOR);
                int j = 0;
                while (j < this.renamedCategories.size()) {
                    String[] renameCat = (String[])this.renamedCategories.elementAt(j);
                    if (renameCat[0].equals(memoFilename.substring(0, index))) {
                        localRec.setMemoFile(String.valueOf(renameCat[1]) + SyncConstants.SEPARATOR + SyncUtils.getFileShortName((String)memoFilename));
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.renamedCategories.removeAllElements();
    }

    private void writeCategories() throws IOException {
        if (pcCategories != null) {
            pcCategories.trimToSize();
            this.printWriter.println(CAT_LIST_BEGIN);
            int i = 0;
            while (i < pcCategories.size()) {
                this.printWriter.print(REC_BEGIN);
                Category pcCategory = (Category)pcCategories.elementAt(i);
                this.printWriter.print("ID=" + pcCategory.getId() + FIELD_DELIMITER);
                this.printWriter.print("INDEX=" + pcCategory.getIndex() + FIELD_DELIMITER);
                this.printWriter.print("ISMODIFIED=false||");
                this.printWriter.print("NAME=" + pcCategory.getName() + FIELD_DELIMITER);
                this.printWriter.println(CAT_DELIMITER);
                File catDir = new File(String.valueOf(MemoSyncConstants.MEMOS_DIR_PATH) + SyncConstants.SEPARATOR + pcCategory.getName());
                if (!catDir.exists()) {
                    catDir.mkdirs();
                }
                ++i;
            }
            this.printWriter.println(CAT_LIST_END);
            this.printWriter.flush();
            this.out.flush();
        }
    }

    public void writeData(boolean isItBackup, boolean processRecords) {
        try {
            this.out = new FileOutputStream(this.dtMemoFilePath);
            this.printWriter = new PrintWriter(this.out);
            if (pcCategories != null) {
                this.writeCategories();
            }
            if (this.pcRecords != null) {
                if (processRecords) {
                    this.writeMemos(isItBackup);
                }
                int i = 0;
                while (i < this.pcRecords.size()) {
                    MemoSyncRecord dtRecord = (MemoSyncRecord)((Object)this.pcRecords.elementAt(i));
                    dtRecord.setIsNew(false);
                    dtRecord.setIsDeleted(false);
                    dtRecord.setIsModified(false);
                    dtRecord.setIsArchived(false);
                    ++i;
                }
                this.writeRecords();
            }
            this.printWriter.flush();
            this.printWriter.close();
            this.out.flush();
            this.out.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void writeMemos(boolean isItBackup) throws IOException {
        MemoSyncRecord localRecord = null;
        int i = 0;
        while (i < this.pcRecords.size()) {
            localRecord = (MemoSyncRecord)((Object)this.pcRecords.elementAt(i));
            localRecord.createMemoFile(pcCategories);
            ++i;
        }
    }

    private void writeRecords() throws IOException {
        if (this.pcRecords != null) {
            this.pcRecords.trimToSize();
            this.printWriter.println(MEMOS_BEGIN);
            int i = 0;
            while (i < this.pcRecords.size()) {
                MemoSyncRecord localRecord = (MemoSyncRecord)((Object)this.pcRecords.elementAt(i));
                String memoFile = localRecord.getMemoFile();
                File mf = new File(memoFile);
                this.printWriter.print(REC_BEGIN);
                this.printWriter.print("ID=" + localRecord.getId() + FIELD_DELIMITER);
                this.printWriter.print("INDEX=" + localRecord.getIndex() + FIELD_DELIMITER);
                this.printWriter.print("CATEGORYID=" + localRecord.getCategoryIndex() + FIELD_DELIMITER);
                this.printWriter.print("ISDELETED=false||");
                this.printWriter.print("ISMODIFIED=false||");
                this.printWriter.print("ISARCHIVED=" + localRecord.isArchived() + FIELD_DELIMITER);
                this.printWriter.print("ISNEW=false||");
                this.printWriter.print("ISPRIVATE=" + localRecord.isPrivate() + FIELD_DELIMITER);
                this.printWriter.print("MEMO=" + memoFile + FIELD_DELIMITER);
                this.printWriter.print("MODTIME=" + localRecord.getModTime() + FIELD_DELIMITER);
                this.printWriter.println(REC_DELIMITER);
                ++i;
            }
            this.printWriter.println(MEMOS_END);
            this.printWriter.println(LASTSYNCSTAMP_BEGIN);
            this.printWriter.print(REC_BEGIN);
            syncStamp = System.currentTimeMillis();
            this.printWriter.print("LASTSYNCTIME=" + syncStamp + FIELD_DELIMITER);
            this.printWriter.println(REC_DELIMITER);
            this.printWriter.println(LASTSYNCSTAMP_END);
            this.printWriter.flush();
            this.out.flush();
        }
    }
}

