/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.Conduits.MemoSync;

import com.sun.pdasync.Conduits.MemoSync.MemoSyncConstants;
import com.sun.pdasync.Conduits.MemoSync.MemoSyncWriter;
import com.sun.pdasync.SyncUtils.SyncConstants;
import com.sun.pdasync.SyncUtils.SyncUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import palm.conduit.AbstractRecord;
import palm.conduit.Category;

public class MemoSyncRecord
extends AbstractRecord {
    public String memo;
    public String memoFile;
    long modTime;
    static int fileSeqNo;
    static final int MEMO_FILENAME_LENGTH = 16;
    static int count;
    private static final String SccsID = "%w% 10/13/00 Bug Fix 4262137 CRT 00917";

    static {
        count = 0;
    }

    public void createMemoFile(Vector categories) {
        String category = this.getCategoryName(categories);
        if (this.isArchived() || this.isDeleted()) {
            return;
        }
        this.memoFile = this.createMemoName(categories);
        File fileCheck = new File(this.memoFile);
        String name = fileCheck.getName();
        int dot = name.lastIndexOf(46);
        if (dot > 0) {
            name = name.substring(0, dot);
        }
        try {
            File newFile = new File(this.memoFile);
            count = 0;
            while (newFile.exists()) {
                this.memoFile = new String(String.valueOf(MemoSyncConstants.MEMOS_DIR_PATH) + SyncConstants.SEPARATOR + category + SyncConstants.SEPARATOR + name + Integer.toString(fileSeqNo++) + ".txt");
                newFile = new File(this.memoFile);
            }
            String directory = newFile.getParent();
            File path = new File(directory);
            path.mkdirs();
            FileOutputStream out = new FileOutputStream(newFile);
            byte[] fileBytes = this.memo.getBytes();
            out.write(fileBytes);
            out.close();
            if (this.isPrivate()) {
                SyncUtils.setFilePermission((String)this.memoFile, (String)"600");
            }
            this.modTime = newFile.lastModified();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public String createMemoName(Vector categories) {
        String category = this.getCategoryName(categories);
        String tmp = this.memo.length() >= 16 ? this.memo.substring(0, 16) : this.memo;
        tmp = tmp.replace('/', '_');
        int indexSubString = tmp.indexOf(10);
        tmp = indexSubString != -1 ? MemoSyncWriter.replaceInvalidChars(tmp.substring(0, indexSubString)) : MemoSyncWriter.replaceInvalidChars(tmp);
        String name = new String(String.valueOf(MemoSyncConstants.MEMOS_DIR_PATH) + SyncConstants.SEPARATOR + category + SyncConstants.SEPARATOR + tmp + ".txt");
        return name;
    }

    public void deleteMemoFile() {
        if (this.memoFile == null || this.memoFile.length() == 0) {
            return;
        }
        File mFile = new File(this.memoFile);
        mFile.delete();
    }

    public boolean equals(Object obj) {
        MemoSyncRecord rec = (MemoSyncRecord)((Object)obj);
        if (this.getId() != rec.getId()) {
            return false;
        }
        return this.memo == rec.memo;
    }

    private String getCategoryName(Vector categories) {
        if (categories != null) {
            int i = 0;
            while (i < categories.size()) {
                Category category = (Category)categories.elementAt(i);
                if (category.getIndex() == this.getCategoryIndex()) {
                    return category.getName();
                }
                ++i;
            }
        }
        return "";
    }

    public String getMemo() {
        return this.memo;
    }

    public String getMemoFile() {
        if (this.memoFile == null) {
            this.memoFile = this.createMemoName(MemoSyncWriter.getCategories());
        }
        return this.memoFile;
    }

    public long getModTime() {
        return this.modTime;
    }

    public void readData(DataInputStream in) throws IOException {
        this.memo = AbstractRecord.readCString((DataInputStream)in);
    }

    public void setFileSeqNo(int number) {
        fileSeqNo = number;
    }

    public void setMemo(String contents) {
        this.memo = contents;
    }

    public void setMemoFile(String mFile) {
        this.memoFile = mFile;
    }

    public void setMemoFromFilename() {
        this.setMemoFromFilename(this.memoFile);
    }

    public void setMemoFromFilename(String mFileName) {
        File dataFile = null;
        byte[] fileBytes = null;
        int fileSize = 0;
        int bytesRead = 0;
        FileInputStream in = null;
        if (mFileName == null) {
            this.memo = null;
            return;
        }
        try {
            dataFile = new File(mFileName);
            if (!dataFile.exists()) {
                this.memo = null;
                return;
            }
            in = new FileInputStream(dataFile);
            fileSize = (int)dataFile.length();
            fileBytes = new byte[fileSize];
            bytesRead = in.read(fileBytes);
            in.close();
            if (bytesRead < fileSize) {
                throw new IOException("bytesRead doesnt match fileSize");
            }
            this.memo = new String(fileBytes, 0, fileBytes.length);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void setModTime(long mTime) {
        this.modTime = mTime;
    }

    public String toFormattedString() {
        return "Memo record: {\r\n  memo: " + this.getMemo() + "\r\n" + "}\r\n" + super.toFormattedString();
    }

    public String toString() {
        String theMemo = this.getMemo();
        if (theMemo != null) {
            if (theMemo.length() < 256) {
                return "Memo record: " + theMemo + " " + super.toString();
            }
            return "Memo record: " + theMemo.substring(0, 255) + " " + super.toString();
        }
        if (this.memoFile != null) {
            return "Memo File: " + this.memoFile + " " + super.toString();
        }
        return super.toString();
    }

    public void updateMemoFile(MemoSyncRecord memoRecord, Vector categories, boolean backup) throws IOException {
        File dataFile = null;
        FileOutputStream out = null;
        String categoryName = this.getCategoryName(categories);
        byte[] fileBytes = null;
        if (backup) {
            return;
        }
        try {
            if (dataFile == null && memoRecord.getMemo() != null && this.getMemo() != null) {
                dataFile = new File(memoRecord.getMemoFile());
                if (!dataFile.exists()) {
                    String directory = dataFile.getParent();
                    File path = new File(directory);
                    if (!path.exists()) {
                        path.mkdirs();
                    }
                    dataFile = new File(memoRecord.getMemoFile());
                }
            } else {
                return;
            }
            out = new FileOutputStream(dataFile);
            fileBytes = this.getMemo().getBytes();
            out.write(fileBytes);
            out.close();
            this.memo = memoRecord.getMemo();
            this.memoFile = memoRecord.getMemoFile();
            if (dataFile != null) {
                this.modTime = dataFile.lastModified();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void writeData(DataOutputStream out) throws IOException {
        if (this.memo != null) {
            out.write(this.memo.getBytes());
            out.write(0);
        }
    }
}

