/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.logviewer.client;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.InfoDialog;
import com.sun.admin.cis.common.ListProperties;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.logviewer.client.BackUpPanel;
import com.sun.admin.logviewer.client.Content;
import com.sun.admin.logviewer.client.DeletePanel;
import com.sun.admin.logviewer.client.FetchPanel;
import com.sun.admin.logviewer.client.LogDetails;
import com.sun.admin.logviewer.client.LogFileOpen;
import com.sun.admin.logviewer.client.LogSettings;
import com.sun.admin.logviewer.client.VLogViewer;
import com.sun.admin.logviewer.common.LogRecord;
import com.sun.admin.logviewer.common.ShortDate;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.console.gui.VBusyPanel;
import com.sun.management.viper.console.gui.VFrame;
import com.sun.management.viper.util.ResourceManager;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JToolBar;
import javax.swing.tree.MutableTreeNode;

public class AppContent
extends Content {
    public static final String TYPE_COLUMN = "type_col";
    public static final String DATETIME_COLUMN = "datetime_col";
    public static final String COMPUTER_COLUMN = "computer_col";
    public static final String USER_COLUMN = "user_col";
    public static final String SOURCE_COLUMN = "source_col";
    public static final String CATEGORY_COLUMN = "category_col";
    public static final String SUMMARY_COLUMN = "summary_col";
    private final Object[][] columnHeaderConfig = new Object[][]{{"datetime_col", new Integer(25)}, {"computer_col", new Integer(16)}, {"user_col", new Integer(16)}, {"source_col", new Integer(16)}, {"category_col", new Integer(16)}, {"summary_col", new Integer(16)}};
    private ResourceBundle bundle;
    private ImageIcon smallLogIcon;
    private ImageIcon largeLogIcon;
    private ImageIcon errorLogIcon;
    private ImageIcon infoLogIcon;
    private ImageIcon warnLogIcon;
    private String sortPreferencesKey;
    private static String[][] columnHeaders = null;
    private ListProperties listProperties = null;
    private boolean bRefreshInProgress = false;

    public AppContent(VLogViewer vLogViewer) {
        super(vLogViewer);
        this.bundle = vLogViewer.getResourceBundle();
        this.sortPreferencesKey = String.valueOf(this.getClass().getName()) + ".sortPreferences";
        this.rootNode = new VScopeNode();
        this.rootNode.setColumnHeaders(this.getColumnHeaders());
        this.rootNode.setMenuBar((JMenuBar)vLogViewer.getMenuBar());
        this.rootNode.setToolBar((JToolBar)vLogViewer.getToolBar());
        this.smallLogIcon = vLogViewer.loadImageIcon(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"LogViewer16Gif"));
        this.largeLogIcon = vLogViewer.loadImageIcon(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"LogViewer32Gif"));
        this.errorLogIcon = vLogViewer.loadImageIcon(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"ErrorGif"));
        this.infoLogIcon = vLogViewer.loadImageIcon(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"InfoGif"));
        this.warnLogIcon = vLogViewer.loadImageIcon(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"WarnGif"));
    }

    private void appendToResultsPane(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            VScopeNode vScopeNode = (VScopeNode)enumeration.nextElement();
            this.rootNode.add((MutableTreeNode)vScopeNode);
            LogRecord logRecord = (LogRecord)vScopeNode.getPayload();
            this.vDataCache.addElement(logRecord);
        }
        VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)this.treeNode);
        this.theApp.fireConsoleAction(vConsoleEvent);
    }

    public void backUpFile() {
        BackUpPanel backUpPanel = new BackUpPanel(this.theApp);
        VFrame vFrame = new VFrame();
    }

    public void clear(boolean bl) {
        this.clearSelection();
        this.getDataCache().removeAllElements();
        System.gc();
        this.rootNode.removeAllChildren();
        if (this.treeNode.getInternalRoot() == null) {
            this.treeNode.setInternalRoot(this.rootNode);
        }
        if (bl) {
            VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)this.treeNode);
            this.theApp.fireConsoleAction(vConsoleEvent);
        }
        this.bRefresh = true;
    }

    public Vector createNodes(Vector vector) {
        Vector<VScopeNode> vector2 = new Vector<VScopeNode>(vector.size());
        String string = ResourceManager.getLocalizedTextFile((String)"html/lm_ctx_main.html", this.theApp.getClass());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            LogRecord logRecord = (LogRecord)enumeration.nextElement();
            ImageIcon imageIcon = this.infoLogIcon;
            if (logRecord.getSeverity() == 2) {
                imageIcon = this.errorLogIcon;
            } else if (logRecord.getSeverity() == 1) {
                imageIcon = this.warnLogIcon;
            }
            VScopeNode vScopeNode = new VScopeNode(null, null, null, null, null, this.theApp.getMenuBar().getPopupMenu(), imageIcon, imageIcon, ResourceStrings.getString((ResourceBundle)this.bundle, (String)"log_col"), null, null, -1, (Object)logRecord);
            vScopeNode.setHTMLText(string);
            vScopeNode.setColumnValues(AppContent.getColumnValues(this.bundle, logRecord));
            vector2.addElement(vScopeNode);
        }
        this.updateStatusBar(vector2.size());
        return vector2;
    }

    public void deleteSelected() {
        DeletePanel deletePanel = new DeletePanel(this.theApp);
        VFrame vFrame = new VFrame();
    }

    public String[][] getColumnHeaders() {
        if (columnHeaders == null) {
            columnHeaders = this.constructColumnHeaders(this.columnHeaderConfig);
        }
        return columnHeaders;
    }

    public static Hashtable getColumnValues(ResourceBundle resourceBundle, LogRecord logRecord) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        String string = columnHeaders[0][0];
        ShortDate shortDate = logRecord.getDateTime();
        hashtable.put(string, shortDate);
        string = columnHeaders[1][0];
        hashtable.put(string, logRecord.getClientHostName());
        string = columnHeaders[2][0];
        hashtable.put(string, logRecord.getUserName());
        string = columnHeaders[3][0];
        hashtable.put(string, logRecord.getAppName());
        string = columnHeaders[4][0];
        hashtable.put(string, logRecord.getCategoryString());
        string = columnHeaders[5][0];
        hashtable.put(string, logRecord.getSummaryMesg(false));
        return hashtable;
    }

    public String getSortAttribute() {
        return null;
    }

    public synchronized boolean isRefreshInProgress() {
        return this.bRefreshInProgress;
    }

    public void openFile() {
        this.bRefresh = false;
        VFrame vFrame = new VFrame();
        LogFileOpen logFileOpen = new LogFileOpen(this.theApp);
        logFileOpen.setContainer((Component)vFrame);
        vFrame.showCenter((Component)this.theApp.getProperties().getPropertyObject("vconsole.frame"));
        logFileOpen.setVisible(true);
    }

    public void openSelected() {
        Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        VScopeNode vScopeNode = (VScopeNode)vector.elementAt(0);
        VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.theApp, "vconsole.scopeselected", (Object)vScopeNode);
        this.theApp.fireConsoleAction(vConsoleEvent);
    }

    public void preFilter() {
        FetchPanel fetchPanel = new FetchPanel(this.theApp);
        ActionListener actionListener = fetchPanel.getOKListener();
        ActionListener actionListener2 = fetchPanel.getFilterListener();
        ActionListener actionListener3 = fetchPanel.getCancelListener();
        VFrame vFrame = new VFrame();
        InfoDialog infoDialog = new InfoDialog((JFrame)vFrame, ResourceStrings.getString((ResourceBundle)this.bundle, (String)"fetch_title"), (JPanel)fetchPanel, actionListener, actionListener2, actionListener3);
    }

    public void refresh() {
        final ResourceBundle resourceBundle = this.theApp.getResourceBundle();
        if (!this.isRefreshInProgress()) {
            this.setRefreshInProgress(true);
            Thread thread = new Thread(){

                public void run() {
                    theApp.waitOn();
                    vDataCache.removeAllElements();
                    System.gc();
                    this.clear(false);
                    theApp.setInfoBar("");
                    String string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"FetchLogTitle");
                    JProgressBar jProgressBar = new JProgressBar(0, 100);
                    jProgressBar.setValue(0);
                    treeNode.setResultPane((Component)new VBusyPanel(string));
                    theApp.fireConsoleAction(new VConsoleEvent((Object)theApp, "vconsole.updatescope", (Object)treeNode));
                    theApp.setStatusBar(string);
                    theApp.fireConsoleAction(new VConsoleEvent((Object)theApp, "vconsole.updateprogress", null));
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {}
                    String string2 = "";
                    try {
                        string2 = theApp.getLogViewer().getCurrentLogFileName();
                    }
                    catch (AdminException adminException) {}
                    theApp.getMenuBar().setDeleteEnabled(theApp.getFileName().equals(string2) ^ true);
                    Vector vector = this.createNodes(theApp.getRowHeaders());
                    theApp.setStatusBar(ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"FetchLogDone"));
                    if (jProgressBar.getValue() == 0) {
                        treeNode.setResultPane(null);
                        theApp.fireConsoleAction(new VConsoleEvent((Object)theApp, "vconsole.updatescope", (Object)treeNode));
                    }
                    this.updateInfoBar();
                    theApp.fireConsoleAction(new VConsoleEvent((Object)theApp, "vconsole.updateprogress", null));
                    theApp.waitOff();
                    if (jProgressBar.getValue() == 0) {
                        treeNode.setResultPane(null);
                    }
                    this.appendToResultsPane(vector);
                    bRefresh = true;
                    this.showFilteredStatus();
                    theApp.waitOff();
                    this.setRefreshInProgress(false);
                }
            };
            thread.start();
        }
    }

    public void saveSortPreferences() {
        VConsoleProperties vConsoleProperties = this.theApp.getProperties();
        vConsoleProperties.setProperty(this.sortPreferencesKey, vConsoleProperties.getProperty("vconsole.sortedcolumn"));
    }

    public void setDefaultColumnHeader() {
        ResourceBundle resourceBundle = this.theApp.getResourceBundle();
        VConsoleProperties vConsoleProperties = this.theApp.getProperties();
        vConsoleProperties.setProperty("vconsole.defaultcolumnheader", ResourceStrings.getString((ResourceBundle)resourceBundle, (String)TYPE_COLUMN));
    }

    private void setRefreshInProgress(boolean bl) {
        this.bRefreshInProgress = bl;
    }

    public void updateInfoBar() {
        ResourceBundle resourceBundle = this.theApp.getResourceBundle();
        String string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"LogListContents");
        Object[] objectArray = new Object[]{new Integer(this.getDataCache().size())};
        String string2 = MessageFormat.format(string, objectArray);
        this.theApp.setInfoBar(string2);
    }

    public void updateSortPreferences() {
        VConsoleProperties vConsoleProperties = this.theApp.getProperties();
        String string = vConsoleProperties.getProperty(this.sortPreferencesKey);
        if (string == null || string.equals("null")) {
            return;
        }
        String string2 = "vconsole.sortup";
        if (string.indexOf(45) >= 0) {
            string2 = "vconsole.sortdown";
        }
        Integer[] integerArray = new Integer[1];
        try {
            int n = Integer.parseInt(string.substring(1));
            integerArray[0] = new Integer(n);
        }
        catch (Exception exception) {
            integerArray[0] = new Integer(0);
        }
        VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.theApp, string2, (Object)integerArray);
        this.theApp.fireConsoleAction(vConsoleEvent);
        vConsoleProperties.setProperty("vconsole.sortedcolumn", string);
    }

    public void updateStatusBar(int n) {
        String string = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"logs");
        Object[] objectArray = new Object[]{new Integer(n)};
        String string2 = MessageFormat.format(string, objectArray);
        this.theApp.setStatusBar(string2);
    }

    public void viewDetails() {
        VScopeNode vScopeNode = this.getSelectedNode();
        LogRecord logRecord = (LogRecord)vScopeNode.getPayload();
        final VFrame vFrame = new VFrame();
        LogDetails logDetails = new LogDetails(this.theApp, logRecord);
        this.theApp.setDetailsEnabled(false);
        logDetails.setContainer((Component)vFrame);
        vFrame.showCenter((Component)this.theApp.getProperties().getPropertyObject("vconsole.frame"));
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AppContent.this.theApp.setDetailsEnabled(true);
                vFrame.close();
            }
        };
        vFrame.addWindowListener(windowAdapter);
        logDetails.setVisible(true);
    }

    public void viewSettings() {
        VFrame vFrame = new VFrame();
        LogSettings logSettings = new LogSettings(this.theApp);
        logSettings.setContainer((Component)vFrame);
        vFrame.showCenter((Component)this.theApp.getProperties().getPropertyObject("vconsole.frame"));
        logSettings.setVisible(true);
    }

    public String whatAmI() {
        return "logviewer root node";
    }
}

