/*
 * Decompiled with CFR 0.152.
 */
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Flags {
    private int flags = 0;
    private static int allOnes = 65535;
    public static final int DISALLOW_POSTDATED = 1;
    public static final int DISALLOW_FORWARDABLE = 2;
    public static final int DISALLOW_TGT_BASED = 4;
    public static final int DISALLOW_RENEWABLE = 8;
    public static final int DISALLOW_PROXIABLE = 16;
    public static final int DISALLOW_DUP_SKEY = 32;
    public static final int DISALLOW_ALL_TIX = 64;
    public static final int REQUIRE_PRE_AUTH = 128;
    public static final int REQUIRE_HW_AUTH = 256;
    public static final int REQUIRES_PWCHANGE = 512;
    public static final int DISALLOW_SVR = 4096;
    private static int[] bitfields = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 4096};
    private static String[] flagNames = new String[]{"Allow Postdated Tickets", "Allow Forwardable Tickets", "Allow TGT-Based Authentication", "Allow Renewable Tickets", "Allow Proxiable Tickets", "Allow Duplicate Authentication", "Disable Account", "Require Preauthentication", "Require Hardware Preauthentication", "Require Password Change", "Allow Service Tickets"};
    private static ResourceBundle rb = ResourceBundle.getBundle("GuiResource");

    public Flags() {
    }

    public Flags(int n) {
        this.flags = n;
    }

    private static final String getString(String string) {
        try {
            String string2 = rb.getString(string);
            return string2;
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println("Missing resource " + string + ", using English.");
            return string;
        }
    }

    public static final String getLabel(int n) {
        int n2 = Flags.getIndex(n);
        if (n2 < 0) {
            return null;
        }
        return Flags.getString(flagNames[n2]);
    }

    public boolean getFlag(int n) {
        return (this.flags & n) != 0;
    }

    public void setFlags(int n, boolean bl) {
        this.flags = !bl ? (this.flags &= (n ^= allOnes)) : (this.flags |= n);
    }

    public void toggleFlags(int n) {
        this.flags ^= n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        char c = !this.getFlag(1) ? (char)'+' : '-';
        stringBuffer.append('\t').append(c).append(Flags.getString(flagNames[0])).append('\n');
        c = !this.getFlag(2) ? (char)'+' : '-';
        stringBuffer.append('\t').append(c).append(Flags.getString(flagNames[1])).append('\n');
        c = !this.getFlag(4) ? (char)'+' : '-';
        stringBuffer.append('\t').append(c).append(Flags.getString(flagNames[2])).append('\n');
        c = !this.getFlag(8) ? (char)'+' : '-';
        stringBuffer.append('\t').append(c).append(Flags.getString(flagNames[3])).append('\n');
        c = !this.getFlag(16) ? (char)'+' : '-';
        stringBuffer.append('\t').append(c).append(Flags.getString(flagNames[4])).append('\n');
        c = !this.getFlag(32) ? (char)'+' : '-';
        stringBuffer.append('\t').append(c).append(Flags.getString(flagNames[5])).append('\n');
        c = this.getFlag(64) ? (char)'+' : '-';
        stringBuffer.append('\t').append(c).append(Flags.getString(flagNames[6])).append('\n');
        c = this.getFlag(128) ? (char)'+' : '-';
        stringBuffer.append('\t').append(c).append(Flags.getString(flagNames[7])).append('\n');
        c = this.getFlag(256) ? (char)'+' : '-';
        stringBuffer.append('\t').append(c).append(Flags.getString(flagNames[8])).append('\n');
        c = this.getFlag(512) ? (char)'+' : '-';
        stringBuffer.append('\t').append(c).append(Flags.getString(flagNames[9])).append('\n');
        c = !this.getFlag(4096) ? (char)'+' : '-';
        stringBuffer.append('\t').append(c).append(Flags.getString(flagNames[10])).append('\n');
        return stringBuffer.toString();
    }

    private static int getIndex(int n) {
        for (int i = 0; i < flagNames.length; ++i) {
            if (n != bitfields[i]) continue;
            return i;
        }
        return -1;
    }

    public int getBits() {
        return this.flags;
    }
}

