/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class DCPanel
extends Panel {
    private Button plusButton;
    private Button minusButton;
    private DCListener listener = null;
    private Timer bigTimer;
    private Timer smallTimer;
    private static int BIG_SLEEP_TIME = 1000;
    private static int SMALL_SLEEP_TIME = 100;
    private boolean incrementFlag;

    public DCPanel() {
        this.setLayout(new GridLayout(1, 2));
        this.bigTimer = new BigTimer();
        this.smallTimer = new SmallTimer();
        this.bigTimer.start();
        this.smallTimer.start();
        this.plusButton = new DCButton("+");
        this.minusButton = new DCButton("-");
        this.add(this.plusButton);
        this.add(this.minusButton);
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public DCListener setListener(DCListener dCListener) {
        DCListener dCListener2 = this.listener;
        this.listener = dCListener;
        return dCListener2;
    }

    public DCListener removeListener() {
        return this.setListener(null);
    }

    private void startAction() {
        this.bigTimer.request();
    }

    private void stopAction() {
        this.smallTimer.cancel();
        this.bigTimer.cancel();
    }

    private void informListener(boolean bl) {
        if (this.listener != null) {
            if (bl) {
                if (this.incrementFlag) {
                    this.listener.bigIncrement();
                } else {
                    this.listener.bigDecrement();
                }
            } else if (this.incrementFlag) {
                this.listener.increment();
            } else {
                this.listener.decrement();
            }
        }
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame("Testing DCPanel");
        frame.add(new DCPanel());
        frame.setBounds(new Rectangle(100, 100, 100, 100));
        frame.setVisible(true);
    }

    private class DCButton
    extends Button {
        public DCButton(String string) {
            super(string);
            if (string.equals("+")) {
                this.addMouseListener(new DCMouseListener(true));
            } else {
                this.addMouseListener(new DCMouseListener(false));
            }
        }

        public boolean isFocusTraversable() {
            return false;
        }
    }

    private class DCMouseListener
    extends MouseAdapter {
        private boolean plusOrMinus;

        public DCMouseListener(boolean bl) {
            this.plusOrMinus = bl;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            DCPanel.this.incrementFlag = this.plusOrMinus;
            DCPanel.this.startAction();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            DCPanel.this.incrementFlag = this.plusOrMinus;
            DCPanel.this.stopAction();
        }
    }

    private class SmallTimer
    extends Timer {
        private SmallTimer() {
        }

        protected void doTask() {
            try {
                while (true) {
                    SmallTimer.sleep(SMALL_SLEEP_TIME);
                    DCPanel.this.informListener(true);
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    private class BigTimer
    extends Timer {
        private BigTimer() {
        }

        protected void doTask() {
            try {
                BigTimer.sleep(BIG_SLEEP_TIME);
                DCPanel.this.informListener(true);
                DCPanel.this.smallTimer.request();
            }
            catch (InterruptedException interruptedException) {
                DCPanel.this.informListener(false);
            }
        }
    }

    private abstract class Timer
    extends Thread {
        private boolean running = false;

        private Timer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Timer timer = this;
                        synchronized (timer) {
                            this.running = false;
                            this.wait();
                            this.running = true;
                        }
                        this.doTask();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        protected void doTask() {
        }

        public synchronized void request() {
            this.notify();
        }

        public void cancel() {
            if (this.running) {
                this.interrupt();
            }
        }
    }
}

