/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.type;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import sunsoft.jws.visual.rt.base.Global;
import sunsoft.jws.visual.rt.type.DoneException;
import sunsoft.jws.visual.rt.type.IntHolder;
import sunsoft.jws.visual.rt.type.ParseException;

public class ListParser {
    private static final char CHAR_a = 'a';
    private static final char CHAR_b = 'b';
    private static final char CHAR_f = 'f';
    private static final char CHAR_n = 'n';
    private static final char CHAR_r = 'r';
    private static final char CHAR_t = 't';
    private static final char CHAR_x = 'x';
    private static final char CHAR_A = 'A';
    private static final char CHAR_F = 'F';
    private static final char BACKSLASH = '\\';
    private static final char BACKSPACE = '\b';
    private static final char DQUOTE = '\"';
    private static final char EQUALS = '=';
    private static final char FORMFEED = '\f';
    private static final char LBRACE = '{';
    private static final char NEWLINE = '\n';
    private static final char NINE = '9';
    private static final char NULL = '\u0000';
    private static final char RBRACE = '}';
    private static final char RETURN = '\r';
    private static final char SPACE = ' ';
    private static final char TAB = '\t';
    private static final char ZERO = '0';
    private Vector list;
    private int elementIndex;
    private int nextIndex;
    private int elementSize;
    private boolean brace;
    private static final int TCL_DONT_USE_BRACES = 1;
    private static final int USE_BRACES = 2;
    private static final int BRACES_UNMATCHED = 4;
    private static final String indentString = "  ";

    public ListParser(String string) {
        int n = 0;
        int n2 = string.length();
        this.initList(string, n, n2);
    }

    public ListParser(String string, int n) {
        int n2 = string.length();
        int n3 = n >= 0 && n < n2 ? n : n2;
        this.initList(string, n3, n2);
    }

    public ListParser(String string, int n, int n2) {
        int n3 = string.length();
        if (n2 < 0 || n2 > n3) {
            n2 = n3;
        }
        if (n < 0) {
            n = 0;
        }
        if (n > n2) {
            n = n2;
        }
        this.initList(string, n, n2);
    }

    public Enumeration elements() {
        return this.list.elements();
    }

    public int size() {
        return this.list.size();
    }

    private void initList(String string, int n, int n2) {
        this.list = new Vector();
        int n3 = n2 - n;
        char[] cArray = new char[n3];
        string.getChars(n, n2, cArray, 0);
        this.parseList(this.list, cArray);
    }

    private void parseList(Vector vector, char[] cArray) {
        this.nextIndex = 0;
        while (this.nextIndex < cArray.length && cArray[this.nextIndex] != '\u0000') {
            try {
                this.findElement(cArray, this.nextIndex);
            }
            catch (ParseException parseException) {
                vector.removeAllElements();
                throw parseException;
            }
            if (this.elementSize == 0 && (this.elementIndex >= cArray.length || cArray[this.elementIndex] == '\u0000')) continue;
            if (this.brace) {
                vector.addElement(new String(cArray, this.elementIndex, this.elementSize));
                continue;
            }
            vector.addElement(this.collapse(cArray, this.elementIndex, this.elementSize));
        }
    }

    private void findElement(char[] cArray, int n) {
        int n2;
        int n3;
        int n4 = 0;
        boolean bl = false;
        int n5 = 0;
        for (n3 = n; n3 < cArray.length && Character.isSpace(cArray[n3]); ++n3) {
        }
        if (n3 < cArray.length && cArray[n3] == '{') {
            n4 = 1;
            ++n3;
        } else if (n3 < cArray.length && cArray[n3] == '\"') {
            bl = true;
            ++n3;
        }
        this.brace = n4 == 1;
        try {
            while (true) {
                char c = n2 < cArray.length ? cArray[n2] : (char)'\u0000';
                switch (c) {
                    case '{': {
                        if (n4 == 0) break;
                        ++n4;
                        break;
                    }
                    case '}': {
                        if (n4 == 1) {
                            int n6;
                            n5 = n2 - n3;
                            if (++n2 >= cArray.length || cArray[n2] == '\u0000' || Character.isSpace(cArray[n2])) {
                                throw new DoneException();
                            }
                            for (n6 = n2; n6 < cArray.length && cArray[n6] != '\u0000' && !Character.isSpace(cArray[n6]) && n6 < n2 + 20; ++n6) {
                            }
                            String string = new String(cArray, n2, n6 - n2);
                            throw new ParseException(Global.fmtMsg("sunsoft.jws.visual.rt.type.ListParser.SpaceExpected", String.valueOf(cArray, n2, n6 - n2)));
                        }
                        if (n4 == 0) break;
                        --n4;
                        break;
                    }
                    case '\\': {
                        IntHolder intHolder = new IntHolder();
                        ListParser.backslash(cArray, n2, intHolder);
                        n2 += intHolder.value - 1;
                        break;
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        if (n4 != 0 || bl) break;
                        n5 = n2 - n3;
                        throw new DoneException();
                    }
                    case '\"': {
                        int n7;
                        if (!bl) break;
                        n5 = n2 - n3;
                        if (++n2 >= cArray.length || cArray[n2] == '\u0000' || Character.isSpace(cArray[n2])) {
                            throw new DoneException();
                        }
                        for (n7 = n2; n7 < cArray.length && cArray[n7] != '\u0000' && !Character.isSpace(cArray[n7]) && n7 < n2 + 20; ++n7) {
                        }
                        throw new ParseException(Global.fmtMsg("sunsoft.jws.visual.rt.type.ListParser.SpaceExpected2", String.valueOf(cArray, n2, n7 - n2), String.valueOf(cArray, n2, cArray.length - 1)));
                    }
                    case '\u0000': {
                        if (n4 != 0) {
                            throw new ParseException(Global.getMsg("sunsoft.jws.visual.rt.type.ListParser.UnmatchedBrace"));
                        }
                        if (bl) {
                            throw new ParseException(Global.getMsg("sunsoft.jws.visual.rt.type.ListParser.UnmatchedQuote"));
                        }
                        n5 = n2 - n3;
                        throw new DoneException();
                    }
                }
                ++n2;
            }
        }
        catch (DoneException doneException) {
            for (n2 = n3; n2 < cArray.length && Character.isSpace(cArray[n2]); ++n2) {
            }
            this.elementIndex = n3;
            this.nextIndex = n2;
            this.elementSize = n5;
            return;
        }
    }

    private String collapse(char[] cArray, int n, int n2) {
        int n3 = n;
        IntHolder intHolder = new IntHolder();
        char[] cArray2 = new char[cArray.length + 1];
        int n4 = 0;
        while (n2 > 0) {
            char c = n3 < cArray.length ? cArray[n3] : (char)'\u0000';
            if (c == '\\') {
                cArray2[n4] = ListParser.backslash(cArray, n3, intHolder);
                ++n4;
                n3 += intHolder.value - 1;
                n2 -= intHolder.value - 1;
            } else {
                cArray2[n4] = c;
                ++n4;
            }
            ++n3;
            --n2;
        }
        cArray2[n4] = '\u0000';
        return new String(cArray2, 0, n4);
    }

    private static char backslash(char[] cArray, int n, IntHolder intHolder) {
        int n2;
        int n3 = n + 1;
        int n4 = 2;
        char c = n3 < cArray.length ? cArray[n3] : (char)'\u0000';
        switch (c) {
            case 'a': {
                n2 = 7;
                break;
            }
            case 'b': {
                n2 = 8;
                break;
            }
            case 'f': {
                n2 = 12;
                break;
            }
            case 'n': {
                n2 = 10;
                break;
            }
            case 'r': {
                n2 = 13;
                break;
            }
            case 't': {
                n2 = 9;
                break;
            }
            case 'x': {
                if (ListParser.isxdigit(cArray[n3 + 1])) {
                    int n5 = n3 + 1;
                    while (ListParser.isxdigit(cArray[n5])) {
                        ++n5;
                    }
                    n2 = (char)Integer.parseInt(String.valueOf(cArray, n3 + 1, n5), 16);
                    n4 = n5 - n;
                    break;
                }
                n4 = 2;
                n2 = 120;
                break;
            }
            case '\n': {
                while (cArray[++n3] == ' ' || cArray[n3] == '\t') {
                }
                n2 = 32;
                n4 = n3 - n;
                break;
            }
            case '\u0000': {
                n2 = 92;
                n4 = 1;
                break;
            }
            default: {
                if (ListParser.isdigit(cArray[n3])) {
                    n2 = (char)(cArray[n3] - 48);
                    if (!ListParser.isdigit(cArray[++n3])) break;
                    n4 = 3;
                    n2 = (char)((n2 << 3) + (cArray[n3] - 48));
                    if (!ListParser.isdigit(cArray[++n3])) break;
                    n4 = 4;
                    n2 = (char)((n2 << 3) + (cArray[n3] - 48));
                    break;
                }
                n2 = cArray[n3];
                n4 = 2;
            }
        }
        if (intHolder != null) {
            intHolder.value = n4;
        }
        return (char)n2;
    }

    private static int scanElement(char[] cArray, IntHolder intHolder) {
        int n;
        int n2 = 0;
        int n3 = 0;
        if (cArray == null) {
            cArray = new char[]{};
        }
        if ((n = 0) >= cArray.length || cArray[n] == '{' || cArray[n] == '\"' || cArray[n] == '\u0000') {
            n3 |= 2;
        }
        while (n < cArray.length && cArray[n] != '\u0000') {
            switch (cArray[n]) {
                case '{': {
                    ++n2;
                    break;
                }
                case '}': {
                    if (--n2 >= 0) break;
                    n3 |= 5;
                    break;
                }
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    n3 |= 2;
                    break;
                }
                case '\\': {
                    if (cArray[n + 1] == '\u0000' || cArray[n + 1] == '\n') {
                        n3 = 1;
                        break;
                    }
                    IntHolder intHolder2 = new IntHolder();
                    ListParser.backslash(cArray, n, intHolder2);
                    n += intHolder2.value - 1;
                    n3 |= 2;
                }
            }
            ++n;
        }
        if (n2 != 0) {
            n3 = 5;
        }
        intHolder.value = n3;
        return 2 * n + 2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int convertElement(char[] cArray, char[] cArray2, int n) {
        int n2;
        block13: {
            block12: {
                n2 = 0;
                if (cArray == null || cArray.length == 0) {
                    cArray2[n2] = 123;
                    cArray2[n2 + 1] = 125;
                    cArray2[n2 + 2] = '\u0000';
                    return 2;
                }
                if ((n & 2) == 0 || (n & 1) != 0) break block12;
                cArray2[n2] = 123;
                ++n2;
                for (int i = 0; i < cArray.length && cArray[i] != '\u0000'; ++n2, ++i) {
                    cArray2[n2] = cArray[i];
                }
                cArray2[n2] = 125;
                ++n2;
                break block13;
            }
            int n3 = 0;
            if (cArray[n3] == '{') {
                cArray2[n2] = 92;
                cArray2[n2 + 1] = 123;
                n2 += 2;
                ++n3;
                n |= 4;
            }
            while (n3 < cArray.length && cArray[n3] != '\u0000') {
                block14: {
                    switch (cArray[n3]) {
                        case ' ': 
                        case '\"': 
                        case '\\': {
                            cArray2[n2] = 92;
                            ++n2;
                            break;
                        }
                        case '{': 
                        case '}': {
                            if ((n & 4) == 0) break;
                            cArray2[n2] = 92;
                            ++n2;
                            break;
                        }
                        case '\f': {
                            cArray2[n2] = 92;
                            cArray2[++n2] = 102;
                            ++n2;
                            break block14;
                        }
                        case '\n': {
                            cArray2[n2] = 92;
                            cArray2[++n2] = 110;
                            ++n2;
                            break block14;
                        }
                        case '\r': {
                            cArray2[n2] = 92;
                            cArray2[++n2] = 114;
                            ++n2;
                            break block14;
                        }
                        case '\t': {
                            cArray2[n2] = 92;
                            cArray2[++n2] = 116;
                            ++n2;
                            break block14;
                        }
                    }
                    cArray2[n2] = cArray[n3];
                    ++n2;
                }
                ++n3;
            }
        }
        cArray2[n2] = '\u0000';
        return n2;
    }

    public static String list(String string) {
        char[] cArray = string.toCharArray();
        IntHolder intHolder = new IntHolder();
        int n = ListParser.scanElement(cArray, intHolder);
        char[] cArray2 = new char[n + 1];
        n = ListParser.convertElement(cArray, cArray2, intHolder.value);
        return new String(cArray2, 0, n);
    }

    public static void list(String string, StringBuffer stringBuffer) {
        char[] cArray = string.toCharArray();
        IntHolder intHolder = new IntHolder();
        int n = ListParser.scanElement(cArray, intHolder);
        char[] cArray2 = new char[n + 1];
        n = ListParser.convertElement(cArray, cArray2, intHolder.value);
        stringBuffer.append(cArray2, 0, n);
    }

    public static String quote(String string, boolean bl) {
        char[] cArray = string.toCharArray();
        char[] cArray2 = ListParser.quote(cArray, bl);
        return new String(cArray2);
    }

    public static void quote(String string, StringBuffer stringBuffer, boolean bl) {
        char[] cArray = string.toCharArray();
        char[] cArray2 = ListParser.quote(cArray, bl);
        stringBuffer.append(cArray2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static char[] quote(char[] cArray, boolean bl) {
        int n;
        boolean bl2;
        int n2 = 0;
        if (cArray.length == 0) {
            bl2 = true;
        } else {
            bl2 = false;
            if (!bl && cArray[0] == '{' && cArray[cArray.length - 1] == '}') {
                return cArray;
            }
        }
        block14: for (n = 0; n < cArray.length; ++n) {
            switch (cArray[n]) {
                case '\t': 
                case ' ': 
                case '{': 
                case '}': {
                    bl2 = true;
                    continue block14;
                }
                case '\"': 
                case '\\': {
                    bl2 = true;
                    ++n2;
                    continue block14;
                }
                case '\n': 
                case '\f': 
                case '\r': {
                    bl2 = true;
                    if (!bl) continue block14;
                    ++n2;
                    continue block14;
                }
            }
        }
        n = cArray.length + n2;
        if (bl2 || bl) {
            n += 2;
        }
        char[] cArray2 = new char[n];
        int n3 = 0;
        if (bl2 || bl) {
            cArray2[n3++] = 34;
        }
        block15: for (int i = 0; i < cArray.length; ++i) {
            switch (cArray[i]) {
                case '\"': 
                case '\\': {
                    cArray2[n3++] = 92;
                    break;
                }
                case '\n': 
                case '\f': 
                case '\r': {
                    if (!bl) break;
                    cArray2[n3++] = 92;
                    switch (cArray[i]) {
                        case '\f': {
                            cArray2[n3++] = 102;
                            break;
                        }
                        case '\r': {
                            cArray2[n3++] = 114;
                            break;
                        }
                        case '\n': {
                            cArray2[n3++] = 110;
                            break;
                        }
                    }
                    continue block15;
                }
            }
            cArray2[n3++] = cArray[i];
        }
        if (bl2 || bl) {
            cArray2[n3++] = 34;
        }
        return cArray2;
    }

    public static String newline() {
        return Global.newline();
    }

    public static void newline(StringBuffer stringBuffer) {
        Global.newline(stringBuffer);
    }

    public static void indent(StringBuffer stringBuffer, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(indentString);
        }
    }

    public static boolean isdigit(char c) {
        return Character.isDigit(c);
    }

    public static boolean isxdigit(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    public static Enumeration getListElements(String string, int n) {
        ListParser listParser = new ListParser(string);
        return listParser.elements();
    }

    public static Hashtable makeListTable(String string) {
        Enumeration enumeration = ListParser.getListElements(string, 2);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        while (enumeration.hasMoreElements()) {
            try {
                hashtable.put((String)enumeration.nextElement(), (String)enumeration.nextElement());
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new ParseException(Global.fmtMsg("sunsoft.jws.visual.rt.type.ListParser.ExpectingTwoElements", string));
            }
        }
        return hashtable;
    }

    public static int parseInt(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("\n\t" + numberFormatException.toString());
        }
    }
}

