/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.type;

import java.util.Hashtable;
import sunsoft.jws.visual.rt.awt.GBConstraints;
import sunsoft.jws.visual.rt.base.Global;
import sunsoft.jws.visual.rt.type.Converter;
import sunsoft.jws.visual.rt.type.SubFieldTokenizer;

public class GBConstraintsConverter
extends Converter {
    private static final GBConstraints constraintsDefault = new GBConstraints();

    private String constantToString(int n) {
        if (n == -1) {
            return "relative";
        }
        if (n == 0) {
            return "remainder";
        }
        if (n == 0) {
            return "none";
        }
        if (n == 1) {
            return "both";
        }
        if (n == 2) {
            return "horizontal";
        }
        if (n == 3) {
            return "vertical";
        }
        if (n == 10) {
            return "center";
        }
        if (n == 11) {
            return "north";
        }
        if (n == 12) {
            return "northeast";
        }
        if (n == 13) {
            return "east";
        }
        if (n == 14) {
            return "southeast";
        }
        if (n == 15) {
            return "south";
        }
        if (n == 16) {
            return "southwest";
        }
        if (n == 17) {
            return "west";
        }
        if (n == 18) {
            return "northwest";
        }
        throw new Error(Global.fmtMsg("sunsoft.jws.visual.rt.type.GBConstraintsConverter.FMT.29", Global.getMsg("sunsoft.jws.visual.rt.type.GBConstraintsConverter.unknown__constant"), new Integer(n)));
    }

    private int stringToConstant(String string) {
        if (string.equals("relative")) {
            return -1;
        }
        if (string.equals("remainder")) {
            return 0;
        }
        if (string.equals("none")) {
            return 0;
        }
        if (string.equals("both")) {
            return 1;
        }
        if (string.equals("horizontal")) {
            return 2;
        }
        if (string.equals("vertical")) {
            return 3;
        }
        if (string.equals("center")) {
            return 10;
        }
        if (string.equals("north")) {
            return 11;
        }
        if (string.equals("northeast")) {
            return 12;
        }
        if (string.equals("east")) {
            return 13;
        }
        if (string.equals("southeast")) {
            return 14;
        }
        if (string.equals("south")) {
            return 15;
        }
        if (string.equals("southwest")) {
            return 16;
        }
        if (string.equals("west")) {
            return 17;
        }
        if (string.equals("northwest")) {
            return 18;
        }
        throw new Error(Global.fmtMsg("sunsoft.jws.visual.rt.type.GBConstraintsConverter.FMT.29", Global.getMsg("sunsoft.jws.visual.rt.type.GBConstraintsConverter.unknown__constant"), string));
    }

    public String convertToString(Object object) {
        if (object != null) {
            GBConstraints gBConstraints = (GBConstraints)object;
            String string = "";
            if (gBConstraints.gridx != GBConstraintsConverter.constraintsDefault.gridx) {
                string = string + "x=" + gBConstraints.gridx + ";";
            }
            if (gBConstraints.gridy != GBConstraintsConverter.constraintsDefault.gridy) {
                string = string + "y=" + gBConstraints.gridy + ";";
            }
            if (gBConstraints.gridwidth != GBConstraintsConverter.constraintsDefault.gridwidth) {
                string = string + "width=" + gBConstraints.gridwidth + ";";
            }
            if (gBConstraints.gridheight != GBConstraintsConverter.constraintsDefault.gridheight) {
                string = string + "height=" + gBConstraints.gridheight + ";";
            }
            if (gBConstraints.weightx != GBConstraintsConverter.constraintsDefault.weightx) {
                string = string + "weightx=" + gBConstraints.weightx + ";";
            }
            if (gBConstraints.weighty != GBConstraintsConverter.constraintsDefault.weighty) {
                string = string + "weighty=" + gBConstraints.weighty + ";";
            }
            if (gBConstraints.fill != GBConstraintsConverter.constraintsDefault.fill) {
                string = string + "fill=" + this.constantToString(gBConstraints.fill) + ";";
            }
            if (gBConstraints.ipadx != GBConstraintsConverter.constraintsDefault.ipadx) {
                string = string + "ipadx=" + gBConstraints.ipadx + ";";
            }
            if (gBConstraints.ipady != GBConstraintsConverter.constraintsDefault.ipady) {
                string = string + "ipady=" + gBConstraints.ipady + ";";
            }
            if (gBConstraints.shrinkx != GBConstraintsConverter.constraintsDefault.shrinkx) {
                string = string + "shrinkx=" + gBConstraints.shrinkx + ";";
            }
            if (gBConstraints.shrinky != GBConstraintsConverter.constraintsDefault.shrinky) {
                string = string + "shrinky=" + gBConstraints.shrinky + ";";
            }
            if (string.length() > 0 && string.charAt(string.length() - 1) == ';') {
                return string.substring(0, string.length() - 1);
            }
            return string;
        }
        return null;
    }

    public String convertToCode(Object object) {
        return "new GBConstraints(\"" + this.convertToString(object) + "\")";
    }

    private int getIntegerFromTable(Hashtable hashtable, String string) {
        String string2 = (String)hashtable.get(string);
        if (string2 != null) {
            return Integer.valueOf(string2);
        }
        return 0;
    }

    private boolean getBooleanFromTable(Hashtable hashtable, String string) {
        String string2 = (String)hashtable.get(string);
        if (string2 != null) {
            return Boolean.valueOf(string2);
        }
        return false;
    }

    private double getDoubleFromTable(Hashtable hashtable, String string) {
        String string2 = (String)hashtable.get(string);
        if (string2 != null) {
            return Double.valueOf(string2);
        }
        return 0.0;
    }

    private int getConstantFromTable(Hashtable hashtable, String string) {
        String string2 = (String)hashtable.get(string);
        if (string2 != null) {
            return this.stringToConstant(string2);
        }
        return 0;
    }

    public Object convertFromString(String string) {
        if (string != null && string.length() > 0) {
            SubFieldTokenizer subFieldTokenizer = new SubFieldTokenizer(string);
            Hashtable hashtable = subFieldTokenizer.getHashtable();
            GBConstraints gBConstraints = new GBConstraints();
            if (hashtable.containsKey("x")) {
                gBConstraints.gridx = this.getIntegerFromTable(hashtable, "x");
            }
            if (hashtable.containsKey("y")) {
                gBConstraints.gridy = this.getIntegerFromTable(hashtable, "y");
            }
            if (hashtable.containsKey("width")) {
                gBConstraints.gridwidth = this.getIntegerFromTable(hashtable, "width");
            }
            if (hashtable.containsKey("height")) {
                gBConstraints.gridheight = this.getIntegerFromTable(hashtable, "height");
            }
            if (hashtable.containsKey("weightx")) {
                gBConstraints.weightx = this.getDoubleFromTable(hashtable, "weightx");
            }
            if (hashtable.containsKey("weighty")) {
                gBConstraints.weighty = this.getDoubleFromTable(hashtable, "weighty");
            }
            if (hashtable.containsKey("fill")) {
                gBConstraints.fill = this.getConstantFromTable(hashtable, "fill");
            }
            if (hashtable.containsKey("ipadx")) {
                gBConstraints.ipadx = this.getIntegerFromTable(hashtable, "ipadx");
            }
            if (hashtable.containsKey("ipady")) {
                gBConstraints.ipady = this.getIntegerFromTable(hashtable, "ipady");
            }
            if (hashtable.containsKey("shrinkx")) {
                gBConstraints.shrinkx = this.getBooleanFromTable(hashtable, "shrinkx");
            }
            if (hashtable.containsKey("shrinky")) {
                gBConstraints.shrinky = this.getBooleanFromTable(hashtable, "shrinky");
            }
            return gBConstraints;
        }
        return null;
    }
}

