/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.type;

import sunsoft.jws.visual.rt.type.BaseEnum;
import sunsoft.jws.visual.rt.type.Converter;
import sunsoft.jws.visual.rt.type.ListParser;

public class BaseEnumConverter
extends Converter {
    private Class enumClass = null;

    public BaseEnumConverter() {
    }

    public BaseEnumConverter(String string) {
        this.setConverterType(string);
    }

    private BaseEnum makeEnum(String string) {
        if (this.enumClass == null) {
            try {
                this.enumClass = Class.forName(this.getConverterType());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new Error(classNotFoundException.getMessage());
            }
        }
        try {
            BaseEnum baseEnum = (BaseEnum)this.enumClass.newInstance();
            baseEnum.set(string);
            return baseEnum;
        }
        catch (Exception exception) {
            throw new Error(exception.getMessage());
        }
    }

    public String convertToString(Object object) {
        return ((BaseEnum)object).toString();
    }

    public Object convertFromString(String string) {
        return this.makeEnum(string);
    }

    public String convertToCode(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("new ");
        stringBuffer.append(object.getClass().getName());
        stringBuffer.append("(");
        ListParser.quote(object.toString(), stringBuffer, true);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public boolean viewableAsString() {
        return false;
    }
}

