/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.base;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Panel;
import sunsoft.jws.visual.rt.awt.GBConstraints;
import sunsoft.jws.visual.rt.awt.GBLayout;
import sunsoft.jws.visual.rt.awt.RootFrame;
import sunsoft.jws.visual.rt.base.ExternalCallOut;
import sunsoft.jws.visual.rt.base.Global;
import sunsoft.jws.visual.rt.base.Group;
import sunsoft.jws.visual.rt.shadow.java.awt.DialogShadow;
import sunsoft.jws.visual.rt.shadow.java.awt.FrameShadow;
import sunsoft.jws.visual.rt.shadow.java.awt.PanelShadow;
import sunsoft.jws.visual.rt.shadow.java.awt.WindowShadow;

public class MainHelper {
    private Group baseGroup;
    private String ecoClassName;
    private ExternalCallOut eco;

    public void checkVersion(double d) {
        if (Global.getVersion() < d) {
            Double d2 = new Double(d);
            Double d3 = new Double(Global.getVersion());
            System.out.println(Global.fmtMsg("sunsoft.jws.visual.rt.base.MainHelper.NeedRuntimeVersion", d2, d3));
        }
    }

    private String[] parseCmdLineArgs(String[] stringArray) {
        String[] stringArray2 = stringArray;
        if (stringArray.length >= 2) {
            for (int i = 0; i < stringArray.length - 1; ++i) {
                if (!stringArray[i].equals("-external")) continue;
                this.ecoClassName = stringArray[i + 1];
                stringArray2 = new String[stringArray.length - 2];
                int n = 0;
                for (int j = 0; j < stringArray.length; ++j) {
                    if (j >= i && j <= i + 1) continue;
                    stringArray2[n] = stringArray[j];
                    ++n;
                }
                break;
            }
        }
        return stringArray2;
    }

    public void main(Group group, String[] stringArray) {
        Object object;
        this.baseGroup = group;
        RootFrame rootFrame = null;
        stringArray = this.parseCmdLineArgs(stringArray);
        this.baseGroup.setEnvironmentInfo(null, stringArray);
        this.baseGroup.initialize();
        WindowShadow windowShadow = this.baseGroup.getWindow();
        if (windowShadow instanceof FrameShadow) {
            windowShadow.createBody();
            this.baseGroup.setTopLevel((Frame)windowShadow.getBody());
        } else if (windowShadow instanceof DialogShadow) {
            object = windowShadow.getName();
            if (object == null || ((String)object).equals("")) {
                object = "Unnamed";
            }
            RootFrame rootFrame2 = new RootFrame((String)object);
            rootFrame2.setSubGroup(this.baseGroup);
            if (Global.isIrix()) {
                rootFrame2.setFont(new Font("Sansserif", 0, 12));
            }
            if (Global.isWindows()) {
                rootFrame2.setBackground(Color.lightGray);
                rootFrame2.setFont(new Font("Dialog", 0, 12));
            }
            this.baseGroup.setTopLevel(rootFrame2);
            rootFrame2.resize(25, 25);
            rootFrame2.show();
            rootFrame2.reshape(20, 20, 120, 80);
            rootFrame2.validate();
        } else if (this.baseGroup.getPanel() != null) {
            object = group.getPanel().getName();
            if (object == null || ((String)object).equals("")) {
                object = "Unnamed";
            }
            rootFrame = new RootFrame((String)object);
            rootFrame.setSubGroup(this.baseGroup);
            if (Global.isIrix()) {
                rootFrame.setFont(new Font("Sansserif", 0, 12));
            }
            if (Global.isWindows()) {
                rootFrame.setBackground(Color.lightGray);
                rootFrame.setFont(new Font("Dialog", 0, 12));
            }
            this.baseGroup.setTopLevel(rootFrame);
        } else {
            throw new Error(Global.fmtMsg("sunsoft.jws.visual.rt.base.MainHelper.BaseGroupMustBeNonVis", group));
        }
        this.baseGroup.create();
        if (rootFrame != null) {
            rootFrame.add("Center", (Panel)this.baseGroup.getPanel().getBody());
            rootFrame.resize(25, 25);
            rootFrame.show();
            object = rootFrame.preferredSize();
            rootFrame.reshape(20, 20, ((Dimension)object).width, ((Dimension)object).height);
            rootFrame.validate();
        }
        this.baseGroup.start();
        if (this.ecoClassName != null) {
            this.initExternalCallOut(this.ecoClassName, this.baseGroup);
            this.startExternalCallOut();
            this.stopExternalCallOut();
        }
    }

    public void init(Applet applet, Group group) {
        Object object;
        this.baseGroup = group;
        this.baseGroup.setEnvironmentInfo(applet, null);
        this.baseGroup.initialize();
        WindowShadow windowShadow = this.baseGroup.getWindow();
        if (windowShadow instanceof FrameShadow) {
            windowShadow.createBody();
            this.baseGroup.setTopLevel((Frame)windowShadow.getBody());
        } else {
            for (object = applet; object != null && !(object instanceof Frame); object = ((Component)object).getParent()) {
            }
            this.baseGroup.setTopLevel((Frame)object);
        }
        this.baseGroup.create();
        if (Global.isIrix()) {
            applet.setFont(new Font("Sansserif", 0, 12));
        } else if (Global.isWindows()) {
            applet.setFont(new Font("Dialog", 0, 12));
        }
        object = new GBLayout();
        applet.setLayout((LayoutManager)object);
        GBConstraints gBConstraints = new GBConstraints();
        gBConstraints.fill = 1;
        gBConstraints.weightx = 1.0;
        gBConstraints.weighty = 1.0;
        PanelShadow panelShadow = this.baseGroup.getPanel();
        if (panelShadow != null) {
            Panel panel = (Panel)panelShadow.getBody();
            ((GBLayout)object).setConstraints(applet.add(panel), gBConstraints);
        }
        this.ecoClassName = applet.getParameter("external");
        if (this.ecoClassName != null) {
            this.initExternalCallOut(this.ecoClassName, this.baseGroup);
        }
    }

    public void start() {
        if (this.baseGroup != null) {
            this.baseGroup.start();
        }
        this.startExternalCallOut();
    }

    public void stop() {
        if (this.baseGroup != null) {
            this.baseGroup.stop();
        }
        this.stopExternalCallOut();
    }

    public void destroy() {
        if (this.baseGroup != null) {
            this.baseGroup.destroy();
        }
    }

    private void initExternalCallOut(String string, Group group) {
        try {
            Class clazz = Global.util.getClassLoader().loadClass(string);
            this.eco = (ExternalCallOut)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Error(Global.fmtMsg("sunsoft.jws.visual.rt.base.MainHelper.ClassNotFound", string));
        }
        catch (InstantiationException instantiationException) {
            throw new Error(Global.fmtMsg("sunsoft.jws.visual.rt.base.MainHelper.InstantiationException", string));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Error(Global.fmtMsg("sunsoft.jws.visual.rt.base.MainHelper.illegalAccess", string));
        }
        if (this.eco != null) {
            this.eco.initExternal(group);
        }
    }

    private void startExternalCallOut() {
        if (this.eco != null) {
            this.eco.startExternal();
        }
    }

    private void stopExternalCallOut() {
        if (this.eco != null) {
            this.eco.stopExternal();
        }
    }
}

