/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.base;

import java.awt.Event;
import java.util.Enumeration;
import sunsoft.jws.visual.rt.base.AMContainer;
import sunsoft.jws.visual.rt.base.Attribute;
import sunsoft.jws.visual.rt.base.AttributeList;
import sunsoft.jws.visual.rt.base.DesignerAccess;
import sunsoft.jws.visual.rt.base.Global;
import sunsoft.jws.visual.rt.base.Group;
import sunsoft.jws.visual.rt.base.Message;
import sunsoft.jws.visual.rt.base.Root;
import sunsoft.jws.visual.rt.base.Shadow;
import sunsoft.jws.visual.rt.type.Op;

public class AttributeManager {
    public static final int READONLY = 1;
    public static final int HIDDEN = 2;
    public static final int TRANSIENT = 4;
    public static final int CONTAINER = 8;
    public static final int DEFAULT = 16;
    public static final int DONTFETCH = 32;
    public static final int NOEDITOR = 1024;
    protected AttributeList attributes = new AttributeList();
    AMContainer parent;
    boolean isCreated = false;
    private Boolean inDesignerRoot = null;
    private boolean layoutMode = false;

    public AttributeManager() {
        this.attributes.add("name", "java.lang.String", null, 1152);
        this.attributes.add("operations", "[Lsunsoft.jws.visual.rt.type.Op;", null, 128);
    }

    public AMContainer getParent() {
        return this.parent;
    }

    public void setParent(AMContainer aMContainer) {
        this.parent = aMContainer;
    }

    public boolean isLive() {
        Root root = this.getRoot();
        while (root != null) {
            if (root.isLoadedRoot()) {
                return false;
            }
            Group group = root.getGroup();
            if (group == null) break;
            root = group.getRoot();
        }
        return true;
    }

    public boolean inDesignerRoot() {
        if (this.inDesignerRoot != null) {
            return this.inDesignerRoot;
        }
        return this.checkDesignerRoot();
    }

    private boolean checkDesignerRoot() {
        Root root = this.getRoot();
        return root != null && root.isLoadedRoot();
    }

    protected String getUserTypeName() {
        return "manager";
    }

    protected final void putInTable(String string, Object object) {
        Attribute attribute = this.attributes.get(string);
        if (attribute == null) {
            throw new Error(Global.fmtMsg("sunsoft.jws.visual.rt.base.AttributeManager.SetInvalidAttribute", string));
        }
        if (attribute.flagged(1)) {
            throw new Error(Global.fmtMsg("sunsoft.jws.visual.rt.base.AttributeManager.ReadonlyAttribute", string));
        }
        attribute.setValue(object);
    }

    protected final Object getFromTable(String string) {
        Attribute attribute = this.attributes.get(string);
        if (attribute == null) {
            throw new Error(Global.fmtMsg("sunsoft.jws.visual.rt.base.AttributeManager.GetInvalidAttribute", string));
        }
        return attribute.getValue();
    }

    public void set(String string, Object object) {
        this.putInTable(string, object);
        if (this.inDesignerRoot()) {
            DesignerAccess.setChangesMade(true);
        }
    }

    public Object get(String string) {
        return this.getFromTable(string);
    }

    public String getType(String string) {
        Attribute attribute = this.attributes.get(string);
        if (attribute != null) {
            return attribute.getType();
        }
        return null;
    }

    public int getFlags(String string) {
        Attribute attribute = this.attributes.get(string);
        if (attribute != null) {
            return attribute.getFlags();
        }
        return 0;
    }

    public boolean hasAttribute(String string) {
        return this.attributes.get(string) != null;
    }

    public boolean hasAttribute(String string, String string2) {
        Attribute attribute = this.attributes.get(string);
        if (attribute != null) {
            return attribute.getType().equals(string2);
        }
        return false;
    }

    public void updateContainerAttributes(AMContainer aMContainer, AttributeManager attributeManager) {
        Enumeration enumeration = attributeManager.attributes.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            if (!attribute.flagged(8)) continue;
            aMContainer.updateContainerAttribute(attributeManager, attribute.getName(), attribute.getValue());
        }
    }

    public AttributeList getAttributeList() {
        this.refetchAttributeList();
        return this.attributes;
    }

    Attribute getAttribute(String string) {
        return this.attributes.get(string);
    }

    public void refetchAttributeList() {
        Enumeration enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            if (attribute.flagged(33)) continue;
            String string = attribute.getName();
            this.putInTable(string, this.get(string));
        }
    }

    public AttributeManager resolve(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals(this.getFromTable("name"))) {
            return this;
        }
        if (this instanceof AMContainer) {
            Enumeration enumeration = ((AMContainer)((Object)this)).getChildList();
            while (enumeration.hasMoreElements()) {
                AttributeManager attributeManager = (AttributeManager)enumeration.nextElement();
                AttributeManager attributeManager2 = attributeManager.resolve(string);
                if (attributeManager2 == null) continue;
                return attributeManager2;
            }
        }
        return null;
    }

    public AttributeManager resolveFullName(String string) {
        Group group = this.getGroup();
        if (group != null) {
            return group.resolveFullName(string);
        }
        return null;
    }

    public Object resolveBody(String string) {
        AttributeManager attributeManager = this.resolve(string);
        if (attributeManager == null) {
            return null;
        }
        if (!(attributeManager instanceof Shadow)) {
            return null;
        }
        return ((Shadow)attributeManager).getBody();
    }

    public String getName() {
        return (String)this.get("name");
    }

    public String getFullName() {
        String string;
        String string2 = this.getName();
        Group group = this.getGroup();
        if (group != null && (string = group.getFullName()) != null) {
            string2 = string + "." + string2;
        }
        return string2;
    }

    public void initialize() {
    }

    public void create() {
        this.isCreated = true;
        this.inDesignerRoot = new Boolean(this.checkDesignerRoot());
        if (this instanceof AMContainer) {
            ((AMContainer)((Object)this)).createChildren();
        }
    }

    public boolean isCreated() {
        return this.isCreated;
    }

    public void recreate() {
    }

    public void destroy() {
        this.isCreated = false;
        this.inDesignerRoot = null;
        if (this instanceof AMContainer) {
            ((AMContainer)((Object)this)).destroyChildren();
        }
    }

    public String hierarchy() {
        return this.hierarchy(0);
    }

    private String hierarchy(int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + "    ";
        }
        String string2 = "";
        if (this instanceof AMContainer) {
            Enumeration enumeration = ((AMContainer)((Object)this)).getChildList();
            while (enumeration.hasMoreElements()) {
                string2 = string2 + ((AttributeManager)enumeration.nextElement()).hierarchy(n + 1);
            }
        }
        return string + this.getFromTable("name") + Global.newline() + string2;
    }

    public String toString() {
        return super.toString() + "[" + (this instanceof AMContainer ? "container" : "nonContainer") + "]";
    }

    public Root getRoot() {
        AttributeManager attributeManager;
        for (attributeManager = this; attributeManager != null && !(attributeManager instanceof Root); attributeManager = (AttributeManager)((Object)attributeManager.getParent())) {
        }
        return (Root)attributeManager;
    }

    public Group getGroup() {
        Root root = this.getRoot();
        if (root != null) {
            return root.getGroup();
        }
        return null;
    }

    protected Group getForwardingGroup(String string) {
        Root root = this.getRoot();
        Group group = root.getGroup();
        if (group != null && group.hasAttributeForward(this, string)) {
            Group group2 = group.getParentGroup();
            while (group2 != null && group2.hasAttributeForward(group, string)) {
                group = group2;
                group2 = group.getParentGroup();
            }
            return group;
        }
        return null;
    }

    public AttributeManager replicate() {
        Object object;
        AttributeManager attributeManager = null;
        try {
            attributeManager = (AttributeManager)this.getClass().newInstance();
        }
        catch (InstantiationException instantiationException) {
            System.out.println(instantiationException.getMessage() + " " + this);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.out.println(illegalAccessException.getMessage() + " " + this);
        }
        if (attributeManager == null) {
            return null;
        }
        AttributeList attributeList = this.getAttributeList();
        Enumeration enumeration = attributeList.elements();
        while (enumeration.hasMoreElements()) {
            object = (Attribute)enumeration.nextElement();
            if (((Attribute)object).flagged(5)) continue;
            attributeManager.set(((Attribute)object).getName(), ((Attribute)object).getValue());
        }
        if (this instanceof AMContainer) {
            object = (AMContainer)((Object)attributeManager);
            enumeration = ((AMContainer)((Object)this)).getChildList();
            while (enumeration.hasMoreElements()) {
                AttributeManager attributeManager2 = (AttributeManager)enumeration.nextElement();
                object.add(attributeManager2.replicate());
            }
        }
        return attributeManager;
    }

    public void postMessageToParent(Message message) {
        if (this.parent != null) {
            ((AttributeManager)((Object)this.parent)).postMessage(message);
        }
    }

    public void postMessage(Message message) {
        if (this.inDesignerRoot()) {
            this.sendToOps(message);
        }
        if (!this.handleMessage(message) && this.parent != null) {
            ((AttributeManager)((Object)this.parent)).postMessage(message);
        }
    }

    private void sendToOps(Message message) {
        Op[] opArray = (Op[])this.get("operations");
        if (opArray != null) {
            for (int i = 0; i < opArray.length; ++i) {
                opArray[i].filter.target = this;
                if (opArray[i].scope == null) {
                    opArray[i].scope = this.getRoot();
                }
                if (opArray[i].action != null && opArray[i].action.target != null && opArray[i].action.target.getName() != null && opArray[i].action.target.getName().equals("GROUP")) continue;
                opArray[i].handleMessage(message);
            }
        }
    }

    public boolean handleMessage(Message message) {
        if (message.isAWT) {
            return this.handleEvent(message, (Event)message.arg);
        }
        return false;
    }

    public boolean handleEvent(Message message, Event event) {
        switch (event.id) {
            case 504: {
                return this.mouseEnter(message, event, event.x, event.y);
            }
            case 505: {
                return this.mouseExit(message, event, event.x, event.y);
            }
            case 503: {
                return this.mouseMove(message, event, event.x, event.y);
            }
            case 501: {
                return this.mouseDown(message, event, event.x, event.y);
            }
            case 506: {
                return this.mouseDrag(message, event, event.x, event.y);
            }
            case 502: {
                return this.mouseUp(message, event, event.x, event.y);
            }
            case 401: 
            case 403: {
                return this.keyDown(message, event, event.key);
            }
            case 402: 
            case 404: {
                return this.keyUp(message, event, event.key);
            }
            case 1001: {
                return this.action(message, event, event.arg);
            }
            case 1004: {
                return this.gotFocus(message, event, event.arg);
            }
            case 1005: {
                return this.lostFocus(message, event, event.arg);
            }
        }
        return false;
    }

    public boolean mouseDown(Message message, Event event, int n, int n2) {
        return false;
    }

    public boolean mouseDrag(Message message, Event event, int n, int n2) {
        return false;
    }

    public boolean mouseUp(Message message, Event event, int n, int n2) {
        return false;
    }

    public boolean mouseMove(Message message, Event event, int n, int n2) {
        return false;
    }

    public boolean mouseEnter(Message message, Event event, int n, int n2) {
        return false;
    }

    public boolean mouseExit(Message message, Event event, int n, int n2) {
        return false;
    }

    public boolean keyDown(Message message, Event event, int n) {
        return false;
    }

    public boolean keyUp(Message message, Event event, int n) {
        return false;
    }

    public boolean action(Message message, Event event, Object object) {
        return false;
    }

    public boolean gotFocus(Message message, Event event, Object object) {
        return false;
    }

    public boolean lostFocus(Message message, Event event, Object object) {
        return false;
    }

    public boolean isLayoutMode() {
        return this.layoutMode;
    }

    public void layoutMode() {
        this.layoutMode = true;
    }

    public void previewMode() {
        this.layoutMode = false;
    }

    protected void preValidate() {
    }
}

