/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.base;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sunsoft.jws.visual.rt.base.Attribute;

public class AttributeList
implements Cloneable {
    private Hashtable table = new Hashtable();
    private Hashtable aliasTable = new Hashtable();

    public void add(Attribute attribute) {
        this.table.put(attribute.getName(), attribute);
    }

    public void add(String string, String string2, Object object) {
        Attribute attribute = this.lookup(string);
        if (attribute == null) {
            this.add(new Attribute(string, string2, object, 0));
        } else {
            this.add(new Attribute(string, string2, object, attribute.getFlags()));
        }
    }

    public void add(String string, String string2, Object object, int n) {
        this.table.put(string, new Attribute(string, string2, object, n));
    }

    public void alias(String string, String string2) {
        this.aliasTable.put(string, string2);
    }

    public Enumeration aliasKeys() {
        return this.aliasTable.keys();
    }

    public String resolveAlias(String string) {
        String string2;
        String string3 = string2 = string;
        while (string2 != null) {
            string3 = string2;
            string2 = (String)this.aliasTable.get(string2);
        }
        return string3;
    }

    public void remove(String string) {
        this.table.remove(string);
        this.aliasTable.remove(string);
    }

    private Attribute lookup(String string) {
        Attribute attribute = (Attribute)this.table.get(string);
        if (attribute == null) {
            string = this.resolveAlias(string);
            attribute = (Attribute)this.table.get(string);
        }
        return attribute;
    }

    public Attribute get(String string) {
        return this.lookup(string);
    }

    public boolean contains(String string) {
        return this.lookup(string) != null;
    }

    public Enumeration attributesWithFlags(int n) {
        Vector<Attribute> vector = new Vector<Attribute>();
        Enumeration enumeration = this.table.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            if ((attribute.getFlags() & n) == 0) continue;
            vector.addElement(attribute);
        }
        return vector.elements();
    }

    public Enumeration attributesWithoutFlags(int n) {
        Vector<Attribute> vector = new Vector<Attribute>();
        Enumeration enumeration = this.table.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            if ((attribute.getFlags() & n) != 0) continue;
            vector.addElement(attribute);
        }
        return vector.elements();
    }

    public Enumeration elements() {
        return this.table.elements();
    }

    public int size() {
        return this.table.size();
    }

    public void merge(AttributeList attributeList) {
        if (attributeList != null) {
            Enumeration enumeration = attributeList.elements();
            while (enumeration.hasMoreElements()) {
                this.add((Attribute)((Attribute)enumeration.nextElement()).clone());
            }
            enumeration = attributeList.aliasKeys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.alias(string, attributeList.resolveAlias(string));
            }
        }
    }

    public static Enumeration alphabetize(Enumeration enumeration) {
        Vector<Attribute> vector = new Vector<Attribute>();
        while (enumeration.hasMoreElements()) {
            int n;
            Attribute attribute = (Attribute)enumeration.nextElement();
            for (n = 0; n < vector.size(); ++n) {
                if (((Attribute)vector.elementAt(n)).getName().compareTo(attribute.getName()) <= 0) continue;
                vector.insertElementAt(attribute, n);
                break;
            }
            if (n < vector.size()) continue;
            vector.addElement(attribute);
        }
        return vector.elements();
    }

    public Object clone() {
        AttributeList attributeList = new AttributeList();
        attributeList.merge(this);
        return attributeList;
    }

    public String toString() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.table.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            stringBuffer.append(string + "(" + ((Attribute)this.table.get(string)).getType() + ") ");
        }
        enumeration = this.aliasTable.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            stringBuffer.append("alias:" + string + "->" + (String)this.aliasTable.get(string) + " ");
        }
        return stringBuffer.toString();
    }
}

