/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.base;

import sunsoft.jws.visual.rt.base.Global;

public class Attribute
implements Cloneable {
    private String name;
    private String type;
    private Object value;
    private Object defaultValue;
    private int flags;

    public Attribute(String string, String string2, Object object, int n) {
        this.name = string;
        this.type = string2;
        this.value = object;
        this.defaultValue = object;
        this.flags = n;
    }

    private void throwOnBadType(Object object) {
        if (object == null) {
            return;
        }
        if (object.getClass().getName().equals(this.type)) {
            return;
        }
        Class clazz = null;
        try {
            clazz = Global.util.getClassLoader().loadClass(this.type);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Error(Global.fmtMsg("sunsoft.jws.visual.rt.base.Attribute.ClassNotFound", this.type));
        }
        if (clazz.isInstance(object)) {
            return;
        }
        throw new Error(Global.fmtMsg("sunsoft.jws.visual.rt.base.Attribute.IllegalAttribute", this.name, this.type, object.getClass().getName(), object));
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    void setDefaultValue(Object object) {
        this.defaultValue = object;
    }

    public boolean isModified() {
        if (this.value == null) {
            return this.defaultValue != null;
        }
        return !this.value.equals(this.defaultValue);
    }

    public void reset() {
        this.setValue(this.defaultValue);
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        this.throwOnBadType(object);
        this.value = object;
    }

    public int getFlags() {
        return this.flags;
    }

    public void addFlags(int n) {
        this.flags |= n;
    }

    public boolean flagged(int n) {
        return (n & this.flags) != 0;
    }

    public Object clone() {
        Object object;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error(cloneNotSupportedException.getMessage());
        }
        return object;
    }
}

