/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.awt;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import sunsoft.jws.visual.rt.base.Global;

public class WinScrollbar
extends Canvas
implements Runnable {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    int value;
    int maximum;
    int minimum;
    int sVisible;
    int orientation;
    int lineIncrement = 1;
    int pageIncrement = 10;
    private boolean winNT;
    private static WinScrollbar threadScrollbar;
    private static Thread scrollThread;
    private WinScrollbar currentScrollbar;
    private int currentScrollAction;
    private int currentScrollPosition;
    private static final int SCROLL_DELAY = 250;
    private static final int SCROLL_INTERVAL = 40;
    private Image buffer;
    private int prevWidth = 0;
    private int prevHeight = 0;
    private int action = 0;
    private int anchorPos;
    private int anchorValue;
    private int dragSpace;
    private static final int UP = 10;
    private static final int DOWN = 11;
    private static final int LEFT = 12;
    private static final int RIGHT = 13;
    private static final int LINEUP = 20;
    private static final int LINEDOWN = 21;
    private static final int PAGEUP = 22;
    private static final int PAGEDOWN = 23;
    private static final int DRAG = 24;
    private static final double PAGE_DFACTOR = 0.8;

    public WinScrollbar() {
        this(1);
    }

    public WinScrollbar(int n) {
        switch (n) {
            case 0: 
            case 1: {
                this.orientation = n;
                break;
            }
            default: {
                throw new IllegalArgumentException(Global.getMsg("sunsoft.jws.visual.rt.awt.WinScrollbar.IllegalOrientation"));
            }
        }
        this.winNT = Global.isWindowsNT();
    }

    public WinScrollbar(int n, int n2, int n3, int n4, int n5) {
        this(n);
        this.setValues(n2, n3, n4, n5);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int n) {
        if (n < this.minimum) {
            n = this.minimum;
        }
        if (n > this.maximum - this.sVisible) {
            n = this.maximum - this.sVisible;
        }
        if (n != this.value) {
            this.value = n;
            if (this.getPeer() != null) {
                this.peerSetValue(n);
            }
        }
    }

    public int getMinimum() {
        return this.minimum;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public int getVisible() {
        return this.sVisible;
    }

    public void setLineIncrement(int n) {
        this.lineIncrement = n;
        if (this.getPeer() != null) {
            this.peerSetLineIncrement(n);
        }
    }

    public int getLineIncrement() {
        return this.lineIncrement;
    }

    public void setPageIncrement(int n) {
        this.pageIncrement = n;
        if (this.getPeer() != null) {
            this.peerSetPageIncrement(n);
        }
    }

    public int getPageIncrement() {
        return this.pageIncrement;
    }

    public void setValues(int n, int n2, int n3, int n4) {
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > n4) {
            n2 = n4;
        }
        if (n4 < n3) {
            n4 = n3;
        }
        if (n < n3) {
            n = n3;
        }
        if (n > n4 - n2) {
            n = n4 - n2;
        }
        this.value = n;
        this.sVisible = n2;
        this.minimum = n3;
        this.maximum = n4;
        if (this.getPeer() != null) {
            this.peerSetValues(n, this.sVisible, n3, n4);
        }
    }

    protected String paramString() {
        return super.paramString() + ",val=" + this.value + ",vis=" + this.isVisible() + ",min=" + this.minimum + ",max=" + this.maximum + (this.orientation == 1 ? ",vert" : ",horz");
    }

    public Dimension minimumSize() {
        if (this.orientation == 1) {
            return new Dimension(16, 50);
        }
        return new Dimension(50, 16);
    }

    public Dimension preferredSize() {
        return this.minimumSize();
    }

    private void peerSetValue(int n) {
        this.repaint();
    }

    private void peerSetLineIncrement(int n) {
    }

    private void peerSetPageIncrement(int n) {
    }

    private void peerSetValues(int n, int n2, int n3, int n4) {
        this.repaint();
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        if (this.prevWidth != n3 || this.prevHeight != n4) {
            this.buffer = n3 > 0 && n4 > 0 ? this.createImage(n3, n4) : null;
            this.prevWidth = n3;
            this.prevHeight = n4;
        }
    }

    public void update(Graphics graphics) {
        if (Global.isWindows()) {
            graphics = this.getGraphics();
        }
        this.draw(graphics);
    }

    public void paint(Graphics graphics) {
        if (Global.isWindows()) {
            graphics = this.getGraphics();
        }
        this.draw(graphics);
    }

    private void draw(Graphics graphics) {
        if (this.buffer == null) {
            return;
        }
        this.drawScrollbar();
        graphics.drawImage(this.buffer, 0, 0, null);
    }

    private void drawScrollbar() {
        Graphics graphics = this.buffer.getGraphics();
        Dimension dimension = this.size();
        int n = dimension.width;
        int n2 = dimension.height;
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        this.drawOutline(graphics, n - 1, n2 - 1);
        this.drawEndBoxes(graphics, n - 1, n2 - 1);
        int[] nArray = this.getDragBoxInfo();
        this.fillPageBox(graphics, n, n2, nArray);
        this.drawDragBox(graphics, n - 1, n2 - 1, nArray);
    }

    private void drawOutline(Graphics graphics, int n, int n2) {
        graphics.setColor(Global.util.darker(this.getBackground()));
        if (this.orientation == 1) {
            graphics.drawRect(0, 0, n, n);
            graphics.drawRect(0, n, n, n2 - 2 * n);
            graphics.drawRect(0, n2 - n, n, n);
        } else {
            graphics.drawRect(0, 0, n2, n2);
            graphics.drawRect(n2, 0, n - 2 * n2, n2);
            graphics.drawRect(n - n2, 0, n2, n2);
        }
    }

    private void drawEndBoxes(Graphics graphics, int n, int n2) {
        if (this.orientation == 1) {
            if (this.action != 20) {
                this.drawArrow(graphics, 0, 0, n, n, 10);
                this.drawBox(graphics, 0, 0, n, n);
            } else {
                this.drawArrow(graphics, 1, 1, n, n, 10);
            }
            if (this.action != 21) {
                this.drawArrow(graphics, 0, n2 - n, n, n, 11);
                this.drawBox(graphics, 0, n2 - n, n, n);
            } else {
                this.drawArrow(graphics, 1, n2 - n + 1, n, n, 11);
            }
        } else {
            if (this.action != 20) {
                this.drawArrow(graphics, 0, 0, n2, n2, 12);
                this.drawBox(graphics, 0, 0, n2, n2);
            } else {
                this.drawArrow(graphics, 1, 1, n2, n2, 12);
            }
            if (this.action != 21) {
                this.drawArrow(graphics, n - n2, 0, n2, n2, 13);
                this.drawBox(graphics, n - n2, 0, n2, n2);
            } else {
                this.drawArrow(graphics, n - n2 + 1, 1, n2, n2, 13);
            }
        }
    }

    private void fillPageBox(Graphics graphics, int n, int n2, int[] nArray) {
        graphics.setColor(this.pageDarker(this.getBackground()));
        if (this.orientation == 1) {
            if (this.action == 22) {
                graphics.fillRect(1, n, n - 2, nArray[0] - n);
            } else if (this.action == 23) {
                graphics.fillRect(1, nArray[0] + nArray[1] + 1, n - 2, n2 - (n + nArray[0] + nArray[1]) - 1);
            }
        } else if (this.action == 22) {
            graphics.fillRect(n2, 1, nArray[0] - n2, n2 - 2);
        } else if (this.action == 23) {
            graphics.fillRect(nArray[0] + nArray[1] + 1, 1, n - (n2 + nArray[0] + nArray[1]) - 1, n2 - 2);
        }
    }

    private void drawDragBox(Graphics graphics, int n, int n2, int[] nArray) {
        if (this.orientation == 1) {
            this.drawBox(graphics, 0, nArray[0], n, nArray[1]);
        } else {
            this.drawBox(graphics, nArray[0], 0, nArray[1], n2);
        }
    }

    private int[] getDragBoxInfo() {
        int n;
        int n2;
        int[] nArray = new int[2];
        Dimension dimension = this.size();
        if (this.orientation == 1) {
            n2 = dimension.width;
            n = dimension.height - 2 * dimension.width;
        } else {
            n2 = dimension.height;
            n = dimension.width - 2 * dimension.height;
        }
        int n3 = this.maximum - this.minimum;
        double d = (double)n / (double)n3;
        double d2 = (double)n2 + (double)(this.value - this.minimum) * d;
        double d3 = (double)this.sVisible * d;
        nArray[0] = (int)d2;
        nArray[1] = (int)d3;
        return nArray;
    }

    private void drawBox(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(this.getBackground());
        Global.util.draw3DRect(graphics, n, n2, n3, n4, 9, 2);
    }

    private void drawArrow(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        Polygon polygon = new Polygon();
        int n6 = (n3 - 3) / 3;
        int n7 = (n4 - 3) / 3;
        int n8 = 2;
        graphics.setColor(Color.black);
        switch (n5) {
            case 12: {
                if (this.winNT) {
                    graphics.fillRect((n -= n6 / 4) + n8 + 2 * n6 - 1, n2 + n8 + 5 * n7 / 4 - 1, n6 / 2 + 1, n7 / 2 + 1);
                }
                polygon.addPoint(n + n8 + n6 - 1, n2 + n8 + 3 * n7 / 2 - 1);
                polygon.addPoint(n + n8 + 2 * n6 - 1, n2 + n8 + n7 - 3);
                polygon.addPoint(n + n8 + 2 * n6 - 1, n2 + n8 + 2 * n7 + 1);
                break;
            }
            case 13: {
                if (this.winNT) {
                    graphics.fillRect((n += n6 / 4 + 1) + n8 + n6 / 2 - 1, n2 + n8 + 5 * n7 / 4 - 1, n6 / 2 + 2, n7 / 2 + 1);
                }
                polygon.addPoint(n + n8 + n6, n2 + n8 + n7 - 3);
                polygon.addPoint(n + n8 + n6 * 2, n2 + n8 + 3 * n7 / 2 - 1);
                polygon.addPoint(n + n8 + n6, n2 + n8 + 2 * n7 + 1);
                break;
            }
            case 10: {
                if (this.winNT) {
                    graphics.fillRect(n + n8 + 5 * n6 / 4 - 1, (n2 -= n7 / 4 + 1) + n8 + 2 * n7, n6 / 2 + 1, n7 / 2 + 1);
                }
                polygon.addPoint(n + n8 + n6 - 3, n2 + n8 + 2 * n7);
                polygon.addPoint(n + n8 + 3 * n6 / 2 - 1, n2 + n8 + n7);
                polygon.addPoint(n + n8 + 3 * n6 / 2, n2 + n8 + n7);
                polygon.addPoint(n + n8 + 2 * n6 + 2, n2 + n8 + 2 * n7);
                break;
            }
            case 11: {
                if (this.winNT) {
                    graphics.fillRect(n + n8 + 5 * n6 / 4 - 1, (n2 += n7 / 4 + 1) + n8 + n7 / 2 - 1, n6 / 2 + 1, n7 / 2 + 2);
                }
                polygon.addPoint(n + n8 + n6 - 2, n2 + n8 + n7);
                polygon.addPoint(n + n8 + 2 * n6 + 1, n2 + n8 + n7);
                polygon.addPoint(n + n8 + 3 * n6 / 2 - 1, n2 + n8 + 2 * n7);
                polygon.addPoint(n + n8 + 3 * n6 / 2 - 1, n2 + n8 + 2 * n7 - 1);
            }
        }
        graphics.fillPolygon(polygon);
    }

    private Color pageDarker(Color color) {
        return new Color(Math.max((int)((double)color.getRed() * 0.8), 0), Math.max((int)((double)color.getGreen() * 0.8), 0), Math.max((int)((double)color.getBlue() * 0.8), 0));
    }

    public boolean mouseDown(Event event, int n, int n2) {
        Dimension dimension = this.size();
        int n3 = dimension.width;
        int n4 = dimension.height;
        if (this.orientation == 1) {
            if (n2 < n3) {
                this.lineUp(n2);
            } else if (n2 >= n4 - n3) {
                this.lineDown(n2);
            } else {
                int[] nArray = this.getDragBoxInfo();
                if (n2 >= n3 + 1 && n2 < nArray[0]) {
                    this.pageUp(n2);
                } else if (n2 >= nArray[0] + nArray[1] && n2 < n4 - n3) {
                    this.pageDown(n2);
                } else if (n2 >= nArray[0] && n2 < nArray[0] + nArray[1]) {
                    this.dragStart(n, n2);
                }
            }
        } else if (n < n4) {
            this.lineUp(n);
        } else if (n >= n3 - n4) {
            this.lineDown(n);
        } else {
            int[] nArray = this.getDragBoxInfo();
            if (n >= n4 + 1 && n < nArray[0]) {
                this.pageUp(n);
            } else if (n >= nArray[0] + nArray[1] && n < n3 - n4) {
                this.pageDown(n);
            } else if (n >= nArray[0] && n < nArray[0] + nArray[1]) {
                this.dragStart(n, n2);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mouseDrag(Event event, int n, int n2) {
        if (this.action == 24) {
            this.drag(n, n2);
            return true;
        }
        if (threadScrollbar != null && WinScrollbar.threadScrollbar.currentScrollbar == this) {
            WinScrollbar winScrollbar = threadScrollbar;
            synchronized (winScrollbar) {
                WinScrollbar.threadScrollbar.currentScrollPosition = this.orientation == 1 ? n2 : n;
            }
        }
        return false;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        this.cancelAutoScroll();
        if (this.action == 24) {
            this.dragStop(n, n2);
        }
        this.action = 0;
        this.repaint();
        return false;
    }

    private boolean lineUp(int n) {
        boolean bl = false;
        this.action = 20;
        this.initAutoScroll(this.action, n);
        int n2 = this.value;
        this.value = Math.max(this.minimum, this.value - this.lineIncrement);
        if (this.value != n2) {
            bl = true;
            this.postEvent(new Event(this, 601, new Integer(this.value)));
        }
        this.repaint();
        return bl;
    }

    private boolean lineDown(int n) {
        boolean bl = false;
        this.action = 21;
        this.initAutoScroll(this.action, n);
        int n2 = this.value;
        this.value = Math.min(this.maximum - this.sVisible, this.value + this.lineIncrement);
        if (this.value != n2) {
            this.postEvent(new Event(this, 602, new Integer(this.value)));
            bl = true;
        }
        this.repaint();
        return bl;
    }

    private boolean pageUp(int n) {
        boolean bl = false;
        this.action = 22;
        this.initAutoScroll(this.action, n);
        int n2 = this.value;
        this.value = Math.max(this.minimum, this.value - this.pageIncrement);
        if (this.value != n2) {
            bl = true;
            this.postEvent(new Event(this, 603, new Integer(this.value)));
        }
        this.repaint();
        return bl;
    }

    private boolean pageDown(int n) {
        boolean bl = false;
        this.action = 23;
        this.initAutoScroll(this.action, n);
        int n2 = this.value;
        this.value = Math.min(this.maximum - this.sVisible, this.value + this.pageIncrement);
        if (this.value != n2) {
            bl = true;
            this.postEvent(new Event(this, 604, new Integer(this.value)));
        }
        this.repaint();
        return bl;
    }

    private void dragStart(int n, int n2) {
        this.action = 24;
        this.anchorPos = this.orientation == 1 ? n2 : n;
        this.anchorValue = this.value;
        Dimension dimension = this.size();
        int[] nArray = this.getDragBoxInfo();
        this.dragSpace = this.orientation == 1 ? dimension.height - dimension.width * 2 - nArray[1] : dimension.width - dimension.height * 2 - nArray[1];
    }

    private void drag(int n, int n2) {
        if (this.orientation == 1) {
            this.newDragValue(n2);
        } else {
            this.newDragValue(n);
        }
    }

    private void dragStop(int n, int n2) {
        this.action = 0;
        this.drag(n, n2);
    }

    private void newDragValue(int n) {
        int n2 = n - this.anchorPos;
        int n3 = n2 * (this.maximum - this.minimum) / this.dragSpace;
        int n4 = this.value;
        this.value = this.anchorValue + n3;
        this.value = n3 < 0 ? Math.max(this.value, this.minimum) : Math.min(this.value, this.maximum - this.sVisible);
        if (this.value != n4) {
            this.postEvent(new Event(this, 605, new Integer(this.value)));
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAutoScroll(int n, int n2) {
        if (Thread.currentThread() == scrollThread) {
            return;
        }
        if (threadScrollbar == null) {
            threadScrollbar = this;
            scrollThread = new Thread((Runnable)threadScrollbar, "WindowsScrollbarThread");
            scrollThread.setDaemon(true);
            scrollThread.start();
        }
        WinScrollbar winScrollbar = threadScrollbar;
        synchronized (winScrollbar) {
            WinScrollbar.threadScrollbar.currentScrollbar = this;
            WinScrollbar.threadScrollbar.currentScrollAction = n;
            WinScrollbar.threadScrollbar.currentScrollPosition = n2;
            threadScrollbar.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelAutoScroll() {
        if (threadScrollbar != null) {
            WinScrollbar winScrollbar = threadScrollbar;
            synchronized (winScrollbar) {
                WinScrollbar.threadScrollbar.currentScrollbar = null;
                WinScrollbar.threadScrollbar.currentScrollAction = -1;
                WinScrollbar.threadScrollbar.currentScrollPosition = -1;
                threadScrollbar.notify();
            }
        }
    }

    public synchronized void run() {
        boolean bl = false;
        while (scrollThread == Thread.currentThread()) {
            long l;
            long l2 = System.currentTimeMillis();
            if (this.currentScrollbar == null) {
                l = 0L;
                bl = false;
            } else if (bl) {
                if (!this.doScroll(this.currentScrollbar, this.currentScrollAction, this.currentScrollPosition)) {
                    this.cancelAutoScroll();
                    l = 0L;
                } else {
                    l = 40L;
                }
            } else {
                l = 250L;
                bl = true;
            }
            if (l == 0L || this.currentScrollbar == null) {
                try {
                    this.wait(0L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            WinScrollbar winScrollbar = this.currentScrollbar;
            long l3 = l2 + l;
            long l4 = l3 - System.currentTimeMillis();
            while (this.currentScrollbar == winScrollbar && l4 > 0L) {
                try {
                    this.wait(l4);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                l4 = l3 - System.currentTimeMillis();
            }
            if (this.currentScrollbar == winScrollbar) continue;
            bl = false;
        }
    }

    private boolean doScroll(WinScrollbar winScrollbar, int n, int n2) {
        boolean bl = false;
        switch (n) {
            case 20: {
                bl = winScrollbar.lineUp(n2);
                break;
            }
            case 21: {
                bl = winScrollbar.lineDown(n2);
                break;
            }
            case 22: {
                if (this.continuePaging(winScrollbar, n, n2)) {
                    bl = winScrollbar.pageUp(n2);
                    break;
                }
                bl = true;
                break;
            }
            case 23: {
                if (this.continuePaging(winScrollbar, n, n2)) {
                    bl = winScrollbar.pageDown(n2);
                    break;
                }
                bl = true;
                break;
            }
        }
        return bl;
    }

    private boolean continuePaging(WinScrollbar winScrollbar, int n, int n2) {
        boolean bl = false;
        int[] nArray = winScrollbar.getDragBoxInfo();
        if (n2 < nArray[0]) {
            bl = n == 22;
        } else if (n2 >= nArray[0] + nArray[1]) {
            bl = n == 23;
        }
        return bl;
    }
}

