/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import sunsoft.jws.visual.rt.awt.RWHelper;
import sunsoft.jws.visual.rt.awt.RootWindow;
import sunsoft.jws.visual.rt.awt.VJPanel;
import sunsoft.jws.visual.rt.base.DesignerAccess;
import sunsoft.jws.visual.rt.base.Global;

public class RootDialog
extends Dialog
implements RootWindow {
    private RWHelper helper;
    private Thread eventThread;

    public RootDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initHelper();
    }

    public RootDialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        this.initHelper();
    }

    private void initHelper() {
        Class clazz = DesignerAccess.getRootWindowHelperClass();
        if (clazz != null) {
            try {
                this.helper = (RWHelper)clazz.newInstance();
                this.helper.setWindow(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void addImpl(Component component, Object object, int n) {
        if (component.getParent() != this) {
            super.addImpl(component, object, n);
        }
    }

    public void pack() {
        Container container = this.getParent();
        Boolean bl = this.isDisplayable();
        if (container != null && !container.isDisplayable()) {
            ((Component)container).addNotify();
        }
        if (bl.equals(false)) {
            this.addNotify();
        }
        Dimension dimension = this.getPreferredSize();
        Point point = this.getDialogLocation(dimension);
        if (Global.isMotif() && bl.equals(false)) {
            point.x -= dimension.width / 2;
            point.y -= dimension.height / 2;
        }
        this.setLocation(point.x, point.y);
        this.setSize(this.getPreferredSize());
        this.validate();
    }

    private Point getDialogLocation(Dimension dimension) {
        Frame frame = (Frame)this.getParent();
        Point point = frame.location();
        Dimension dimension2 = frame.size();
        Dimension dimension3 = dimension;
        point.x += (dimension2.width - dimension3.width) / 2;
        point.y += (dimension2.height - dimension3.height) / 2;
        return point;
    }

    public Insets insets() {
        Insets insets = (Insets)super.insets().clone();
        if (Global.isWindows()) {
            if (insets.top < 10) {
                insets.top = 25;
            }
            if (insets.bottom < 5) {
                insets.bottom = 5;
            }
            if (insets.left < 5) {
                insets.left = 5;
            }
            if (insets.right < 5) {
                insets.right = 5;
            }
        }
        return insets;
    }

    public boolean postEvent(Event event) {
        if (event.id == 203 || event.id == 204) {
            return true;
        }
        boolean bl = VJPanel.markEvent(event, this);
        boolean bl2 = super.postEvent(event);
        if (bl) {
            VJPanel.forwardEvent(event, this);
        }
        return bl2;
    }

    public void select() {
        if (this.helper != null) {
            this.helper.select();
        }
    }

    public void unselect() {
        if (this.helper != null) {
            this.helper.unselect();
        }
    }

    public void layoutMode() {
        if (this.helper != null) {
            this.helper.layoutMode();
        }
    }

    public void previewMode() {
        if (this.helper != null) {
            this.helper.previewMode();
        }
    }

    public Dimension previewSize() {
        if (this.helper != null) {
            return this.helper.previewSize();
        }
        return null;
    }

    public void addNotify() {
        Container container = this.getParent();
        if (container != null && container.getPeer() == null) {
            ((Component)container).addNotify();
        }
        if (this.helper != null) {
            this.helper.addNotify();
        }
        super.addNotify();
    }

    public void removeNotify() {
        if (Global.isWindows()) {
            this.reshapeZero(this);
        }
        if (this.helper != null) {
            this.helper.removeNotify();
        }
        super.removeNotify();
    }

    private void reshapeZero(Component component) {
        component.reshape(0, 0, 0, 0);
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = container.countComponents();
            for (int i = 0; i < n; ++i) {
                this.reshapeZero(container.getComponent(i));
            }
        }
    }

    public void layout() {
        if (this.helper != null) {
            this.helper.layout();
        }
        super.layout();
    }

    public void paint(Graphics graphics) {
        if (Global.isWindows()) {
            graphics = this.getGraphics();
        }
        if (this.helper != null) {
            this.helper.paint(graphics);
        }
        super.paint(graphics);
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (this.helper != null) {
            return this.helper.mouseDown(event, n, n2);
        }
        return false;
    }
}

