/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.Vector;
import sunsoft.jws.visual.rt.awt.CLChoice;
import sunsoft.jws.visual.rt.awt.CLComponent;
import sunsoft.jws.visual.rt.awt.ColumnList;
import sunsoft.jws.visual.rt.awt.ColumnListThread;
import sunsoft.jws.visual.rt.awt.EditLine;
import sunsoft.jws.visual.rt.awt.Scrollable;
import sunsoft.jws.visual.rt.awt.TextList;
import sunsoft.jws.visual.rt.awt.VJPanel;
import sunsoft.jws.visual.rt.base.Global;

class ColumnListCanvas
extends VJPanel
implements Scrollable {
    static final int LEFT_PAD = 4;
    static final int RIGHT_PAD = 4;
    private EditLine editline;
    private CLChoice editchoice;
    private boolean justCancelled;
    Window choiceMenuWindow;
    TextList choiceMenu;
    private int editrow = -1;
    private int editcolumn = -1;
    private boolean[] textEditable;
    private boolean applying;
    private boolean cancelApply;
    private Image buffer;
    private Dimension bufferSize;
    private Image[] bufferCache = new Image[3];
    private Dimension[] bufferSizeCache = new Dimension[3];
    ColumnList parent;
    Frame ourFrame = null;
    int columns;
    int charWidth;
    int rowHeight;
    Component hasComponents = null;
    int componentHeight = 0;
    int rowAscent;
    int headerHeight;
    int totalWidth;
    boolean dragging = false;
    int dragStart;
    int dragColumn;
    String[] headers;
    boolean showHeaders = true;
    boolean showVerticalLines = false;
    boolean showHorizontalLines = false;
    int[] formats = null;
    int[] dimensions;
    boolean autoWidth = true;
    int records;
    Vector labels;
    Vector rowColors;
    int requestedRows = 5;
    int requestedChars = 0;
    int dispRows;
    int visibleRows = -1;
    int scrollx = 0;
    int scrollrow = 0;
    int scrolly = 0;
    boolean highlightItems = false;
    Thread colorThread = null;
    boolean selectable = false;
    int selectedRow = -1;
    Color selectColor;
    boolean editable = true;
    private boolean cancelSelect;
    private static final int COLOR_NONE = 0;
    private static final int COLOR_FIRST = 4;
    boolean resizeCursor = false;
    boolean checkedFrame = false;

    public ColumnListCanvas(ColumnList columnList) {
        this.setLayout(null);
        this.parent = columnList;
        this.headers = new String[0];
        this.columns = 0;
        this.labels = new Vector();
        this.rowColors = new Vector();
        this.dimensions = null;
        this.dispRows = 0;
        this.records = 0;
        this.selectColor = new Color(0, 0, 128);
    }

    public void setTextEditable(boolean bl) {
        this.textEditable = this.ensureLength(this.textEditable, this.columns);
        for (int i = 0; i < this.textEditable.length; ++i) {
            this.textEditable[i] = bl;
        }
    }

    public void setTextEditable(int n, boolean bl) {
        if (n < 0 || n >= this.columns) {
            return;
        }
        this.textEditable = this.ensureLength(this.textEditable, n + 1);
        this.textEditable[n] = bl;
    }

    public boolean getTextEditable(int n) {
        if (this.textEditable == null || n < 0 || n >= this.textEditable.length) {
            return false;
        }
        return this.textEditable[n];
    }

    public boolean[] ensureLength(boolean[] blArray, int n) {
        if (blArray == null) {
            return new boolean[n];
        }
        if (blArray.length < n) {
            boolean[] blArray2 = new boolean[n];
            System.arraycopy(blArray, 0, blArray2, 0, blArray.length);
            blArray = blArray2;
        }
        return blArray;
    }

    public void cancelApply() {
        this.cancelApply = true;
    }

    public synchronized void cancelEdit() {
        if (this.editline != null || this.editchoice != null) {
            this.selectRow(this.editrow);
            if (this.editline != null) {
                this.editline.destroy();
                this.editline = null;
                this.justCancelled = true;
            } else {
                this.editchoice.cancelEdit();
                this.editchoice = null;
                this.justCancelled = true;
            }
            this.editrow = -1;
            this.editcolumn = -1;
            this.repaint();
        }
    }

    public int getEditRow() {
        return this.editrow;
    }

    public int getEditColumn() {
        return this.editcolumn;
    }

    public boolean applyChanges() {
        if (this.editchoice != null) {
            this.cancelEdit();
            return true;
        }
        if (this.editline != null) {
            this.editline.applyChanges();
            return !this.cancelApply;
        }
        return true;
    }

    public boolean startEdit(int n) {
        return this.startEdit(n, -1);
    }

    private synchronized boolean startEdit(int n, int n2) {
        if (this.editchoice != null) {
            return false;
        }
        if (this.editline != null) {
            return false;
        }
        if (n < 0 || n >= this.columns) {
            return false;
        }
        if (!this.getTextEditable(n)) {
            return false;
        }
        int n3 = this.getSelectedRow();
        if (n3 == -1) {
            return false;
        }
        Object object = ((Object[])this.labels.elementAt(n3))[n];
        if (object instanceof String) {
            String string = (String)object;
            this.editline = new EditLine(this, string, this.textX(string, n), this.textY(n3));
            this.editrow = n3;
            this.editcolumn = n;
            this.editline.paint(this.getBufferGraphics());
            this.copyBuffer();
        } else if (object instanceof CLChoice) {
            CLChoice cLChoice = (CLChoice)object;
            if (!cLChoice.getEditable()) {
                return false;
            }
            this.editchoice = cLChoice;
            this.editrow = n3;
            this.editcolumn = n;
        } else if (object instanceof CLComponent) {
            CLComponent cLComponent = (CLComponent)object;
            if (!cLComponent.getEditable()) {
                return false;
            }
            String string = cLComponent.getText();
            if (string != null) {
                int n4 = cLComponent.textX() + this.columnX(n);
                int n5 = cLComponent.textY() + this.rowY(n3);
                if (n2 != -1 && n2 < n4) {
                    return false;
                }
                this.editline = new EditLine(this, string, n4, n5);
                this.editrow = n3;
                this.editcolumn = n;
                this.editline.paint(this.getBufferGraphics());
                this.copyBuffer();
            }
        }
        if (this.editline != null) {
            this.selectRow(-1);
            return true;
        }
        return this.editchoice != null;
    }

    public int textX(String string, int n) {
        int n2;
        int n3 = -this.scrollx;
        for (n2 = 0; n2 < n; ++n2) {
            n3 += this.dimensions[n2];
        }
        n3 += 4;
        n2 = this.getFormat(n);
        if (n2 != 0) {
            int n4 = this.dimensions[n] - 4 - 4;
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n5 = fontMetrics.stringWidth(string);
            if (n2 == 2) {
                n3 += n4 - n5;
            } else if (n2 == 1) {
                n3 += (n4 - n5) / 2;
            }
        }
        return n3;
    }

    public int textY(int n) {
        return this.headerHeight + (n - this.scrollrow) * this.rowHeight + this.rowAscent;
    }

    protected void finalize() {
        if (this.colorThread != null) {
            this.colorThread.stop();
        }
    }

    public synchronized void setHeaders(String[] stringArray) {
        int n = stringArray == null ? 0 : stringArray.length;
        if (n != this.columns) {
            this.delItems();
            this.labels = new Vector();
            this.rowColors = new Vector();
            this.formats = null;
            this.dimensions = null;
        }
        this.columns = stringArray == null ? 0 : stringArray.length;
        this.headers = stringArray;
        this.dimensions = null;
        this.cacheDimensions();
        this.repaint();
    }

    public void setFormats(int[] nArray) {
        this.formats = nArray;
    }

    public int getFormat(int n) {
        if (this.formats == null || n < 0 || n >= this.formats.length) {
            return 0;
        }
        return this.formats[n];
    }

    public void setSelectable(boolean bl) {
        this.selectable = bl;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public void setHighlightItems(boolean bl) {
        this.highlightItems = bl;
    }

    public void setHighlighted(int n, boolean bl) {
        if (n < 0 || n >= this.records) {
            return;
        }
        if (bl) {
            this.rowColors.setElementAt(new Integer(4), n);
            if (this.highlightItems) {
                if (this.colorThread == null) {
                    this.colorThread = new ColumnListThread(this);
                    this.colorThread.start();
                } else {
                    this.colorThread.resume();
                }
            }
        } else {
            this.rowColors.setElementAt(new Integer(0), n);
        }
    }

    public boolean getHighlighted(int n) {
        if (n < 0 || n >= this.records) {
            return false;
        }
        int n2 = (Integer)this.rowColors.elementAt(n);
        return n2 != 0;
    }

    public void setShowHeaders(boolean bl) {
        this.showHeaders = bl;
        this.repaint();
    }

    public void setShowVerticalLines(boolean bl) {
        this.showVerticalLines = bl;
        this.repaint();
    }

    public void setShowHorizontalLines(boolean bl) {
        this.showHorizontalLines = bl;
        this.repaint();
    }

    public void setAutoWidth(boolean bl) {
        this.autoWidth = bl;
    }

    public void scrollX(int n) {
        if (this.scrollApply()) {
            this.scrollx = n;
            this.repaint();
        } else {
            this.parent.setHBarValue(this.scrollx);
        }
    }

    public void scrollY(int n) {
        if (this.scrollApply()) {
            this.scrolly = n;
            this.scrollrow = this.rowHeight != 0 ? (n + this.rowHeight - 1) / this.rowHeight : 0;
            this.repaint();
        } else {
            this.parent.setVBarValue(this.scrolly);
        }
    }

    private boolean scrollApply() {
        boolean bl = true;
        if (!this.applying) {
            this.applying = true;
            bl = this.applyChanges();
            if (!bl && Global.isMotif()) {
                this.cancelEdit();
            }
            this.applying = false;
        }
        return bl;
    }

    public Dimension scrollSize() {
        this.cacheDimensions();
        if (this.dimensions == null) {
            return new Dimension(100, 100);
        }
        return new Dimension(this.totalWidth, this.rowHeight * this.records);
    }

    public Dimension viewSize(Dimension dimension) {
        this.cacheDimensions();
        dimension.height -= this.headerHeight;
        return dimension;
    }

    public int lineHeight() {
        this.cacheDimensions();
        return this.rowHeight;
    }

    private synchronized void addMoreLabels() {
        Object[] objectArray = new Object[this.columns + 1];
        this.labels.addElement(objectArray);
        this.rowColors.addElement(new Integer(0));
        for (int i = 0; i < this.columns; ++i) {
            objectArray[i] = "";
        }
        objectArray[this.columns] = null;
    }

    private void ensureCapacity(int n) {
        while (n >= this.labels.size()) {
            this.addMoreLabels();
        }
    }

    private void growRecords(int n) {
        while (n > this.records) {
            Object[] objectArray = (Object[])this.labels.elementAt(this.records);
            for (int i = 0; i < this.columns; ++i) {
                objectArray[i] = "";
            }
            objectArray[this.columns] = null;
            this.rowColors.setElementAt(new Integer(0), this.records);
            ++this.records;
        }
    }

    public synchronized void insertItem(Object[] objectArray, int n) {
        boolean bl = false;
        this.ensureCapacity(n);
        this.growRecords(n);
        this.ensureCapacity(this.records + 1);
        this.growRecords(this.records + 1);
        for (int i = this.records - 2; n <= i; --i) {
            this.labels.setElementAt(this.labels.elementAt(i), i + 1);
            this.rowColors.setElementAt(this.rowColors.elementAt(i), i + 1);
        }
        Object[] objectArray2 = new Object[this.columns + 1];
        for (int i = 0; i < this.columns; ++i) {
            objectArray2[i] = "";
        }
        objectArray2[this.columns] = null;
        this.labels.setElementAt(objectArray2, n);
        if (this.selectedRow >= n) {
            ++this.selectedRow;
        }
        this.addItem(objectArray, n);
    }

    public synchronized void addItem(Object[] objectArray) {
        this.addItem(objectArray, this.records);
    }

    public synchronized void addItem(Object[] objectArray, int n) {
        this.ensureCapacity(n);
        this.growRecords(n);
        if (this.autoWidth) {
            this.cacheDimensions();
        }
        Object[] objectArray2 = (Object[])this.labels.elementAt(n);
        for (int i = 0; i < this.columns; ++i) {
            objectArray2[i] = objectArray[i];
            if (objectArray[i] instanceof CLComponent) {
                ((CLComponent)objectArray[i]).setCanvas(this, n, i);
            }
            this.checkComponentCell(objectArray[i]);
        }
        objectArray2[this.columns] = objectArray.length > this.columns ? objectArray[this.columns] : null;
        this.adjustColumnWidths(n);
        if (this.highlightItems) {
            this.rowColors.setElementAt(new Integer(4), n);
            if (this.colorThread == null) {
                this.colorThread = new ColumnListThread(this);
                this.colorThread.start();
            } else {
                this.colorThread.resume();
            }
        } else {
            this.rowColors.setElementAt(new Integer(0), n);
        }
        if (n >= this.records) {
            ++this.records;
        }
    }

    private void adjustColumnWidths(int n) {
        if (!this.autoWidth || this.dimensions == null) {
            return;
        }
        Object[] objectArray = (Object[])this.labels.elementAt(n);
        for (int i = 0; i < this.columns; ++i) {
            this.adjustColumnWidths(objectArray[i], i);
        }
    }

    void adjustColumnWidths(Object object, int n) {
        int n2;
        if (!this.autoWidth || object == null || this.dimensions == null) {
            return;
        }
        int n3 = this.labelWidth(object);
        if (n3 > (n2 = this.dimensions[n])) {
            this.totalWidth += n3 - n2;
            int n4 = n;
            this.dimensions[n4] = this.dimensions[n4] + (n3 - n2);
        }
    }

    private void checkComponentCell(Object object) {
        if (object instanceof Component) {
            if (this.hasComponents == null) {
                this.hasComponents = (Component)object;
            }
            this.add((Component)object);
            ((Component)object).hide();
            Dimension dimension = ((Component)object).preferredSize();
            if (dimension.height > this.componentHeight) {
                this.componentHeight = dimension.height;
                if (this.componentHeight > this.rowHeight) {
                    this.rowAscent += (this.componentHeight - this.rowHeight) / 2;
                    this.rowHeight = this.componentHeight + 2;
                }
            }
        }
    }

    public synchronized void delItems() {
        this.delItems(0, this.records - 1);
        this.selectedRow = -1;
    }

    public synchronized void delItems(int n, int n2) {
        if (n < 0 || n >= this.records) {
            return;
        }
        if (n2 < n) {
            return;
        }
        if (n2 > this.records) {
            n2 = this.records - 1;
        }
        int n3 = n2 - n + 1;
        for (int i = n; i <= n2; ++i) {
            Object[] objectArray = (Object[])this.labels.elementAt(n);
            for (int j = 0; j < this.columns; ++j) {
                if (objectArray[j] instanceof Component) {
                    this.remove((Component)objectArray[j]);
                    continue;
                }
                if (!(objectArray[j] instanceof CLComponent)) continue;
                ((CLComponent)objectArray[j]).setCanvas(null, -1, -1);
            }
            this.labels.removeElementAt(n);
            this.rowColors.removeElementAt(n);
        }
        this.records -= n3;
        if (this.selectedRow > n2) {
            this.selectedRow -= n3;
        } else if (this.selectedRow > n) {
            this.selectedRow = n - 1;
        }
        this.repaint();
    }

    protected Object getItem(int n, int n2) {
        if (n > this.records || n < 0 || n2 > this.columns || n2 < 0) {
            return null;
        }
        return ((Object[])this.labels.elementAt(n))[n2];
    }

    protected synchronized boolean putItem(int n, int n2, Object object) {
        if (n > this.records || n < 0 || n2 > this.columns || n2 < 0) {
            return false;
        }
        Object[] objectArray = (Object[])this.labels.elementAt(n);
        objectArray[n2] = object;
        if (object instanceof CLComponent) {
            ((CLComponent)object).setCanvas(this, n, n2);
        }
        if (n2 < this.columns) {
            this.checkComponentCell(object);
            this.adjustColumnWidths(object, n2);
        }
        this.repaint();
        return true;
    }

    protected boolean swapItems(int n, int n2) {
        if (n > this.records || n < 0 || n2 > this.records || n2 < 0) {
            return false;
        }
        if (n == n2) {
            return true;
        }
        Object[] objectArray = (Object[])this.labels.elementAt(n);
        Object[] objectArray2 = (Object[])this.labels.elementAt(n2);
        this.labels.setElementAt(objectArray2, n);
        this.labels.setElementAt(objectArray, n2);
        this.repaint();
        return true;
    }

    public String chopText(String string, int n) {
        int n2;
        if (n <= 0) {
            return "";
        }
        FontMetrics fontMetrics = this.getFontMetrics();
        int n3 = this.getTextCutoff(fontMetrics, n, string, n2 = string.length(), 0, n2);
        if (n3 == n2) {
            return string;
        }
        return string.substring(0, n3);
    }

    private int getTextCutoff(FontMetrics fontMetrics, int n, String string, int n2, int n3, int n4) {
        if (n3 == n4) {
            return n3;
        }
        if (n3 == n4 - 1) {
            int n5 = fontMetrics.stringWidth(string.substring(0, n4));
            if (n5 < n) {
                return n4;
            }
            return n3;
        }
        int n6 = fontMetrics.stringWidth(string.substring(0, n2));
        if (n6 == n) {
            return n2;
        }
        if (n6 < n) {
            return this.getTextCutoff(fontMetrics, n, string, n2 + (n4 - n2) / 2, n2, n4);
        }
        return this.getTextCutoff(fontMetrics, n, string, n2 - (n2 - n3) / 2, n3, n2);
    }

    public void drawString(Graphics graphics, String string, int n, int n2, int n3, int n4) {
        string = this.chopText(string, n3);
        graphics.setFont(this.getFont());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n5 = fontMetrics.stringWidth(string);
        if (n5 <= 0) {
            return;
        }
        if (n4 == 2) {
            n += n3 - n5;
        } else if (n4 == 1) {
            n += (n3 - n5) / 2;
        }
        graphics.drawString(string, n, n2);
    }

    public FontMetrics getFontMetrics() {
        return this.getFontMetrics(this.getFont());
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.dimensions = null;
        this.cacheDimensions();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    private int labelWidth(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Component) {
            return ((Component)object).preferredSize().width + 4 + 4;
        }
        if (object instanceof String) {
            String string = (String)object;
            Graphics graphics = this.getBufferGraphics();
            graphics.setFont(this.getFont());
            FontMetrics fontMetrics = graphics.getFontMetrics();
            return fontMetrics.stringWidth(string) + 4 + 4;
        }
        if (object instanceof CLComponent) {
            Dimension dimension = ((CLComponent)object).size();
            if (dimension != null) {
                return dimension.width;
            }
            return 0;
        }
        return 0;
    }

    private void cacheDimensions() {
        if (this.dimensions != null) {
            return;
        }
        Graphics graphics = this.getBufferGraphics();
        if (graphics == null) {
            return;
        }
        graphics.setFont(this.getFont());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        this.rowHeight = fontMetrics.getHeight() + 3;
        this.rowAscent = fontMetrics.getAscent() + 2;
        if (Global.isWindows() && this.showHorizontalLines) {
            ++this.rowHeight;
        } else if (Global.isMotif() && !this.showHorizontalLines) {
            --this.rowHeight;
        }
        this.charWidth = fontMetrics.charWidth('X');
        if (this.componentHeight == 0 && this.hasComponents != null) {
            this.componentHeight = this.hasComponents.preferredSize().height;
        }
        if (this.rowHeight < this.componentHeight) {
            this.rowAscent += (this.componentHeight - this.rowHeight) / 2;
            this.rowHeight = this.componentHeight;
        }
        this.headerHeight = this.showHeaders ? this.rowHeight + 6 : 0;
        this.dimensions = new int[this.columns == 0 ? 1 : this.columns];
        this.totalWidth = 0;
        for (int i = 0; i < this.columns; ++i) {
            int n = fontMetrics.stringWidth(this.headers[i]) + 10;
            if (this.autoWidth) {
                for (int j = 0; j < this.records; ++j) {
                    Object[] objectArray = (Object[])this.labels.elementAt(j);
                    int n2 = this.labelWidth(objectArray[i]);
                    if (n2 <= n) continue;
                    n += n2 - n;
                }
            }
            this.dimensions[i] = n;
            this.totalWidth += this.dimensions[i];
        }
    }

    public void paint(Graphics graphics) {
        if (Global.isWindows()) {
            graphics = this.getGraphics();
        }
        this.paint(graphics, null);
    }

    private synchronized void paint(Graphics graphics, Rectangle rectangle) {
        int n;
        int n2;
        int n3;
        int n4;
        Image image = this.getBuffer(this.size());
        graphics = image.getGraphics();
        graphics.setFont(this.getFont());
        this.cacheDimensions();
        Dimension dimension = this.size();
        int n5 = dimension.height - this.headerHeight;
        int n6 = dimension.width;
        this.dispRows = n5 / this.rowHeight;
        this.visibleRows = (n5 + this.rowHeight - 1) / this.rowHeight;
        int n7 = this.scrollx;
        int n8 = this.scrollrow;
        while (this.visibleRows + n8 > this.labels.size()) {
            this.addMoreLabels();
        }
        graphics.setColor(this.getForeground());
        Color color = graphics.getColor();
        Color color2 = this.getBackground().darker();
        Color color3 = color2.darker();
        int n9 = 0;
        if (this.showHeaders) {
            for (n4 = 0; n4 <= this.columns; ++n4) {
                n3 = n4 == this.columns ? n6 - n9 + n7 : this.dimensions[n4];
                n2 = n9 - n7;
                int n10 = n2 + n3 - 1;
                n = this.headerHeight - 1;
                if (n3 > 0 && (n10 > 0 || n2 < n6)) {
                    graphics.setColor(this.getBackground());
                    graphics.drawLine(n2, 0, n10, 0);
                    graphics.drawLine(n2, 0, n2, n);
                    graphics.setColor(color3);
                    graphics.drawLine(n2, n, n10, n);
                    graphics.drawLine(n10, 0, n10, n);
                    graphics.setColor(color2);
                    graphics.fillRect(n2 + 1, 1, n3 - 2, this.headerHeight - 2);
                    graphics.setColor(color);
                    if (n4 != this.columns) {
                        this.drawString(graphics, this.headers[n4], n2 + 4, this.headerHeight - 5, n3 - 4 - 4, this.getFormat(n4));
                    }
                }
                if (n4 == this.columns) continue;
                n9 += this.dimensions[n4];
            }
        }
        n4 = this.headerHeight;
        for (n2 = 0; n2 < this.labels.size(); ++n2) {
            Object[] objectArray;
            if (n2 >= n8 && n2 < this.visibleRows + n8) {
                n9 = 0;
                objectArray = (Object[])this.labels.elementAt(n2);
                n = (Integer)this.rowColors.elementAt(n2);
                Color color4 = this.getStringForeground(color, n2, n);
                Color color5 = this.getStringBackground(n2, n);
                graphics.setColor(color5);
                graphics.fillRect(0, n4, n6, this.rowHeight);
                graphics.setColor(color4);
                for (int i = 0; i < this.columns; ++i) {
                    Component component;
                    n3 = this.dimensions[i];
                    int n11 = n9 - n7;
                    int n12 = n11 + n3 - 1;
                    if (n3 > 0 && (n12 > 0 || n11 < n6)) {
                        if (objectArray[i] != null) {
                            if (objectArray[i] instanceof String) {
                                this.drawString(graphics, (String)objectArray[i], n11 + 4, n4 + this.rowAscent, n3 - 4 - 4, this.getFormat(i));
                            } else if (objectArray[i] instanceof CLComponent) {
                                ((CLComponent)objectArray[i]).paint(graphics, n11, n4, n3, this.rowHeight, this.rowAscent, this.getFormat(i));
                            } else if (objectArray[i] instanceof Component) {
                                component = (Component)objectArray[i];
                                Dimension dimension2 = component.preferredSize();
                                dimension2 = new Dimension(dimension2.width, dimension2.height);
                                if (dimension2.width > n3 - 2) {
                                    dimension2.width = n3 - 2;
                                }
                                component.reshape(n11 + 2, n4, dimension2.width, this.rowHeight);
                                component.setBackground(color5);
                                component.setForeground(color4);
                                component.show();
                            } else {
                                this.drawString(graphics, objectArray[i].toString(), n11 + 4, n4 + this.rowAscent, n3 - 4 - 4, this.getFormat(i));
                            }
                        }
                    } else if (objectArray[i] != null && objectArray[i] instanceof Component) {
                        component = (Component)objectArray[i];
                        component.hide();
                    }
                    n9 += this.dimensions[i];
                }
                n4 += this.rowHeight;
                if (this.showHorizontalLines) {
                    graphics.setColor(color2);
                    graphics.drawLine(0, n4 - 1, n6, n4 - 1);
                }
                graphics.setColor(color);
                continue;
            }
            objectArray = (Object[])this.labels.elementAt(n2);
            for (n = 0; n < objectArray.length; ++n) {
                if (!(objectArray[n] instanceof Component)) continue;
                ((Component)objectArray[n]).hide();
            }
        }
        if (this.showVerticalLines) {
            int n13;
            graphics.setColor(color2);
            n9 = 0;
            for (n2 = 0; n2 < this.columns && (n = (n13 = n9 - n7) + (n3 = this.dimensions[n2]) - 1) <= n6; ++n2) {
                if (n3 > 0 && n > 0) {
                    graphics.drawLine(n, this.headerHeight, n, dimension.height);
                }
                n9 += this.dimensions[n2];
            }
        }
        if (this.editline != null) {
            this.editline.paint(graphics);
        }
        this.copyBuffer();
    }

    private Image getBuffer(Dimension dimension) {
        if (dimension.width == 0 || dimension.height == 0) {
            dimension = this.buffer != null && this.bufferSize != null ? new Dimension(this.bufferSize) : new Dimension(1, 1);
        }
        if (this.buffer == null || this.bufferSize == null || dimension.width != this.bufferSize.width || dimension.height != this.bufferSize.height) {
            this.getCachedBuffer(dimension);
            if (this.buffer == null || this.bufferSize == null || dimension.width != this.bufferSize.width || dimension.height != this.bufferSize.height) {
                this.buffer = this.createImage(dimension.width, dimension.height);
                this.updateCache(this.buffer, dimension);
            }
            this.bufferSize = dimension;
        }
        return this.buffer;
    }

    private Graphics getBufferGraphics() {
        Image image = this.getBuffer(this.size());
        if (image == null) {
            return null;
        }
        return image.getGraphics();
    }

    private void copyBuffer() {
        Graphics graphics = this.getGraphics();
        Image image = this.getBuffer(this.size());
        if (graphics != null && image != null) {
            graphics.drawImage(image, 0, 0, this);
        }
    }

    private void getCachedBuffer(Dimension dimension) {
        for (int i = 0; i < 3; ++i) {
            if (this.bufferSizeCache[i] == null || this.bufferSizeCache[i].width != dimension.width || this.bufferSizeCache[i].height != dimension.height) continue;
            this.buffer = this.bufferCache[i];
            this.bufferSize = this.bufferSizeCache[i];
            break;
        }
    }

    private void updateCache(Image image, Dimension dimension) {
        int n;
        if (image == null) {
            return;
        }
        for (n = 0; n < 3 && this.bufferSizeCache[n] != null; ++n) {
        }
        if (n < 3) {
            this.bufferCache[n] = image;
            this.bufferSizeCache[n] = new Dimension(dimension.width, dimension.height);
        } else {
            this.bufferCache[0] = this.bufferCache[1];
            this.bufferCache[1] = this.bufferCache[2];
            this.bufferCache[2] = image;
            this.bufferSizeCache[0] = this.bufferSizeCache[1];
            this.bufferSizeCache[1] = this.bufferSizeCache[2];
            this.bufferSizeCache[2] = new Dimension(dimension.width, dimension.height);
        }
    }

    private Color getStringForeground(Color color, int n, int n2) {
        if (n == this.selectedRow) {
            return this.getBackground();
        }
        return color;
    }

    private Color getStringBackground(int n, int n2) {
        Color color = this.getBackground();
        if (n == this.selectedRow) {
            if (n2 != 0) {
                if (color == Color.white) {
                    return Color.magenta;
                }
                return this.selectColor.darker();
            }
            return this.selectColor;
        }
        if (n2 != 0) {
            if (color == Color.white) {
                return Color.orange;
            }
            return color.darker();
        }
        return this.getBackground();
    }

    private boolean rowVisible(int n) {
        return n >= this.scrollrow && n < this.scrollrow + this.dispRows;
    }

    public void updateView() {
        this.parent.updateView();
    }

    public void setDisplayRows(int n) {
        this.requestedRows = n;
    }

    public void setVisibleChars(int n) {
        this.requestedChars = n;
    }

    public Dimension minimumSize() {
        return this.preferredSize();
    }

    public Dimension preferredSize() {
        this.cacheDimensions();
        if (this.dimensions == null) {
            return new Dimension(100, 100);
        }
        if (this.requestedChars == 0) {
            return new Dimension(this.totalWidth, this.headerHeight + this.rowHeight * this.requestedRows);
        }
        return new Dimension(this.requestedChars * this.charWidth, this.headerHeight + this.rowHeight * this.requestedRows);
    }

    public int selectRow(int n) {
        if (this.selectedRow != n) {
            int n2 = this.selectedRow;
            this.selectedRow = n < this.records ? n : -1;
            if (this.selectedRow != -1 && !this.rowVisible(this.selectedRow)) {
                this.parent.makeVisible(this.selectedRow);
            }
            if (this.rowVisible(n2) || this.rowVisible(this.selectedRow)) {
                this.repaint();
            }
        }
        return this.selectedRow;
    }

    public int getSelectedRow() {
        return this.selectedRow;
    }

    protected int getRowY(int n) {
        if (this.dimensions == null || this.visibleRows == -1) {
            return -2;
        }
        if (this.rowVisible(n)) {
            return this.headerHeight + this.rowHeight * (n - this.scrollrow);
        }
        return -1;
    }

    private synchronized void startDrag(int n) {
        int n2 = -this.scrollx;
        for (int i = 0; i < this.columns; ++i) {
            if (n < (n2 += this.dimensions[i]) - 5 || n > n2 + 5) continue;
            this.dragColumn = i;
            this.dragging = true;
            this.dragStart = n;
            break;
        }
    }

    private synchronized int mouseColumn(int n) {
        int n2 = -this.scrollx;
        if (n < n2) {
            return -1;
        }
        for (int i = 0; i < this.columns; ++i) {
            if (n >= (n2 += this.dimensions[i])) continue;
            return i;
        }
        return -1;
    }

    private synchronized void dragColumn(int n) {
        int n2 = n - this.dragStart;
        if (this.dimensions[this.dragColumn] + n2 >= 5) {
            int n3 = this.dragColumn;
            this.dimensions[n3] = this.dimensions[n3] + n2;
            this.totalWidth += n2;
            this.dragStart = n;
            this.repaint();
        }
    }

    public boolean handleEvent(Event event) {
        if (this.editchoice == null && this.justCancelled && event.id == 501) {
            this.justCancelled = false;
            return true;
        }
        this.justCancelled = false;
        if (this.editline != null && this.editline.handleEvent(event)) {
            return true;
        }
        if (this.editchoice != null && this.editchoice.handleEvent(event)) {
            return true;
        }
        if (event.id == 87000 && event.target == this.editline) {
            if (event.arg != null) {
                this.paint(this.getGraphics(), (Rectangle)event.arg);
            } else {
                this.editline.paint(this.getBufferGraphics());
                this.copyBuffer();
            }
        } else if (event.id == 87001 && event.target == this.editline) {
            this.cancelApply = false;
            this.parent.postEvent(new Event(this.parent, 4864, event.arg));
            if (!this.cancelApply) {
                this.changeText((String)event.arg, this.editrow, this.editcolumn);
                this.cancelEdit();
            } else if (this.editline != null) {
                this.editline.cancelApply();
            }
        } else if (event.id == 87002 && event.target == this.editline) {
            this.cancelEdit();
        } else if (event.id == 87001 && event.target == this.editchoice) {
            this.cancelApply = false;
            this.parent.postEvent(new Event(this.parent, 4864, event.arg));
            if (!this.cancelApply) {
                this.changeText((String)event.arg, this.editrow, this.editcolumn);
                this.cancelEdit();
            }
        } else {
            return super.handleEvent(event);
        }
        return true;
    }

    public synchronized void changeText(String string, int n, int n2) {
        if (n < 0 || n >= this.records || n2 < 0 || n2 >= this.columns) {
            return;
        }
        Object[] objectArray = (Object[])this.labels.elementAt(n);
        Object object = objectArray[n2];
        if (object instanceof String) {
            objectArray[n2] = string;
            this.adjustColumnWidths(string, n2);
            this.parent.updateView();
        } else if (object instanceof CLComponent) {
            ((CLComponent)object).setText(string, true);
        }
    }

    public int columnX(int n) {
        int n2 = -this.scrollx;
        for (int i = 0; i < n; ++i) {
            n2 += this.dimensions[i];
        }
        return n2;
    }

    public int columnWidth(int n) {
        return this.dimensions[n];
    }

    public int rowY(int n) {
        return this.headerHeight + (n - this.scrollrow) * this.rowHeight;
    }

    public int rowHeight(int n) {
        return this.rowHeight;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (this.editline != null) {
            if (!this.applyChanges()) {
                return false;
            }
            this.selectRow(-1);
        } else if (this.editchoice != null) {
            this.cancelEdit();
            this.selectRow(-1);
        }
        if (n2 > this.headerHeight) {
            int n3 = (n2 - this.headerHeight - 1) / this.rowHeight + this.scrollrow;
            if (n3 < this.records) {
                Object object;
                int n4 = this.mouseColumn(n);
                if (n4 != -1 && (object = ((Object[])this.labels.elementAt(n3))[n4]) instanceof CLComponent && this.editable) {
                    CLComponent cLComponent = (CLComponent)object;
                    Event event2 = new Event(event.target, event.when, event.id, n - this.columnX(n4), n2 - this.rowY(n3), event.key, event.modifiers, event.arg);
                    event2.clickCount = event.clickCount;
                    if (cLComponent.mouseDown(event2)) {
                        return true;
                    }
                }
                if (this.selectable) {
                    this.cancelSelect = false;
                    if (event.clickCount == 1) {
                        if (n3 == this.getSelectedRow() && this.getTextEditable(n4)) {
                            this.cancelEdit();
                            if (this.startEdit(n4, n)) {
                                return true;
                            }
                        }
                        this.parent.postEvent(new Event(this.parent, 4863, new Integer(n3)));
                        if (!this.cancelSelect) {
                            n3 = this.selectRow(n3);
                            this.parent.postEvent(new Event(this.parent, 701, new Integer(n3)));
                        }
                    } else if (event.clickCount == 2) {
                        n3 = this.selectRow(n3);
                        this.parent.postEvent(new Event(this.parent, 1001, new Integer(n3)));
                    }
                }
            }
        } else if (n2 < this.headerHeight) {
            this.startDrag(n);
        }
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (this.dragging) {
            this.dragColumn(n);
            return true;
        }
        return false;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (this.dragging) {
            this.dragging = false;
            this.parent.updateView();
            return true;
        }
        return false;
    }

    private Frame getFrame() {
        if (this.ourFrame == null && !this.checkedFrame) {
            this.checkedFrame = true;
            for (Container container = this.parent; container != null; container = container.getParent()) {
                if (!(container instanceof Frame)) continue;
                this.ourFrame = (Frame)container;
                break;
            }
        }
        return this.ourFrame;
    }

    public boolean mouseMove(Event event, int n, int n2) {
        if (this.getFrame() != null) {
            boolean bl = false;
            if (n2 < this.headerHeight) {
                int n3 = -this.scrollx;
                for (int i = 0; i < this.columns; ++i) {
                    if (n < (n3 += this.dimensions[i]) - 5 || n > n3 + 5) continue;
                    bl = true;
                    break;
                }
            }
            if (bl != this.resizeCursor) {
                if (bl) {
                    this.ourFrame.setCursor(11);
                } else {
                    this.ourFrame.setCursor(0);
                }
                this.resizeCursor = bl;
            }
            return true;
        }
        return false;
    }

    public boolean mouseExit(Event event, int n, int n2) {
        if (this.resizeCursor) {
            this.ourFrame.setCursor(0);
            this.resizeCursor = false;
        }
        return false;
    }

    public synchronized boolean updateRowColors() {
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < this.records; ++i) {
            int n = (Integer)this.rowColors.elementAt(i);
            if (n == 0) continue;
            if (n == 1) {
                bl2 = true;
            }
            bl = true;
            this.rowColors.setElementAt(new Integer(n - 1), i);
        }
        if (bl2) {
            this.repaint();
        }
        return bl;
    }

    void cancelSelect() {
        this.cancelSelect = true;
    }
}

