/*
 * Copyright 2007 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#ifndef	_BITSET_H
#define	_BITSET_H

#pragma ident	"@(#)bitset.h	1.1	07/03/01 SMI"

#ifdef	__cplusplus
extern "C" {
#endif

#if (defined(_KERNEL) || defined(_KMEMUSER))
#include <sys/bitmap.h>
#include <sys/types.h>

typedef struct bitset {
	ulong_t	*bs_set;
	uint_t	bs_words;
} bitset_t;

/*
 * Bitset initialiation / teardown
 */
void		bitset_init(bitset_t *);
void		bitset_fini(bitset_t *);

/*
 * Resize / query a bitset's holding capacity
 */
void		bitset_resize(bitset_t *, uint_t);
uint_t		bitset_capacity(bitset_t *);

/*
 * Set / clear a bit in the set
 */
void		bitset_add(bitset_t *, uint_t);
void		bitset_del(bitset_t *, uint_t);

/*
 * Bitset queries
 */
int		bitset_in_set(bitset_t *, uint_t);
int		bitset_is_null(bitset_t *);
uint_t		bitset_find(bitset_t *);


#endif	/* !_KERNEL && !_KMEMUSER */

#ifdef	__cplusplus
}
#endif

#endif /* _BITSET_H */
