/*
 * Copyright 2007 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 *
 * This D script is used as an example in the Solaris Dynamic Tracing Guide
 * in Chapter 26, "sched Provider".
 *
 * The full text of Chapter 26 may be found here:
 *
 *   http://docs.sun.com/db/doc/817-6223?a=view
 *
 * On machines that have DTrace installed, this script is available as
 * qlen.d in /usr/demo/dtrace, a directory that contains all D scripts
 * used in the Solaris Dynamic Tracing Guide.  A table of the scripts and their
 * corresponding chapters may be found here:
 *
 *   file:///usr/demo/dtrace/index.html
 */

sched:::enqueue
{
	this->len = qlen[args[2]->cpu_id]++;
	@[args[2]->cpu_id] = lquantize(this->len, 0, 100);
}

sched:::dequeue
/qlen[args[2]->cpu_id]/
{
	qlen[args[2]->cpu_id]--;
}
