/*
 * Decompiled with CFR 0.152.
 */
package com.sun.solaris.service.logging;

import com.sun.solaris.service.exception.SuccinctStackTraceFormatter;
import com.sun.solaris.service.logging.Facility;
import com.sun.solaris.service.logging.Severity;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public final class SyslogHandler
extends Handler {
    private String ident;
    private Facility facility;
    private static SyslogHandler instance = null;
    private static boolean useStackTraces = true;
    private static final int DEF_LOGOPT = 0;
    private boolean useLoggerName = false;
    private boolean useShortLoggerName = true;

    private SyslogHandler(String string, Facility facility) {
        if (string == null || facility == null) {
            throw new IllegalArgumentException();
        }
        this.ident = string;
        this.facility = facility;
        SyslogHandler.openlog(string, 0, facility.getNative());
        instance = this;
    }

    public static SyslogHandler getInstance(String string, Facility facility) {
        if (instance != null) {
            if (!SyslogHandler.instance.ident.equals(string) || !SyslogHandler.instance.facility.equals(facility)) {
                throw new IllegalArgumentException();
            }
            return instance;
        }
        instance = new SyslogHandler(string, facility);
        return instance;
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        return "SyslogHandler(" + this.ident + ", " + this.facility.toString() + ")";
    }

    private static native void syslog(int var0, String var1);

    private static native void openlog(String var0, int var1, int var2);

    private static native void closelog();

    public void publish(LogRecord logRecord) {
        Severity severity = logRecord.getLevel() instanceof Severity ? (Severity)logRecord.getLevel() : Severity.severityForLevel(logRecord.getLevel());
        if (this.getLevel().intValue() > severity.intValue()) {
            return;
        }
        if (severity == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = logRecord.getLoggerName();
        if (this.useLoggerName) {
            if (string != null) {
                stringBuffer.append("(");
                stringBuffer.append(logRecord.getLoggerName());
                stringBuffer.append(") ");
            }
        } else if (this.useShortLoggerName && string != null) {
            stringBuffer.append("(");
            int n = string.lastIndexOf(46);
            if (n >= 0) {
                string = string.substring(n + 1);
            }
            stringBuffer.append(string);
            stringBuffer.append(") ");
        }
        stringBuffer.append(logRecord.getMessage());
        if (logRecord.getThrown() != null && useStackTraces) {
            stringBuffer.append(" ");
            stringBuffer.append(SuccinctStackTraceFormatter.formatWithDescription(logRecord.getThrown(), "with tracing information: ").toString());
        }
        SyslogHandler.syslog(severity.getNative(), stringBuffer.toString());
    }

    public void flush() {
    }

    public void close() throws SecurityException {
        if (instance != null) {
            SyslogHandler.closelog();
            instance = null;
        }
    }

    public void setFormatter(Formatter formatter) {
        throw new IllegalArgumentException();
    }

    public String getIdent() {
        return this.ident;
    }

    public Facility getFacility() {
        return this.facility;
    }

    static {
        System.loadLibrary("jsyslog");
    }
}

